/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class PositionTrackingInputStream
extends PushbackInputStream {
    long currentOffset = 0L;
    boolean endOfStream = false;

    public PositionTrackingInputStream(InputStream in, int size) {
        super(in, size);
    }

    public PositionTrackingInputStream(InputStream in) {
        super(in);
    }

    public long getCurrentOffset() {
        return this.currentOffset;
    }

    public boolean isEndOfStreamReached() {
        return this.endOfStream;
    }

    public byte getNextByte() throws IOException {
        int datum = this.read();
        if (-1 == datum) {
            this.endOfStream = true;
        }
        return (byte)datum;
    }

    public int readFully(byte[] dest) throws IOException {
        int offset;
        int numRead;
        for (offset = 0; offset < dest.length; offset += numRead) {
            numRead = this.read(dest, offset, dest.length - offset);
            if (-1 != numRead) continue;
            return offset;
        }
        return offset;
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        if (val == -1) {
            this.endOfStream = true;
        } else {
            ++this.currentOffset;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numRead = super.read(b, off, len);
        if (-1 == numRead) {
            this.endOfStream = true;
        } else {
            this.currentOffset += (long)numRead;
        }
        return numRead;
    }

    @Override
    public void unread(int b) throws IOException {
        super.unread(b);
        --this.currentOffset;
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        super.unread(b, off, len);
        this.currentOffset -= (long)len;
    }

    @Override
    public void unread(byte[] b) throws IOException {
        super.unread(b);
        this.currentOffset -= (long)b.length;
    }
}

