/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.search.processors;

import com.splunk.io.FastByteArrayOutputStream;
import com.splunk.io.SearchMetricsReporter;
import com.splunk.mr.AsyncMRJob;
import com.splunk.mr.JobSubmitterInputFormat;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.SplunkdProcess;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.nscache.CachedFileSystem;
import com.splunk.search.SearchProcessor;
import com.splunk.search.SearchResults;
import com.splunk.util.HdfsUtil;
import com.splunk.util.IOUtil;
import com.splunk.util.StrUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class VixUtilProcessor
extends SearchProcessor {
    public static final int DEFAULT_MAX_LIST_ACTION_DEPTH = 10;
    public static final boolean DEFAULT_RAW_MODE = false;
    private static Logger gLogger = Logger.getLogger(VixUtilProcessor.class);
    protected Configuration _conf;
    protected boolean _done = false;
    protected SearchMetricsReporter _reporter;
    private long _totalDirs;
    private long _totalFiles;

    public VixUtilProcessor(Configuration conf, SearchMetricsReporter reporter) {
        this._conf = conf;
        this._reporter = reporter;
    }

    @Override
    public boolean isGenerating() {
        return true;
    }

    @Override
    public void aboutToExecute() {
        super.aboutToExecute();
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Conf passed to vixutil:" + this._conf.toString()));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean execute(SearchResults results) {
        if (this._done) {
            return this._done;
        }
        stime = System.currentTimeMillis();
        action = this.getOption("action");
        if ("list".equalsIgnoreCase(action)) {
            info = this.getPathAndIndexInfo(this._conf, false, true);
            depth = this.getOption("depth");
            d = 1;
            if (depth != null) {
                try {
                    d = Integer.parseInt(depth);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid option - depth: must be an integer. depth=" + depth, e);
                }
            }
            lsri = new ListSearchResultIndexes(results);
            st = System.currentTimeMillis();
            if (!info.fstat.isDir()) {
                ++this._totalFiles;
                try {
                    stati = info.fs.listMatchingStatus(info.fstat.getPath());
                    if (stati.size() != 1) ** GOTO lbl35
                    for (FileStatusWithCanBrowse fswcb : stati) {
                        this.addListResult(results, lsri, fswcb, 1, info.isDefaultScheme);
                    }
                }
                catch (IOException e) {
                    if (VixUtilProcessor.gLogger.isDebugEnabled()) {
                        VixUtilProcessor.gLogger.warn((Object)("Unable to list path [" + info.fstat.getPath() + "]"), (Throwable)e);
                    }
                    VixUtilProcessor.gLogger.warn((Object)("Unable to list path [" + info.fstat.getPath() + "]: " + e.getMessage()));
                }
            } else {
                ++this._totalDirs;
                this.listStatus(info.fs, results, lsri, info.fstat, 1, d, info.vps, info.isDefaultScheme);
            }
lbl35:
            // 5 sources

            elapsed = System.currentTimeMillis() - st;
            this._reporter.addMetric(info.vix.getName() + ".dirs.listed", elapsed, this._totalDirs);
            this._reporter.addMetric(info.vix.getName() + ".files.listed", elapsed, this._totalFiles);
            VixUtilProcessor.gLogger.debug((Object)("execute listStatus for path [" + info.fstat.getPath().toString() + "] took " + (System.currentTimeMillis() - st) + " ms"));
        } else if ("copy".equalsIgnoreCase(action)) {
            info = this.getPathAndIndexInfo(this._conf, true, false);
            raw_mode = StrUtil.parseBoolean(this.getOption("raw_mode"), false);
            mBytes = this.getOption("max_bytes");
            maxBytes = 0x7FFFFFFFFFFFFFFFL;
            if (mBytes != null) {
                try {
                    maxBytes = Long.parseLong(mBytes);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid option - max_bytes: " + e.getMessage(), e);
                }
            }
            searchId = this.getRequiredOption("search_id");
            filename = this.getOption("filename");
            st = System.currentTimeMillis();
            this.copyBytes(info, searchId, filename, maxBytes, results, info.isDefaultScheme, raw_mode);
            VixUtilProcessor.gLogger.debug((Object)("copy bytes took " + (System.currentTimeMillis() - st) + " ms"));
        } else if ("access".equalsIgnoreCase(action)) {
            p = this.getRequiredOption("path");
            p = p.replace("...", "");
            p = VirtualIndex.VIXPathSpecifier.FIELD_PLACEHOLDER.matcher(p).replaceAll("*");
            path = new Path(p);
            status = "success";
            message = null;
            try {
                if (!path.isAbsolute()) {
                    status = "failure";
                    message = "path must be absolute. path=" + p;
                    VixUtilProcessor.gLogger.info((Object)"it's absolute");
                } else {
                    fs = path.getFileSystem(this._conf);
                    fstats = fs.globStatus(path);
                    if (fstats == null || fstats.length == 0) {
                        status = "failure";
                        message = "path does not exist. path=" + p;
                    } else {
                        acceptableFileStatusExists = false;
                        for (FileStatus fstat : fstats) {
                            VixUtilProcessor.gLogger.debug((Object)("Got filestatus for path=" + fstat.getPath()));
                            acceptableFileStatusExists = fstat.isDir() != false ? acceptableFileStatusExists != false || fstat.getPermission().getUserAction().implies(FsAction.READ_EXECUTE) != false : acceptableFileStatusExists != false || fstat.getPermission().getUserAction().implies(FsAction.READ) != false;
                        }
                        if (!acceptableFileStatusExists) {
                            status = "failure";
                            message = "unable to access path, please check path permissions. path=" + p;
                        }
                    }
                }
            }
            catch (Exception e) {
                status = "failure";
                message = e.getMessage() + " path=" + p;
            }
            r = results.addNewResult();
            r.set("status", (Object)status);
            r.set("message", (Object)message);
            r.set("provider", (Object)this._conf.get(SplunkMR.CONF_PROVIDER));
        } else {
            throw new IllegalArgumentException("Invalid option - action: supported actions are [list|copy|access], specified action is " + action);
        }
        VixUtilProcessor.gLogger.info((Object)("action [" + action + "] took " + (System.currentTimeMillis() - stime) + " ms."));
        this._done = true;
        return this._done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBytes(PathAndIndexInfo info, String searchId, String filename, final long maxBytes, SearchResults results, boolean isDefaultScheme, boolean rawMode) {
        Path path;
        FileOutputStream fout;
        FSDataInputStream in;
        long bytes;
        String destPath;
        String message;
        String status;
        block8: {
            status = "success";
            message = null;
            destPath = filename;
            bytes = 0L;
            in = null;
            fout = null;
            path = info.fstat.getPath();
            gLogger.info((Object)("Copying source file from HDFS to local filesystem for preview. srcFile=" + path + ", destFile=" + destPath + ", maxBytes=" + maxBytes + ", rawMode=" + rawMode));
            try {
                FileOutputStream out;
                String splunkHome = SplunkMR.getSHSplunkHome(this._conf);
                if (splunkHome == null) {
                    throw new RuntimeException("Failed to find splunk instance on search head!");
                }
                File dispatchDir = SplunkdProcess.getDispatchDir(splunkHome, searchId);
                if (filename == null || filename.trim().equals("")) {
                    filename = path.getName();
                }
                File destFile = new File(dispatchDir, filename);
                destPath = destFile.toString();
                if (destFile.exists()) {
                    throw new RuntimeException("Destination file already exists!");
                }
                fout = out = new FileOutputStream(destFile);
                if (rawMode) {
                    in = info.fs.open(path);
                    bytes = IOUtil.copyBytes((InputStream)in, out, maxBytes, true);
                    break block8;
                }
                final AcceptStatus as = new AcceptStatus();
                ObjectAcceptor<VixInputSplit> acceptor = new ObjectAcceptor<VixInputSplit>(){

                    @Override
                    public <T extends VixInputSplit> boolean accept(T split) {
                        try {
                            gLogger.info((Object)("Got a split from inputId " + split.getInputId() + ". split=" + split));
                            if (as.accepted && !as.intputId.equals(split.getInputId())) {
                                gLogger.debug((Object)("No need to process duplicate splits. Already copied the whole file. copiedBytes=" + as.bytes + ", maxBytes=" + maxBytes));
                                return false;
                            }
                            JobSubmitterInputFormat jsif = new JobSubmitterInputFormat();
                            BaseSplunkRecordReader in = jsif.createRecordReader(split, SplunkMR.getNewTaskAttemptContext(VixUtilProcessor.this._conf, new TaskAttemptID()));
                            gLogger.info((Object)String.format("using class=%s to process split=%s", ((Object)((Object)in)).getClass().getName(), split.toString()));
                            FastByteArrayOutputStream baos = new FastByteArrayOutputStream(65536);
                            while (in.nextKeyValue()) {
                                if (as.bytes >= maxBytes) {
                                    gLogger.debug((Object)("No need to process more records. Already copied enough bytes. copiedBytes=" + as.bytes + ", maxBytes=" + maxBytes));
                                    return false;
                                }
                                in.serializeCurrentValueTo(baos);
                                if (in.appendNewLine()) {
                                    baos.write(10);
                                }
                                baos.writeTo(out);
                                as.bytes += (long)baos.size();
                                baos.reset();
                            }
                            as.accepted = true;
                            as.intputId = split.getInputId();
                            out.flush();
                            gLogger.info((Object)("Total bytes copied: " + as.bytes));
                        }
                        catch (Exception e) {
                            gLogger.error((Object)("Failed to accept a split:" + split), (Throwable)e);
                            return false;
                        }
                        return true;
                    }
                };
                AsyncMRJob dummy = new AsyncMRJob(this._conf, this._conf.get(SplunkMR.CONF_SEARCH_ID));
                info.vix.generateSplits((JobContext)dummy, acceptor, info.fstat, info.vps);
                bytes = as.bytes;
            }
            catch (Exception e) {
                try {
                    status = "error";
                    message = e.getMessage() + " src=" + path + ", dest=" + destPath + ", searchId=" + searchId;
                    gLogger.error((Object)("Failed to copy file. src=" + path + ", dest=" + destPath + ", searchId=" + searchId), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(fout);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)fout);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)fout);
        SearchResults.Result r = results.addNewResult();
        r.set("status", (Object)status);
        r.set("path", (Object)(isDefaultScheme ? path.toUri().getPath() : path.toUri().toString()));
        r.set("dest", (Object)destPath);
        r.set("bytes", (Object)bytes);
        r.set("message", (Object)message);
    }

    private PathAndIndexInfo getPathAndIndexInfo(Configuration conf, boolean ensurePathIsFile, boolean useCache) {
        long startTime = System.currentTimeMillis();
        String p = this.getRequiredOption("path");
        Path path = new Path(p);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Invalid option - path: must be an absolute path. path=" + p);
        }
        PathAndIndexInfo info = new PathAndIndexInfo();
        try {
            FileSystemDelegator fsd;
            VirtualIndex vix;
            long st = System.currentTimeMillis();
            String index = this.getRequiredOption("index");
            this._conf.setBoolean("splunk.extract_fields_on_path", false);
            st = System.currentTimeMillis();
            info.vix = vix = VirtualIndex.parseIndex(this._conf, index);
            gLogger.debug((Object)("parse index [" + index + "] took " + (System.currentTimeMillis() - st) + " ms"));
            if (vix == null) {
                throw new RuntimeException("Invalid option - index: unknown index name. index=" + index);
            }
            FileSystem fs = path.getFileSystem(this._conf);
            boolean readFromCache = useCache && vix.isNSCacheEnabled();
            info.fs = fsd = new FileSystemDelegator(vix, fs, readFromCache);
            if (!info.fs.exists(path)) {
                throw new IllegalArgumentException("Invalid option - path: path does not exist. path=" + p);
            }
            if (ensurePathIsFile && !info.fs.isFile(path)) {
                throw new IllegalArgumentException("Invalid option - path: must be pointing to a file. path=" + p);
            }
            try {
                st = System.currentTimeMillis();
                info.fstat = info.fs.getFileStatus(path);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid option - path: " + p, e);
            }
            st = System.currentTimeMillis();
            String[] pathParts = VirtualIndex.VIXPathSpecifier.convertToPathParts(path);
            if (pathParts.length == 0) {
                pathParts = VirtualIndex.VIXPathSpecifier.ROOT_PATH_PARTS;
            }
            for (VirtualIndex.VIXPathSpecifier ps : vix.getVIXPathSpecifiers()) {
                if (!ps.isPathWithinIndexScope(pathParts, info.fstat.isDir())) continue;
                gLogger.info((Object)("The path is within index scope: info.fstat.path=" + info.fstat.getPath() + ", ps.inputId=" + ps.getInputId()));
                info.vps.add(ps);
            }
            if (info.vps.isEmpty()) {
                throw new IllegalArgumentException("Invalid option - path: path is out of index scope. path=" + p + ", index=" + index);
            }
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("vix path specifiers added to pathAndIndexInfo:" + info.vps.toString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to validate path and index:" + e.getMessage(), e);
        }
        String defaultName = this._conf.get("fs.default.name");
        if (defaultName != null) {
            try {
                URI uri = new URI(defaultName);
                info.isDefaultScheme = uri.getScheme() != null && uri.getScheme().equals(info.fs.getUri().getScheme());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to parse fs.default.name (" + defaultName + "):" + e.getMessage(), e);
            }
        }
        gLogger.debug((Object)("execute getPathAndIndexInfo took " + (System.currentTimeMillis() - startTime) + " ms"));
        return info;
    }

    private SearchResults.Result addListResult(SearchResults results, ListSearchResultIndexes lsri, FileStatusWithCanBrowse stats, int depth, boolean isDefaultScheme) {
        SearchResults.Result r = results.addNewResult();
        r.set(lsri.path, (Object)(isDefaultScheme ? stats.getPath().toUri().getPath() : stats.getPath()));
        r.set(lsri.depth, (Object)depth);
        r.set(lsri.type, (Object)(stats.isDir() ? "dir" : "file"));
        r.set(lsri.can_browse, (Object)stats.getCanBrowse());
        r.set(lsri.size, (Object)stats.getLen());
        r.set(lsri.replication, (Object)stats.getReplication());
        r.set(lsri.blockSize, (Object)stats.getBlockSize());
        r.set(lsri.owner, (Object)stats.getOwner());
        r.set(lsri.group, (Object)stats.getGroup());
        r.set(lsri.permissions, (Object)stats.getPermission().toString());
        r.set(lsri.mtime, (Object)(stats.getModificationTime() / 1000L + "." + stats.getModificationTime() % 1000L));
        r.set(lsri.atime, (Object)(stats.getAccessTime() / 1000L + "." + stats.getAccessTime() % 1000L));
        return r;
    }

    private void listStatus(FileSystemDelegator fs, SearchResults results, ListSearchResultIndexes lsri, FileStatus stats, int currDepth, int targetDepth, List<VirtualIndex.VIXPathSpecifier> vps, boolean isDefaultScheme) {
        if (currDepth <= 0 || targetDepth <= 0 || currDepth > targetDepth) {
            return;
        }
        if (currDepth > 10) {
            gLogger.warn((Object)("Stopped listing: currDepth reaches the maximum allowed directory browsing depth (10). currDepth=" + currDepth + "."));
            return;
        }
        try {
            for (FileStatusWithCanBrowse s : fs.listMatchingStatus(stats.getPath())) {
                this.addListResult(results, lsri, s, currDepth, isDefaultScheme);
                if (!s.getCanBrowse() || !s.isDir()) continue;
                this.listStatus(fs, results, lsri, s, currDepth + 1, targetDepth, vps, isDefaultScheme);
            }
        }
        catch (IOException e) {
            if (gLogger.isDebugEnabled()) {
                gLogger.warn((Object)("Unable to list path [" + stats.getPath() + "]"), (Throwable)e);
            }
            gLogger.warn((Object)("Unable to list path [" + stats.getPath() + "]: " + e.getMessage()));
        }
    }

    private class FileSystemDelegator
    extends FileSystem {
        private List<CachedFileSystem> cachedFss = new ArrayList<CachedFileSystem>();
        private VirtualIndex vix;
        private FileSystem realFs;

        public FileSystemDelegator(VirtualIndex vix, FileSystem realFs, boolean readFromCache) throws IOException {
            this.vix = vix;
            this.realFs = realFs;
            if (readFromCache) {
                this.initialize();
            }
        }

        private void initialize() throws IOException {
            gLogger.info((Object)"initializing FileSystemDelegator ...");
            for (VirtualIndex.VIXPathSpecifier ps : this.vix.getVIXPathSpecifiers()) {
                Path root = new Path(ps.getGlobPath()).getParent();
                FileStatus rootStat = this.realFs.getFileStatus(root);
                if (rootStat == null || !rootStat.isDir()) {
                    return;
                }
                CachedFileSystem cfs = null;
                try {
                    long st = System.currentTimeMillis();
                    cfs = new CachedFileSystem(this.realFs, rootStat, this.vix, ps.getInputId(), false);
                    VixUtilProcessor.this._reporter.addMetric("nscache.loaded", System.currentTimeMillis() - st, 1L);
                    gLogger.info((Object)("Load nscache took " + (System.currentTimeMillis() - st) + " ms. cfs=" + (Object)((Object)cfs)));
                    this.cachedFss.add(cfs);
                    if (!cfs.isCacheExpired()) continue;
                    st = System.currentTimeMillis();
                    ps.listStatus(cfs, null, null, false, false, false);
                    gLogger.info((Object)("list dir status took " + (System.currentTimeMillis() - st) + " ms. cfs=" + (Object)((Object)cfs)));
                    st = System.currentTimeMillis();
                    cfs.saveCache();
                    VixUtilProcessor.this._reporter.addMetric("nscache.saved", System.currentTimeMillis() - st, 1L);
                    gLogger.info((Object)("Save nscache took " + (System.currentTimeMillis() - st) + " ms. cfs=" + (Object)((Object)cfs)));
                }
                catch (Exception e) {
                    gLogger.warn((Object)("Failed to build cache. cfs=" + cfs), (Throwable)e);
                    this.cachedFss.clear();
                    break;
                }
            }
        }

        public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
            return this.realFs.append(arg0, arg1, arg2);
        }

        public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
            return this.realFs.create(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public boolean delete(Path arg0) throws IOException {
            return this.realFs.delete(arg0);
        }

        public boolean delete(Path arg0, boolean arg1) throws IOException {
            return this.realFs.delete(arg0, arg1);
        }

        public FileStatus getFileStatus(Path arg0) throws IOException {
            if (arg0 == null) {
                return null;
            }
            if (this.cachedFss.isEmpty()) {
                return this.realFs.getFileStatus(arg0);
            }
            for (CachedFileSystem cfs : this.cachedFss) {
                FileStatus stat;
                if (!HdfsUtil.containsPath(arg0, cfs.getCacheRootPath(), true) || (stat = cfs.getFileStatus(arg0)) == null) continue;
                return stat;
            }
            return null;
        }

        public URI getUri() {
            return this.realFs.getUri();
        }

        public Path getWorkingDirectory() {
            return this.realFs.getWorkingDirectory();
        }

        public Set<FileStatusWithCanBrowse> listMatchingStatus(Path path) throws IOException {
            LinkedHashSet<FileStatusWithCanBrowse> stats = new LinkedHashSet<FileStatusWithCanBrowse>();
            for (int i = 0; i < this.vix.getVIXPathSpecifiers().size(); ++i) {
                FileStatus[] status;
                VirtualIndex.VIXPathSpecifier ps;
                block9: {
                    FileSystem fs;
                    ps = this.vix.getVIXPathSpecifiers().get(i);
                    if (this.cachedFss.isEmpty()) {
                        fs = this.realFs;
                    } else {
                        CachedFileSystem cfs = this.cachedFss.get(i);
                        if (!HdfsUtil.containsPath(path, cfs.getCacheRootPath(), true)) continue;
                        fs = cfs;
                    }
                    status = null;
                    try {
                        status = fs.listStatus(path);
                    }
                    catch (Exception e) {
                        if (!gLogger.isDebugEnabled()) break block9;
                        gLogger.debug((Object)("Failed to list status of path " + path + " for vix input path with inputId " + ps.getInputId()), (Throwable)e);
                    }
                }
                if (status == null) continue;
                for (FileStatus stat : status) {
                    if (stat.isDir()) {
                        VixUtilProcessor.this._totalDirs++;
                    } else {
                        VixUtilProcessor.this._totalFiles++;
                    }
                    boolean accepted = false;
                    if (ps.isAcceptablePathForBrowse(stat)) {
                        accepted = true;
                        stats.add(new FileStatusWithCanBrowse(stat, ps.canBrowse(stat)));
                    }
                    if (!gLogger.isDebugEnabled()) continue;
                    gLogger.debug((Object)((accepted ? "accepted" : "skipped") + " a file. path=" + stat.getPath() + ", ps.inputId=" + ps.getInputId()));
                }
            }
            return stats;
        }

        public FileStatus[] listStatus(Path arg0) throws IOException {
            Set<FileStatusWithCanBrowse> stats = this.listMatchingStatus(arg0);
            return stats.toArray(new FileStatus[stats.size()]);
        }

        public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
            return this.realFs.mkdirs(arg0, arg1);
        }

        public FSDataInputStream open(Path arg0, int arg1) throws IOException {
            return this.realFs.open(arg0, arg1);
        }

        public boolean rename(Path arg0, Path arg1) throws IOException {
            return this.realFs.rename(arg0, arg1);
        }

        public void setWorkingDirectory(Path arg0) {
            this.realFs.setWorkingDirectory(arg0);
        }

        public Configuration getConf() {
            return this.realFs.getConf();
        }
    }

    private class ListSearchResultIndexes {
        public int path;
        public int depth;
        public int type;
        public int can_browse;
        public int size;
        public int replication;
        public int blockSize;
        public int owner;
        public int group;
        public int permissions;
        public int mtime;
        public int atime;

        public ListSearchResultIndexes(SearchResults srs) {
            this.path = srs.keyIndex("path");
            this.depth = srs.keyIndex("depth");
            this.type = srs.keyIndex("type");
            this.can_browse = srs.keyIndex("can_browse");
            this.size = srs.keyIndex("size");
            this.replication = srs.keyIndex("replication");
            this.blockSize = srs.keyIndex("block_size");
            this.owner = srs.keyIndex("owner");
            this.group = srs.keyIndex("group");
            this.permissions = srs.keyIndex("permissions");
            this.mtime = srs.keyIndex("mtime");
            this.atime = srs.keyIndex("atime");
        }
    }

    private class FileStatusWithCanBrowse
    extends FileStatus {
        private boolean _canBrowse;

        public FileStatusWithCanBrowse(FileStatus s, boolean canBrowse) {
            super(s.getLen(), s.isDir(), (int)s.getReplication(), s.getBlockSize(), s.getModificationTime(), s.getAccessTime(), s.getPermission(), s.getOwner(), s.getGroup(), s.getPath());
            this._canBrowse = canBrowse;
        }

        public boolean getCanBrowse() {
            return this._canBrowse;
        }
    }

    private class PathAndIndexInfo {
        List<VirtualIndex.VIXPathSpecifier> vps = new ArrayList<VirtualIndex.VIXPathSpecifier>();
        FileSystemDelegator fs;
        FileStatus fstat;
        boolean isDefaultScheme;
        VirtualIndex vix;

        private PathAndIndexInfo() {
        }
    }

    private class AcceptStatus {
        public boolean accepted;
        public long bytes;
        public String intputId;

        private AcceptStatus() {
        }
    }
}

