/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.ast.nodes.search.SearchPhraseNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchTermNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.List;

public class ComparableStringVisitor
extends NodeVisitor<String> {
    @Override
    public String visit(Node node) {
        throw new RuntimeException("Shouldn't get to ComparableStringVisitor.visit(Node node).");
    }

    @Override
    public String visit(SearchFunctionNode node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("_x(");
        List<SearchNode> nodes = node.getArguments();
        for (int i = 0; i < nodes.size(); ++i) {
            SearchNode sn = nodes.get(i);
            buffer.append(sn.accept(this));
            if (i + 1 >= nodes.size()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String visit(SearchSubSearchPredicateNode node) {
        return "_subsearch()";
    }

    @Override
    public String visit(SearchComparisonNode node) {
        if (node.is_indexed()) {
            return "_indexed_comparison(" + node.getLhs().accept(this) + node.getOperator().toString() + node.getRhs().accept(this) + ')';
        }
        return "_non_indexed_comparison(" + node.getLhs().accept(this) + node.getOperator().toString() + node.getRhs().accept(this) + ')';
    }

    @Override
    public String visit(SearchPhraseNode node) {
        return "_phrase(" + node.getValue() + ')';
    }

    @Override
    public String visit(SearchTermNode node) {
        return "_term(" + node.getValue() + ')';
    }

    @Override
    public String visit(StringNode node) {
        return "_string(" + node.getValue() + ')';
    }

    @Override
    public String visit(FieldNode node) {
        return "_field(" + node.getFieldName() + ')';
    }

    @Override
    public String visit(NumberNode node) {
        return "_number(" + node.getValue().toString() + ')';
    }

    @Override
    public String visit(FunctionNode node) {
        return "_function(" + node.getFunctionName() + ')';
    }

    @Override
    public String visit(AndNode node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("_x(");
        List<TypeNode> nodes = node.getArguments();
        for (int i = 0; i < nodes.size(); ++i) {
            TypeNode sn = nodes.get(i);
            buffer.append(sn.accept(this));
            if (i + 1 >= nodes.size()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String visit(OrNode node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("_x(");
        List<TypeNode> nodes = node.getArguments();
        for (int i = 0; i < nodes.size(); ++i) {
            TypeNode sn = nodes.get(i);
            buffer.append(sn.accept(this));
            if (i + 1 >= nodes.size()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String visit(XorNode node) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("_x(");
        List<TypeNode> nodes = node.getArguments();
        for (int i = 0; i < nodes.size(); ++i) {
            TypeNode sn = nodes.get(i);
            buffer.append(sn.accept(this));
            if (i + 1 >= nodes.size()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String visit(ComparisonNode node) {
        return "_comparison(" + node.getLhs().accept(this) + node.getOperator().toString() + node.getRhs().accept(this) + ')';
    }

    @Override
    public String visit(CommandNode node) {
        if (node.getSources().length == 0) {
            return node.getCommandName() + "()";
        }
        if (node.getSources().length == 1) {
            return node.getSource().accept(this) + '|' + node.getCommandName() + "()";
        }
        return node.getSources()[0].accept(this) + '|' + node.getCommandName() + "()[" + node.getSources()[1].accept(this) + ']';
    }

    @Override
    public String visit(WhereCommand node) {
        return node.getSource().accept(this) + "|where(" + node.getPredicate().getNode().accept(this) + ')';
    }

    @Override
    public String visit(SearchCommand node) {
        String predicate = node.getPredicate().getNode().accept(this);
        if (node.isGenerating()) {
            return "search(" + predicate + ')';
        }
        return node.getSource().accept(this) + "|search(" + predicate + ')';
    }

    public boolean reorderRequired(Node lhs, Node rhs) {
        String rhsComparable;
        String lhsComparable = lhs.accept(this);
        return lhsComparable.compareTo(rhsComparable = rhs.accept(this)) > 0;
    }
}

