/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.util;

public final class StringUtils {
    public static final String PATTERN_TO_QUOTE = ".*[^0-9a-zA-Z_].*";

    private StringUtils() {
    }

    public static String commaSeparate(Object[] parts) {
        return StringUtils.join(", ", parts, false);
    }

    public static String commaSeparate(Object[] parts, boolean quote) {
        return StringUtils.join(", ", parts, quote);
    }

    public static String join(String delimiter, Object[] parts) {
        return StringUtils.join(delimiter, parts, false);
    }

    private static String join(String delimiter, Object[] parts, boolean quote) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(StringUtils.applyQuoting(parts[i].toString(), quote));
        }
        return sb.toString();
    }

    public static String fixedLengthString(String s, int length) {
        return String.format("%1$s-%2$ss", s, Integer.toString(length));
    }

    public static String applyQuoting(String spl, boolean quote) {
        return quote ? '\"' + spl + '\"' : spl;
    }

    public static boolean isQuoteNeeded(String input) {
        return input.isEmpty() ? false : Character.isDigit(input.charAt(0)) || input.matches(PATTERN_TO_QUOTE);
    }

    public static String escapeMetaCharacters(String str) {
        String[] metaCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", ".", "*", "+", "?", "|", "<", ">", "-", "&", "%"};
        for (int i = 0; i < metaCharacters.length; ++i) {
            if (!str.contains(metaCharacters[i])) continue;
            str = str.replace(metaCharacters[i], "\\" + metaCharacters[i]);
        }
        return str;
    }
}

