/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Search;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.handlers.IGroupByHandler;
import com.splunk.commons.providers.handlers.ISelectHandler;
import com.splunk.commons.providers.handlers.IWhereHandler;
import com.splunk.commons.visitors.WhereToSearchConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class MetricsPlanProvider
implements IPlanProvider,
IWhereHandler,
IGroupByHandler,
ISelectHandler {
    private ISearchPredicate wherePredicate;
    private IGroupBy[] gbFields;
    private AggregateNode[] aggregates;
    private HashSet<String> selectedFields = new HashSet();

    private static void validate(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("metric")) {
            throw new IOException("MetricsPlanProvider only supports metric datasets.");
        }
    }

    @Override
    public void initialize(Dataset dataset) throws IOException {
        MetricsPlanProvider.validate(dataset);
        this.wherePredicate = Search.equal("index", dataset.getModuleQualifiedName());
    }

    @Override
    public void initialize(Dataset[] datasets) throws IOException {
        ArrayList<ISearchPredicate> indexes = new ArrayList<ISearchPredicate>(datasets.length);
        for (int i = 0; i < datasets.length; ++i) {
            MetricsPlanProvider.validate(datasets[i]);
            indexes.add(i, Search.equal("index", datasets[i].getModuleQualifiedName()));
        }
        this.wherePredicate = Search.or(indexes);
    }

    @Override
    public CommandNode getCommand() {
        MStatsCommand cmd = new MStatsCommand(this.aggregates, this.gbFields, this.wherePredicate);
        FieldNode[] excludedFields = this.getFieldExclusions();
        if (excludedFields != null) {
            return new FieldsCommand(cmd, excludedFields, true);
        }
        return cmd;
    }

    @Override
    public void where(IWherePredicate where) {
        WhereToSearchConverter converter = new WhereToSearchConverter();
        ISearchPredicate whereToSearchNode = where.getNode().accept(converter);
        if (whereToSearchNode == null) {
            throw new IllegalArgumentException("WHERE predicate couldn't be converted to search node");
        }
        this.wherePredicate = Search.and((SearchNode)this.wherePredicate, (SearchNode)whereToSearchNode);
    }

    @Override
    public void groupBy(IGroupBy[] fields) {
        this.gbFields = fields;
    }

    @Override
    public void select(ISelection[] projections) {
        ArrayList<AggregateNode> aggList = new ArrayList<AggregateNode>();
        for (ISelection projection : projections) {
            if (projection instanceof AggregateNode) {
                aggList.add((AggregateNode)projection);
                continue;
            }
            if (projection instanceof FieldNode) {
                this.selectedFields.add(((FieldNode)projection).getFieldName());
                continue;
            }
            throw new IllegalArgumentException("Invalid aggregate provided for Metric dataset in SELECT clause");
        }
        if (!aggList.isEmpty()) {
            this.aggregates = new AggregateNode[aggList.size()];
            aggList.toArray(this.aggregates);
        }
    }

    private FieldNode[] getFieldExclusions() {
        if (this.gbFields == null || this.gbFields.length == 0) {
            return null;
        }
        ArrayList<FieldNode> fieldNodeList = new ArrayList<FieldNode>();
        for (IGroupBy groupBy : this.gbFields) {
            FieldNode gbField = null;
            if (groupBy instanceof FieldNode) {
                gbField = (FieldNode)groupBy;
            } else if (groupBy instanceof BinNode) {
                gbField = ((BinNode)groupBy).getField();
            }
            if (gbField == null || this.selectedFields.contains(gbField.getFieldName())) continue;
            fieldNodeList.add(gbField);
        }
        if (fieldNodeList.isEmpty()) {
            return null;
        }
        FieldNode[] fieldArr = new FieldNode[fieldNodeList.size()];
        return fieldNodeList.toArray(fieldArr);
    }
}

