/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.datasets.Partition;
import com.splunk.commons.datasets.StaticPartitions;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Partitions
implements Iterable<Partition> {
    private boolean closed;

    public Partitions filter(IPredicate predicate) {
        Partitions partial = this.newExtendable();
        for (Partition p : this) {
            if (p.canEliminate(predicate)) continue;
            partial.add(p);
        }
        partial.close();
        return partial;
    }

    void add(Partition partition) {
        if (this.closed) {
            throw new IllegalStateException("Partitions is locked, and can not be extended.");
        }
        this.extend(partition);
    }

    void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract void extend(Partition var1);

    protected abstract Partitions newExtendable();

    public abstract Partition[] toArray();

    public static Partitions load(JSONObject owner) {
        if (owner.has("partitions")) {
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            JSONArray array = owner.getJSONArray("partitions");
            for (int i = 0; i < array.length(); ++i) {
                partitions.add(Partition.load(array.getJSONObject(i)));
            }
            return new StaticPartitions(partitions);
        }
        throw new RuntimeException("Unexpected type of partitioning encountered.");
    }
}

