/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.nodes.Command;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.security.SplunkConnection;
import com.splunk.commons.visitors.SplFormatter;

public class ExternalSplunkSearch {
    private final SplunkConnection connectionInfo;
    private final CommandNode search;

    public ExternalSplunkSearch() {
        this.connectionInfo = new SplunkConnection();
        this.search = Command.search();
    }

    public ExternalSplunkSearch(SplunkConnection connectionInfo, CommandNode search) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("ConnectionInfo must be provided.");
        }
        if (search == null) {
            throw new IllegalArgumentException("Search must be provided.");
        }
        this.connectionInfo = connectionInfo;
        this.search = search;
    }

    public SplunkConnection getConnectionInfo() {
        return this.connectionInfo;
    }

    public CommandNode getSearch() {
        return this.search;
    }

    public String serialize() {
        String remoteSpl = this.search.accept(new SplFormatter());
        return String.format("[%1$s] %2$s", remoteSpl, this.connectionInfo.serialize());
    }
}

