/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.search;

import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchLeafNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.visitors.NodeVisitor;

public class SearchInNode
extends SearchLeafNode
implements ISearchPredicate {
    private final FieldNode lhs;
    private final TypeNode[] rhs;

    public SearchInNode(FieldNode lhs, TypeNode[] rhs) {
        this(lhs, rhs, false);
    }

    private SearchInNode(FieldNode lhs, TypeNode[] rhs, boolean isNegated) {
        super("function", isNegated, SearchModifier.NONE);
        this.lhs = SearchInNode.verifyLhs(lhs);
        this.rhs = SearchInNode.verifyRhs(rhs);
    }

    private static FieldNode verifyLhs(FieldNode lhs) {
        SearchInNode.assertNotNull("LHS field must not be null", lhs);
        return lhs;
    }

    private static TypeNode[] verifyRhs(TypeNode[] rhs) {
        SearchInNode.assertTrue("RHS must not be null or empty", rhs != null && rhs.length > 0);
        return rhs;
    }

    public FieldNode getLhs() {
        return this.lhs;
    }

    public TypeNode[] getRhs() {
        return this.rhs;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IMatcher getMatcher() {
        return null;
    }
}

