/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.expressions.SplTimeUnit;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;

public class TimeSpanNode
extends SpanNode {
    private StringNode spanLength;
    private StringNode snapToTime;

    public TimeSpanNode(String spanExpression) {
        super("timespan");
        int i;
        if (spanExpression.contains("@")) {
            this.snapToTime = new StringNode(spanExpression);
            return;
        }
        for (i = 0; i < spanExpression.length() && Character.isDigit(spanExpression.charAt(i)); ++i) {
        }
        try {
            int n = Integer.parseInt(spanExpression.substring(0, i));
            if (n <= 0) {
                throw new IllegalArgumentException("Invalid spanLength: must be a positive integer with optional timesacle.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid spanLength. correct syntax: <int>[<timescale>]");
        }
        if (i < spanExpression.length()) {
            SplTimeUnit.getEnum(spanExpression.substring(i));
        }
        this.spanLength = new StringNode(spanExpression);
    }

    public StringNode getSpanLength() {
        return this.spanLength;
    }

    public StringNode getSnapToTime() {
        return this.snapToTime;
    }

    public String toString() {
        return this.accept(new SplFormatter());
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

