/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import java.util.Locale;

public enum AggregateFunction {
    ALL,
    DEFAULT,
    AVG,
    C,
    COUNT,
    DC,
    DISTINCT_COUNT,
    EARLIEST,
    ESTDC,
    ESTDC_ERROR,
    EXACTPERC_X,
    FIRST,
    LATEST,
    LAST,
    LIST,
    MAX,
    MEAN,
    MEDIAN,
    MIN,
    MODE,
    PER_DAY,
    PER_HOUR,
    PER_MINUTE,
    PER_SECOND,
    PERC_X,
    RANGE,
    SPARKLINE,
    STDEV,
    STDEVP,
    SUM,
    SUMSQ,
    UPPERPERC_X,
    VALUES,
    VAR,
    VARP,
    EVAL,
    EARLIEST_TIME,
    LATEST_TIME;

    public static final String UNSUPPORTED_FUNCTION_ERROR = "Time function '%s' is not supported.";
    public static final AggregateFunction[] ALL_AGGFUNCTIONS;

    public static boolean isStatsFunction(String name) {
        try {
            AggregateFunction f = AggregateFunction.fromString(name);
            switch (f) {
                case ALL: 
                case DEFAULT: 
                case PER_DAY: 
                case PER_HOUR: 
                case PER_MINUTE: 
                case PER_SECOND: 
                case SPARKLINE: {
                    return false;
                }
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static AggregateFunction fromString(String name) {
        String uppercase = name.toUpperCase(Locale.ENGLISH);
        if (uppercase.startsWith("EXACTPERC")) {
            return EXACTPERC_X;
        }
        if (uppercase.startsWith("PERC")) {
            return PERC_X;
        }
        if (uppercase.startsWith("UPPERPERC")) {
            return UPPERPERC_X;
        }
        if (uppercase.equals("RATE")) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_FUNCTION_ERROR, "rate"));
        }
        return AggregateFunction.valueOf(uppercase);
    }

    public String toString() {
        switch (this) {
            case EXACTPERC_X: 
            case PERC_X: 
            case UPPERPERC_X: {
                return super.toString().toLowerCase().replace("_x", "");
            }
        }
        return super.toString().toLowerCase();
    }

    static {
        ALL_AGGFUNCTIONS = new AggregateFunction[]{AVG, COUNT, DC, MIN, MAX, MEDIAN, MODE, SUM, SUMSQ, STDEV, VAR};
    }
}

