/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;

public class TableCommand
extends CommandNode {
    private final FieldNode[] fields;

    public TableCommand(CommandNode source, FieldNode[] fields) {
        super(source, "table", CommandType.SP_REPORT, new FieldsAndProperties().table(fields).array());
        TableCommand.assertParamMembersNotNull(fields, "fields");
        TableCommand.assertTrue("There must be a least one field selected.", fields.length > 0);
        this.fields = fields;
    }

    public FieldNode[] getFields() {
        return this.fields;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new TableCommand(source, this.fields);
    }
}

