/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes;

import com.splunk.commons.ast.antlr.CompleteSPLParser;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.DatamodelCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.LoadJobCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.commands.MvexpandCommand;
import com.splunk.commons.ast.nodes.commands.SavedsearchCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsOptions;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;

public final class Command {
    private Command() {
    }

    public static DatamodelCommand datamodel(String datamodelName, String datasetName) {
        return new DatamodelCommand(datamodelName, datasetName, DatamodelCommand.DatamodelSearchMode.SEARCH);
    }

    public static DatamodelCommand datamodel(String datamodelName, String datasetName, DatamodelCommand.DatamodelSearchMode mode) {
        return new DatamodelCommand(datamodelName, datasetName, mode);
    }

    public static FromCommand from(Dataset dataset) {
        return new FromCommand(dataset);
    }

    public static FromCommand from(Dataset dataset, IWherePredicate where) {
        return new FromCommand(dataset, where);
    }

    public static FromCommand from(Dataset dataset, IWherePredicate where, ISelection[] selections) {
        return new FromCommand(dataset, where, selections);
    }

    public static FromCommand from(Dataset dataset, IWherePredicate where, IGroupBy[] groupBy, ISelection[] selections, IOrdering[] orderby) {
        return new FromCommand(dataset, where, groupBy, selections, orderby);
    }

    public static InputlookupCommand inputlookup(String lookupName) {
        return new InputlookupCommand(lookupName);
    }

    public static InputlookupCommand inputlookup(String lookupName, ISearchPredicate where) {
        return new InputlookupCommand(lookupName, where);
    }

    public static LoadJobCommand loadjob(String jobName) {
        return new LoadJobCommand(jobName);
    }

    public static MStatsCommand mstats(AggregateNode[] aggregates, FieldNode[] byFields, ISearchPredicate where) {
        return new MStatsCommand(aggregates, byFields, where);
    }

    public static McatalogCommand mcatalog(AggregateNode[] values, IWherePredicate predicate, IGroupBy[] groupByNodes, Boolean prestats, Boolean append) {
        return new McatalogCommand(values, predicate, groupByNodes, prestats, append);
    }

    public static MvexpandCommand mvexpand(String fieldName, int limit) {
        return new MvexpandCommand(fieldName, limit);
    }

    public static MvexpandCommand mvexpand(String fieldName) {
        return new MvexpandCommand(fieldName);
    }

    public static SavedsearchCommand savedsearch(String savedsearchName) {
        return new SavedsearchCommand(savedsearchName);
    }

    public static SearchCommand search() {
        return new SearchCommand();
    }

    public static SearchCommand search(IPredicate predicate) {
        if (predicate == null) {
            return Command.search();
        }
        return new SearchCommand(predicate);
    }

    public static SearchCommand search(String expression) {
        return new SearchCommand((IPredicate)((Object)new CompleteSPLParser().parseSearchPredicate(expression)));
    }

    public static TStatsCommand tstats(AggregateNode[] aggregates, FieldNode[] byFields, ISearchPredicate where, String namespace, TStatsOptions options) {
        return new TStatsCommand(aggregates, byFields, where, namespace, options);
    }

    public static UnionCommand union(CommandNode lhs, CommandNode rhs) {
        return new UnionCommand(lhs, rhs);
    }

    public static UnionCommand union(CommandNode[] sources) {
        return new UnionCommand(sources);
    }

    public static UnknownCommand unknownGenerating(String commandName, String arguments, CommandType type, FieldProperties[] metadata) {
        return new UnknownCommand(commandName, arguments, type, metadata);
    }
}

