/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.matchers;

import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.nodes.expressions.Number;
import com.splunk.commons.ast.nodes.expressions.Operator;

public class NumberMatcher
implements IMatcher {
    private final Operator operator;
    private final Object number;

    public NumberMatcher(Object number, Operator operator) {
        if (!Number.isNumeric(number)) {
            throw new IllegalArgumentException("NumberMatche got an invalid number: " + number);
        }
        this.number = number;
        this.operator = operator;
    }

    public Object match(Object comparison) {
        switch (this.operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return Number.equal(comparison, this.number);
            }
            case NOT_EQUAL: {
                return Number.notEqual(comparison, this.number);
            }
            case GREATER_THAN: {
                return Number.greaterThan(comparison, this.number);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Number.greaterThanEqual(comparison, this.number);
            }
            case LESS_THAN: {
                return Number.lessThan(comparison, this.number);
            }
            case LESS_THAN_OR_EQUAL: {
                return Number.lessThanEqual(comparison, this.number);
            }
        }
        return false;
    }
}

