/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.matchers;

import com.splunk.commons.ast.matchers.IMatcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;

public class CidrMatcher
implements IMatcher {
    private static final Pattern cidrRegex = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\/(\\d|[1-2]\\d|3[0-2]))$");
    private static final Pattern ipRegex = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private final String cidr;

    public CidrMatcher(String cidr) {
        if (cidr == null || !cidrRegex.matcher(cidr).find()) {
            throw new IllegalArgumentException("Not a valid CIDR.");
        }
        this.cidr = cidr;
    }

    public static boolean isCidr(String candidate) {
        if (candidate == null) {
            return false;
        }
        return cidrRegex.matcher(candidate).find();
    }

    public boolean match(String ipaddress) {
        if (ipaddress == null) {
            return false;
        }
        if (!ipRegex.matcher(ipaddress).find()) {
            return false;
        }
        SubnetUtils utils = new SubnetUtils(this.cidr);
        utils.setInclusiveHostCount(true);
        return utils.getInfo().isInRange(ipaddress);
    }
}

