/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.DatasetsVisitor;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.JoinType;
import com.splunk.commons.datasets.Dataset;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandJoinVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private final DatasetsVisitor datasetsVisitor = new DatasetsVisitor();
    private String lhsAlias = "";
    private String rhsAlias = "";
    private JoinType joinType = JoinCommand.DEFAULT_JOIN_TYPE;
    private final boolean usetime = true;
    private final boolean earlier = true;
    private boolean overwrite = true;
    private int max = 1;

    @Override
    public Node visitJoinParse(SplunkCommandParser.JoinParseContext ctx) {
        for (SplunkCommandParser.JoinOptionsContext option : ctx.joinOptions()) {
            this.visit((ParseTree)option);
        }
        this.lhsAlias = ctx.joinOptionLeftAlias().ID().getText();
        this.rhsAlias = ctx.joinOptionRightAlias().ID().getText();
        if (!JoinCommand.validAliasCombination(this.lhsAlias, this.rhsAlias)) {
            throw new IllegalArgumentException("Invalid aliases: they must be different.");
        }
        int numFieldPairs = ctx.joinWherePredicate().joinFieldPair().size();
        JoinNode[] joinClauses = new JoinNode[numFieldPairs];
        for (int i = 0; i < numFieldPairs; ++i) {
            joinClauses[i] = (JoinNode)this.visit((ParseTree)ctx.joinWherePredicate().joinFieldPair(i));
        }
        Dataset dataset = (Dataset)this.datasetsVisitor.visit((ParseTree)ctx.datasetParse());
        FromCommand rhs = dataset.from();
        return new JoinCommand(new SearchCommand(), rhs, joinClauses, this.joinType, true, true, this.overwrite, this.max, this.lhsAlias, this.rhsAlias);
    }

    private static String parseAndValidateJoinField(SplunkCommandParser.JoinFieldContext ctx, String alias) {
        String navText = ctx.NAVFIELD().getSymbol().getText();
        String[] identifiers = navText.split("\\.");
        if (identifiers.length < 2) {
            throw new IllegalArgumentException("Invalid qualified field: " + ctx.NAVFIELD().getSymbol().getText() + " . correct format: <qualifier>'.'<fieldname>");
        }
        if (!alias.equals(identifiers[0])) {
            throw new IllegalArgumentException("Invalid qualified field: " + ctx.NAVFIELD().getSymbol().getText() + " . The qualifier used doesn't match the alias: " + alias + " specified using left=<alias-name> or right=<alias-name>");
        }
        return navText.substring(identifiers[0].length() + 1);
    }

    @Override
    public Node visitJoinFieldPair(SplunkCommandParser.JoinFieldPairContext ctx) {
        String lhsField = CommandJoinVisitor.parseAndValidateJoinField(ctx.joinField(0), this.lhsAlias);
        String rhsField = CommandJoinVisitor.parseAndValidateJoinField(ctx.joinField(1), this.rhsAlias);
        return new JoinNode(lhsField, rhsField);
    }

    @Override
    public Node visitJoinOptionType(SplunkCommandParser.JoinOptionTypeContext ctx) {
        if (this.joinType != JoinCommand.DEFAULT_JOIN_TYPE) {
            throw new IllegalArgumentException("Multiple conflicting values specified for option \"type\"");
        }
        this.joinType = JoinType.valueOf(ctx.joinType().getText().toUpperCase());
        return null;
    }

    @Override
    public Node visitJoinOptionOverwrite(SplunkCommandParser.JoinOptionOverwriteContext ctx) {
        if (!this.overwrite) {
            throw new IllegalArgumentException("Multiple conflicting values specified for option \"overwrite\"");
        }
        this.overwrite = Boolean.parseBoolean(ctx.boolValue().getText());
        return null;
    }

    @Override
    public Node visitJoinOptionMax(SplunkCommandParser.JoinOptionMaxContext ctx) {
        if (this.max != 1) {
            throw new IllegalArgumentException("Multiple conflicting values specified for option \"max\"");
        }
        this.max = Integer.parseInt(ctx.INTEGER().getText());
        return null;
    }
}

