/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast;

import com.splunk.commons.ast.NodeParser;
import com.splunk.commons.ast.antlr.CompleteSPLParser;
import com.splunk.commons.ast.nodes.CommandInfo;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.AppendCommand;
import com.splunk.commons.ast.nodes.commands.BinCommand;
import com.splunk.commons.ast.nodes.commands.Conditional;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.IfCommand;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.IntoCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.LoadJobCommand;
import com.splunk.commons.ast.nodes.commands.LookupCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.commands.MvexpandCommand;
import com.splunk.commons.ast.nodes.commands.RegexCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.ReplacementNode;
import com.splunk.commons.ast.nodes.commands.RexCommand;
import com.splunk.commons.ast.nodes.commands.SavedsearchCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SelfJoinCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsOptions;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.commands.TimechartCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.Cardinality;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.EvalAggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.InNode;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.JoinType;
import com.splunk.commons.ast.nodes.expressions.LogSpanNode;
import com.splunk.commons.ast.nodes.expressions.MeasureNode;
import com.splunk.commons.ast.nodes.expressions.MultiValueNode;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.PercentageAggregateNode;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TableColumnOptionsNode;
import com.splunk.commons.ast.nodes.expressions.TimeSpanNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchInNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchPhraseNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchTermNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.util.VisitorUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonParser
extends NodeParser<JSONObject> {
    private final CompleteSPLParser parser = new CompleteSPLParser();
    private final boolean enableDatasetSerializationShorthand;
    private final boolean enableByFieldsTypeNodeSerializationFormat;

    public JsonParser() {
        this(true, true);
    }

    public JsonParser(boolean enableDatasetSerializationShorthand, boolean enableByFieldsTypeNodeSerializationFormat) {
        this.enableDatasetSerializationShorthand = enableDatasetSerializationShorthand;
        this.enableByFieldsTypeNodeSerializationFormat = enableByFieldsTypeNodeSerializationFormat;
    }

    private static void assertEquals(Object a, Object b) {
        assert ((a != null || b == null) && Objects.equals(a, b));
    }

    @Override
    public Node parse(JSONObject source) {
        if (source.has("command") || source.has("datasettype")) {
            return this.loadCommandNode(source);
        }
        if (source.has("ast")) {
            return this.loadCommandNode(source.getJSONObject("ast"));
        }
        if (source.has("type")) {
            return this.loadTypeNode(source);
        }
        if (source.has("mode")) {
            return JsonParser.loadSortBy(source);
        }
        return null;
    }

    private CommandNode loadCommandNode(JSONObject json) {
        String command;
        switch (command = this.enableDatasetSerializationShorthand ? json.optString("command", "from") : json.getString("command")) {
            case "append": {
                return this.loadAppendCommand(json);
            }
            case "apply": {
                return this.loadApplyCommand(json);
            }
            case "fit": {
                return this.loadFitCommand(json);
            }
            case "bin": {
                return this.loadBinCommand(json);
            }
            case "eval": {
                return this.loadEvalCommand(json);
            }
            case "fields": {
                return this.loadFieldsCommand(json);
            }
            case "from": {
                return this.loadFromCommand(json);
            }
            case "head": {
                return this.loadHeadCommand(json);
            }
            case "if": {
                return this.loadIfCommand(json);
            }
            case "inputlookup": {
                return this.loadInputlookupCommand(json);
            }
            case "into": {
                return this.loadIntoCommand(json);
            }
            case "iplocation": {
                return this.loadIplocationCommand(json);
            }
            case "join": {
                return this.loadJoinCommand(json);
            }
            case "selfjoin": {
                return this.loadSelfJoinCommand(json);
            }
            case "loadjob": {
                return this.loadLoadJobCommand(json);
            }
            case "lookup": {
                return this.loadLookupCommand(json);
            }
            case "mstats": {
                return this.loadMstatsCommand(json);
            }
            case "mcatalog": {
                return this.loadMcatalogCommand(json);
            }
            case "regex": {
                return this.loadRegexCommand(json);
            }
            case "rename": {
                return this.loadRenameCommand(json);
            }
            case "reverse": {
                return this.loadReverseCommand(json);
            }
            case "rex": {
                return this.loadRexCommand(json);
            }
            case "savedsearch": {
                return JsonParser.loadSavedsearchCommand(json);
            }
            case "search": {
                return this.loadSearchCommand(json);
            }
            case "sendalert": {
                return this.loadSendalertCommand(json);
            }
            case "sort": {
                return this.loadSortCommand(json);
            }
            case "stats": {
                return this.loadStatsCommand(json);
            }
            case "timechart": {
                return this.loadTimechartComand(json);
            }
            case "table": {
                return this.loadTableCommand(json);
            }
            case "tail": {
                return this.loadTailCommand(json);
            }
            case "tstats": {
                return this.loadTstatsCommand(json);
            }
            case "union": {
                return this.loadUnionCommand(json);
            }
            case "where": {
                return this.loadWhereCommand(json);
            }
            case "dedup": {
                return this.loadDedupCommand(json);
            }
            case "mvexpand": {
                return this.loadMvexpandCommand(json);
            }
        }
        return this.loadUnknownCommand(json);
    }

    private TypeNode loadTypeNode(JSONObject json) {
        return this.loadTypeNode(json, false);
    }

    private TypeNode loadTypeNode(JSONObject json, boolean inSearch) {
        String type;
        switch (type = json.getString("type")) {
            case "invalid": {
                return NullNode.load(json.get("value").toString());
            }
            case "conditional": {
                return this.loadConditional(json);
            }
            case "field": {
                return this.loadField(json);
            }
            case "navigation": {
                return JsonParser.loadNavigation(json);
            }
            case "function": {
                return this.loadFunctionNode(json, inSearch);
            }
            case "measure": {
                return new MeasureNode(json.getString("value"));
            }
            case "number": {
                return Expression.number(json.getBigDecimal("value"));
            }
            case "string": {
                return Expression.string(json.getString("value"));
            }
            case "term": 
            case "phrase": {
                return JsonParser.loadQuotableNode(json);
            }
            case "multivalue": {
                return JsonParser.loadMultiValue(json);
            }
            case "timespan": {
                return new TimeSpanNode(json.getString("value"));
            }
            case "logspan": {
                return new LogSpanNode(json.getString("value"));
            }
            case "bool": {
                return this.loadBooleanNode(json, false);
            }
        }
        throw new UnsupportedOperationException();
    }

    private FieldNode loadField(JSONObject json) {
        Objects.requireNonNull(json);
        assert (json.getString("type").equals("field"));
        String fieldName = json.getString("value");
        if (json.has("source")) {
            NavigationNode source = JsonParser.loadNavigation(json.getJSONObject("source"));
            return Expression.field(source, fieldName);
        }
        return Expression.field(fieldName);
    }

    private static NavigationNode loadNavigation(JSONObject json) {
        Objects.requireNonNull(json);
        assert (json.getString("type").equals("navigation"));
        String name = json.getString("name");
        Cardinality cardinality = Cardinality.valueOf(Cardinality.class, json.getString("cardinality"));
        if (json.has("source")) {
            NavigationNode source = JsonParser.loadNavigation(json.getJSONObject("source"));
            return Expression.navigation(source, name, cardinality);
        }
        return Expression.navigation(name, cardinality);
    }

    private Conditional loadConditional(JSONObject json) {
        Objects.requireNonNull(json);
        assert (json.getString("type").equals("conditional"));
        JSONObject pipelineJSON = json.getJSONObject("pipeline");
        CommandNode pipeline = this.loadCommandNode(pipelineJSON);
        JSONObject filterJSON = json.optJSONObject("filter");
        if (filterJSON != null) {
            return new Conditional(this.loadPredicate(filterJSON), pipeline);
        }
        return new Conditional(pipeline);
    }

    private static SortNode loadSortBy(JSONObject json) {
        Objects.requireNonNull(json);
        assert (json.has("mode"));
        String fieldName = json.getString("name");
        SortOrder order = SortOrder.valueOf(json.getString("mode").toUpperCase());
        FieldType function = FieldType.valueOf(json.getString("function").toUpperCase());
        return new SortNode(fieldName, order, function);
    }

    private TypeNode loadFunctionNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        String functionName = json.optString("value", "");
        JsonParser.assertEquals("function", json.getString("type"));
        switch (functionName) {
            case "bin": {
                return JsonParser.loadBinNode(json);
            }
            case "AND": {
                return this.loadAndNode(json, inSearch);
            }
            case "OR": {
                return this.loadOrNode(json, inSearch);
            }
            case "in": {
                return this.loadInNode(json, inSearch);
            }
            case "=": 
            case "==": 
            case "!=": 
            case ">": 
            case ">=": 
            case "<": 
            case "<=": {
                return this.loadComparisonNode(json, inSearch);
            }
            case "XOR": {
                return this.loadXorNode(json, inSearch);
            }
            case "searchmatch": {
                TypeNode[] args = this.loadTypeNodesFromArgs(json, true);
                return FunctionNode.create(FunctionNode.FunctionName.searchmatch, args);
            }
        }
        TypeNode[] args = this.loadTypeNodesFromArgs(json, inSearch);
        FunctionNode.FunctionName fname = FunctionNode.FunctionName.lookup(functionName);
        if (fname == FunctionNode.FunctionName.__stats__) {
            return new FunctionNode.StatsFunctionNode(AggregateFunction.fromString(functionName), args);
        }
        return FunctionNode.create(fname, args);
    }

    private TypeNode loadBooleanNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        String value = json.optString("value", "");
        JsonParser.assertEquals("bool", json.getString("type"));
        return BooleanNode.load(value);
    }

    private static BinNode loadBinNode(JSONObject json) {
        FieldNode field = null;
        BinOptionsNode binOptions = null;
        if (json.has("args")) {
            JSONObject args = json.getJSONObject("args");
            field = new FieldNode(args.getString("field"));
            if (args.has("binoptions")) {
                JSONObject binOpts = args.getJSONObject("binoptions");
                SpanNode span = null;
                TimeSpanNode minspan = null;
                NumberNode bins = null;
                NumberNode start = null;
                NumberNode end = null;
                StringNode nullstr = null;
                StringNode otherstr = null;
                BooleanNode usenull = null;
                BooleanNode useother = null;
                if (binOpts.has("span")) {
                    span = SpanNode.getSpanNode(binOpts.getString("span"));
                }
                if (binOpts.has("minspan")) {
                    minspan = new TimeSpanNode(binOpts.getString("minspan"));
                }
                if (binOpts.has("bins")) {
                    bins = new NumberNode(binOpts.getInt("bins"));
                }
                if (binOpts.has("start")) {
                    start = new NumberNode(binOpts.getNumber("start"));
                }
                if (binOpts.has("end")) {
                    end = new NumberNode(binOpts.getNumber("end"));
                }
                binOptions = new BinOptionsNode(span, minspan, bins, start, end);
                if (binOpts.has("nullstr")) {
                    nullstr = new StringNode(binOpts.getString("nullstr"));
                }
                if (binOpts.has("otherstr")) {
                    otherstr = new StringNode(binOpts.getString("otherstr"));
                }
                if (binOpts.has("usenull")) {
                    usenull = BooleanNode.load(binOpts.getBoolean("usenull"));
                }
                if (binOpts.has("useother")) {
                    useother = BooleanNode.load(binOpts.getBoolean("useother"));
                }
                if (!VisitorUtil.allNull(nullstr, otherstr, usenull, useother)) {
                    binOptions = new TableColumnOptionsNode(binOptions, usenull, useother, nullstr, otherstr);
                }
            }
        }
        return new BinNode(field, binOptions);
    }

    private TypeNode[] loadTypeNodesFromArgs(JSONObject json, boolean inSearch) {
        return this.loadTypeNodesFromArgs(json, 0, inSearch);
    }

    private TypeNode[] loadTypeNodesFromArgs(JSONObject json, int start, boolean inSearch) {
        TypeNode[] argNodes;
        if (json.has("args")) {
            JSONArray array = json.optJSONArray("args");
            if (array == null) {
                array = new JSONArray();
                array.put((Object)json.getJSONObject("args"));
            }
            argNodes = new TypeNode[array.length() - start];
            for (int i = start; i < array.length(); ++i) {
                argNodes[i - start] = this.loadTypeNode(array.getJSONObject(i), inSearch);
            }
        } else {
            argNodes = new TypeNode[]{};
        }
        return argNodes;
    }

    private TypeNode loadAndNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        JsonParser.assertEquals("function", json.getString("type"));
        JsonParser.assertEquals("AND", json.getString("value"));
        if (inSearch) {
            if (!json.has("args")) {
                return new SearchAndNode(new ISearchPredicate[0]);
            }
            return new SearchAndNode(this.loadSearchPredicateArray(json.getJSONArray("args")));
        }
        if (!json.has("args")) {
            return new AndNode(new IWherePredicate[0]);
        }
        return new AndNode(this.loadPredicateArray(json.getJSONArray("args")));
    }

    private TypeNode loadOrNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        JsonParser.assertEquals("function", json.getString("type"));
        JsonParser.assertEquals("OR", json.getString("value"));
        if (inSearch) {
            if (!json.has("args")) {
                return new SearchOrNode(new ISearchPredicate[0]);
            }
            return new SearchOrNode(this.loadSearchPredicateArray(json.getJSONArray("args")));
        }
        if (!json.has("args")) {
            return new OrNode(new IWherePredicate[0]);
        }
        return new OrNode(this.loadPredicateArray(json.getJSONArray("args")));
    }

    private TypeNode loadXorNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        JsonParser.assertEquals("function", json.getString("type"));
        JsonParser.assertEquals("XOR", json.getString("value"));
        assert (json.has("args"));
        if (inSearch) {
            return new SearchXorNode(this.loadSearchPredicateArray(json.getJSONArray("args")));
        }
        return new XorNode(this.loadPredicateArray(json.getJSONArray("args")));
    }

    private TypeNode loadInNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        JsonParser.assertEquals("function", json.getString("type"));
        JsonParser.assertEquals("in", json.getString("value"));
        assert (json.has("args"));
        if (inSearch) {
            JSONArray args = json.getJSONArray("args");
            assert (args.length() > 1) : "Must have >1 args";
            String fieldName = args.getJSONObject(0).getString("value");
            return new SearchInNode(Expression.field(fieldName), this.loadTypeNodesFromArgs(json, 1, inSearch));
        }
        return new InNode(this.loadTypeNodesFromArgs(json, inSearch));
    }

    private TypeNode loadComparisonNode(JSONObject json, boolean inSearch) {
        Objects.requireNonNull(json);
        JsonParser.assertEquals("function", json.getString("type"));
        String operator = json.getString("value");
        JSONArray args = json.getJSONArray("args");
        JsonParser.assertEquals(2, args.length());
        if (inSearch) {
            boolean isNegated = json.optBoolean("is_negated", false);
            boolean isLiteralTerm = json.optBoolean("is_literal_term", false);
            boolean isCaseSensitive = json.optBoolean("is_case_sensitive", false);
            boolean isIndexed = json.optBoolean("is_indexed", false);
            boolean isLhsQuoted = json.optBoolean("is_lhs_quoted", false);
            boolean isRhsQuoted = json.optBoolean("is_rhs_quoted", false);
            String fieldName = args.getJSONObject(0).getString("value");
            Object value = args.getJSONObject(1).get("value");
            SearchModifier modifier = isCaseSensitive ? SearchModifier.CASE : (isLiteralTerm ? SearchModifier.TERM : SearchModifier.NONE);
            boolean isNumeric = json.optBoolean("is_numeric", false);
            NumberNode valueNode = null;
            if (isNumeric) {
                try {
                    valueNode = Expression.number(NumberFormat.getInstance().parse(value.toString()));
                }
                catch (ParseException e) {
                    valueNode = null;
                }
            }
            if (valueNode == null) {
                valueNode = value instanceof Number ? Expression.number((Number)value) : Expression.string(value.toString());
            }
            return new SearchComparisonNode(Operator.load(operator), Expression.field(fieldName), valueNode, isNegated, isLhsQuoted, isRhsQuoted, isIndexed, modifier);
        }
        return new ComparisonNode(Operator.load(operator), this.loadTypeNode(args.getJSONObject(0), inSearch), this.loadTypeNode(args.getJSONObject(1), inSearch));
    }

    private IWherePredicate[] loadPredicateArray(JSONArray array) {
        Objects.requireNonNull(array);
        IWherePredicate[] ret = new IWherePredicate[array.length()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.loadPredicate(array.optJSONObject(i));
        }
        return ret;
    }

    private IWherePredicate loadPredicate(JSONObject object) {
        Objects.requireNonNull(object);
        if (!object.has("type")) {
            return null;
        }
        switch (object.getString("type")) {
            case "function": {
                return (IWherePredicate)((Object)this.loadFunctionNode(object, false));
            }
            case "bool": {
                return (IWherePredicate)((Object)this.loadBooleanNode(object, false));
            }
        }
        throw new UnsupportedOperationException();
    }

    private ISearchPredicate[] loadSearchPredicateArray(JSONArray array) {
        Objects.requireNonNull(array);
        ISearchPredicate[] ret = new ISearchPredicate[array.length()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.loadSearchPredicate(array.optJSONObject(i));
        }
        return ret;
    }

    private ISearchPredicate loadSearchPredicate(JSONObject object) {
        Objects.requireNonNull(object);
        switch (object.getString("type")) {
            case "term": 
            case "phrase": {
                return JsonParser.loadQuotableNode(object);
            }
            case "function": {
                return (ISearchPredicate)((Object)this.loadFunctionNode(object, true));
            }
            case "subsearch": {
                return this.loadSubsearchPredicateNode(object);
            }
        }
        throw new UnsupportedOperationException();
    }

    private SearchSubSearchPredicateNode loadSubsearchPredicateNode(JSONObject json) {
        Objects.requireNonNull(json);
        CommandNode subsearch = this.loadCommandNode(json.getJSONObject("search"));
        boolean isNegated = json.optBoolean("is_negated", false);
        return new SearchSubSearchPredicateNode(subsearch, isNegated);
    }

    private static ReplacementNode loadReplacementNode(JSONObject jsonObject) {
        return new ReplacementNode(jsonObject.getString("placeholder"), jsonObject.getString("replacement"));
    }

    private static SearchQuotableNode loadQuotableNode(JSONObject object) {
        SearchModifier modifier;
        Objects.requireNonNull(object);
        String type = object.getString("type");
        assert (type.equals("term") || type.equals("phrase"));
        String value = object.getString("value");
        boolean isNegated = object.optBoolean("is_negated", false);
        boolean isQuoted = object.optBoolean("is_quoted", false);
        boolean isLiteralTerm = object.optBoolean("is_literal_term", false);
        boolean isCaseSensitive = object.optBoolean("is_case_sensitive", false);
        SearchModifier searchModifier = isCaseSensitive ? SearchModifier.CASE : (modifier = isLiteralTerm ? SearchModifier.TERM : SearchModifier.NONE);
        if (type.equals("term")) {
            return new SearchTermNode(value, isNegated, isQuoted, modifier);
        }
        return new SearchPhraseNode(value, isNegated, isQuoted, modifier);
    }

    private static ParamNode loadParamNode(JSONObject object) {
        Objects.requireNonNull(object);
        String name = object.getString("paramName");
        String value = object.getString("paramValue");
        return new ParamNode(name, value);
    }

    private CommandNode loadAppendCommand(JSONObject json) {
        CommandNode[] sources = this.getSources(json);
        assert (sources.length == 2);
        return new AppendCommand(sources[0], sources[1]);
    }

    private CommandNode loadBinCommand(JSONObject json) {
        JsonParser.assertEquals("bin", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        FieldNode field = new FieldNode(json.getString("bin_field"));
        SpanNode span = null;
        TimeSpanNode minspan = null;
        NumberNode bins = null;
        NumberNode start = null;
        NumberNode end = null;
        if (json.has("span")) {
            span = SpanNode.getSpanNode(json.getString("span"));
        }
        if (json.has("minspan")) {
            minspan = new TimeSpanNode(json.getString("minspan"));
        }
        if (json.has("bins")) {
            bins = new NumberNode(json.getInt("bins"));
        }
        if (json.has("start")) {
            start = new NumberNode(json.getNumber("start"));
        }
        if (json.has("end")) {
            end = new NumberNode(json.getNumber("end"));
        }
        BinOptionsNode binOptions = new BinOptionsNode(span, minspan, bins, start, end);
        BinNode binNode = new BinNode(field, binOptions);
        FieldNode newField = json.has("rename") ? new FieldNode(json.getString("rename")) : null;
        return new BinCommand(source, binNode, newField);
    }

    private CommandNode loadEvalCommand(JSONObject json) {
        JsonParser.assertEquals("eval", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        JSONArray array = json.getJSONArray("assignments");
        AssignmentNode[] assignments = new AssignmentNode[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            assignments[i] = this.loadAssignmentNode(array.getJSONObject(i), false);
        }
        return new EvalCommand(source, assignments);
    }

    private AssignmentNode loadAssignmentNode(JSONObject jsonObject, boolean inSearch) {
        String fieldName = jsonObject.getString("field");
        JSONObject expression = jsonObject.getJSONObject("value");
        TypeNode value = this.loadTypeNode(expression, inSearch);
        if (jsonObject.has("bracketindex")) {
            int bracketIndex = jsonObject.getInt("bracketindex");
            return new AssignmentNode(new FieldNode(fieldName), value, bracketIndex);
        }
        return new AssignmentNode(fieldName, value);
    }

    private CommandNode loadFieldsCommand(JSONObject command) {
        JsonParser.assertEquals("fields", command.getString("command"));
        boolean removeAttributes = command.getBoolean("remove_attributes");
        JSONArray fieldList = command.getJSONArray("field_list");
        FieldNode[] fields = new FieldNode[fieldList.length()];
        for (int i = 0; i < fieldList.length(); ++i) {
            fields[i] = new FieldNode(fieldList.getString(i));
        }
        return new FieldsCommand(this.getRequiredSource(command), fields, removeAttributes);
    }

    private Dataset loadDataset(JSONObject json) {
        String kind = null;
        if (json.get("datasettype") instanceof String) {
            kind = json.getString("datasettype");
        }
        if (kind != null && kind.equals("transient")) {
            return new TransientDataset(this.loadCommandNode(json.getJSONObject("dataset")));
        }
        String name = json.getString("dataset");
        if (kind != null && kind.equals("datamodel")) {
            name = name.replace(" flat", "").replace(" ", ".");
        }
        return new Dataset(kind, name);
    }

    private CommandNode loadFromCommand(JSONObject fromCommand) {
        int i;
        JSONArray array;
        String commandName = fromCommand.optString("command", "");
        if (this.enableDatasetSerializationShorthand && commandName.isEmpty()) {
            return new FromCommand(this.loadDataset(fromCommand));
        }
        JsonParser.assertEquals("from", commandName);
        IWherePredicate predicate = null;
        IGroupBy[] groupBy = null;
        ISelection[] selections = null;
        IOrdering[] orderBy = null;
        Dataset dataset = this.loadDataset(fromCommand.getJSONObject("object"));
        if (fromCommand.has("predicate")) {
            predicate = this.loadPredicate(fromCommand.getJSONObject("predicate"));
        }
        if (fromCommand.has("groupby")) {
            array = fromCommand.getJSONArray("groupby");
            groupBy = new IGroupBy[array.length()];
            for (int i2 = 0; i2 < array.length(); ++i2) {
                groupBy[i2] = this.loadGroupBy(array.getJSONObject(i2));
            }
        }
        if (fromCommand.has("select")) {
            array = fromCommand.getJSONArray("select");
            ArrayList<ISelection> selectionsList = new ArrayList<ISelection>();
            selections = new ISelection[array.length()];
            for (i = 0; i < array.length(); ++i) {
                JSONObject selection = array.getJSONObject(i);
                selectionsList.add(this.loadSelection(selection));
            }
            selectionsList.toArray(selections);
        }
        if (fromCommand.has("orderby")) {
            array = fromCommand.getJSONArray("orderby");
            ArrayList<SortNode> orderByList = new ArrayList<SortNode>();
            orderBy = new IOrdering[array.length()];
            for (i = 0; i < array.length(); ++i) {
                JSONObject ordering = array.getJSONObject(i);
                orderByList.add(JsonParser.loadSortBy(ordering));
            }
            orderByList.toArray(orderBy);
        }
        return new FromCommand(dataset, predicate, groupBy, selections, orderBy);
    }

    private CommandNode loadHeadCommand(JSONObject json) {
        JsonParser.assertEquals("head", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        int limit = json.getInt("limit");
        if (json.has("eval_expression")) {
            JSONObject evalExpression = json.getJSONObject("eval_expression");
            boolean keeplast = evalExpression.getBoolean("keeplast");
            boolean nullIsMatch = evalExpression.getBoolean("null");
            IWherePredicate predicate = this.loadPredicate(evalExpression);
            return source.head(limit, predicate, keeplast, nullIsMatch);
        }
        return source.head(limit);
    }

    private CommandNode loadIfCommand(JSONObject json) {
        JsonParser.assertEquals("if", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        JSONArray conditionsJSON = json.getJSONArray("conditions");
        Conditional[] conditions = new Conditional[conditionsJSON.length()];
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i] = this.loadConditional(conditionsJSON.getJSONObject(i));
        }
        return new IfCommand(source, conditions);
    }

    private CommandNode loadInputlookupCommand(JSONObject json) {
        CommandNode source;
        JsonParser.assertEquals("inputlookup", json.getString("command"));
        String inputlookupName = json.getString("table");
        int start = json.getInt("start");
        int max = json.getInt("max");
        ISearchPredicate predicate = null;
        if (json.has("predicate")) {
            predicate = this.loadSearchPredicate(json.getJSONObject("predicate"));
        }
        if ((source = this.getOptionalSource(json)) == null) {
            return new InputlookupCommand(inputlookupName, predicate, start, max);
        }
        return new InputlookupCommand(source, inputlookupName, predicate, start, max);
    }

    private CommandNode loadIntoCommand(JSONObject json) {
        JsonParser.assertEquals("into", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        IntoCommand.IntoMode mode = json.has("mode") ? IntoCommand.IntoMode.valueOf(json.getString("mode")) : null;
        JSONObject object = json.getJSONObject("object");
        String dataset = object.getString("dataset");
        String provider = object.getString("datasettype");
        return new IntoCommand(source, new Dataset(provider, dataset), mode);
    }

    private CommandNode loadIplocationCommand(JSONObject json) {
        JsonParser.assertEquals("iplocation", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        String ip = json.getString("ip");
        String lang = json.getString("lang");
        String prefix = json.getString("prefix");
        boolean allfields = json.getBoolean("allfields");
        return source.iplocation(ip, prefix, lang, allfields);
    }

    private CommandNode loadJoinCommand(JSONObject json) {
        int i;
        JsonParser.assertEquals("join", json.getString("command"));
        CommandNode[] sources = this.getSources(json);
        if (sources.length != 2) {
            throw new IllegalArgumentException("Incorrect usage of the 'join' command: it must contains a main search and a subsearch.");
        }
        CommandNode lhs = sources[0];
        CommandNode rhs = sources[1];
        JoinType type = JoinType.valueOf(json.has("jointype") ? json.getString("jointype").toUpperCase() : json.getString("join_type").toUpperCase());
        boolean usetime = json.getBoolean("usetime");
        boolean earlier = json.getBoolean("earlier");
        boolean overwrite = json.getBoolean("overwrite");
        int max = json.getInt("max");
        String lhsAlias = "";
        if (json.has("lhsalias")) {
            lhsAlias = json.getString("lhsalias");
        }
        String rhsAlias = "";
        if (json.has("rhsalias")) {
            rhsAlias = json.getString("rhsalias");
        }
        JSONArray joinClauses = null;
        if (json.has("joinClauses")) {
            joinClauses = json.getJSONArray("joinClauses");
        } else {
            joinClauses = new JSONArray();
            if (json.has("joins")) {
                JSONArray array = json.getJSONArray("joins");
                for (i = 0; i < array.length(); ++i) {
                    String joinClause = array.getString(i);
                    JSONObject obj = new JSONObject();
                    obj.put("sourceField", (Object)joinClause);
                    obj.put("joinField", (Object)joinClause);
                    joinClauses.put((Object)obj);
                }
            }
        }
        JoinNode[] clauses = new JoinNode[joinClauses.length()];
        for (i = 0; i < clauses.length; ++i) {
            clauses[i] = JsonParser.loadJoinNode(joinClauses.getJSONObject(i));
        }
        return new JoinCommand(lhs, rhs, clauses, type, usetime, earlier, overwrite, max, lhsAlias, rhsAlias);
    }

    private CommandNode loadLoadJobCommand(JSONObject json) {
        JsonParser.assertEquals("loadjob", json.getString("command"));
        if (!json.has("job")) {
            throw new IllegalArgumentException("LOADJOB command JSON AST missing job field.");
        }
        String jobName = json.getString("job");
        return new LoadJobCommand(jobName);
    }

    private CommandNode loadLookupCommand(JSONObject json) {
        JsonParser.assertEquals("lookup", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        String dataset = json.getJSONObject("object").getString("dataset");
        JoinNode[] selections = null;
        JSONArray array = json.getJSONArray("joins");
        JoinNode[] joins = new JoinNode[array.length()];
        for (int i = 0; i < joins.length; ++i) {
            joins[i] = JsonParser.loadJoinNode(array.getJSONObject(i));
        }
        boolean local = json.optBoolean("local", false);
        boolean update = json.getBoolean("update");
        LookupCommand.LookupMode mode = LookupCommand.LookupMode.valueOf(json.optString("mode", "all").toUpperCase());
        if (mode != LookupCommand.LookupMode.ALL) {
            array = json.getJSONArray("selections");
            selections = new JoinNode[array.length()];
            for (int i = 0; i < selections.length; ++i) {
                selections[i] = JsonParser.loadSelectionNodeIntoJoinNode(array.getJSONObject(i));
            }
        }
        boolean required = json.getBoolean("required");
        boolean forceIndexed = json.getBoolean("forceIndexed");
        return new LookupCommand(source, dataset, joins, mode, selections, update, local, required, forceIndexed);
    }

    private CommandNode loadMstatsCommand(JSONObject json) {
        int i;
        JsonParser.assertEquals("mstats", json.getString("command"));
        IGroupBy[] byFields = null;
        ISearchPredicate predicate = null;
        JSONArray array = json.getJSONArray("aggregates");
        AggregateNode[] aggregates = new AggregateNode[array.length()];
        for (i = 0; i < aggregates.length; ++i) {
            aggregates[i] = this.loadAggregateNode(array.getJSONObject(i));
        }
        if (json.has("by")) {
            array = json.getJSONArray("by");
            byFields = new IGroupBy[array.length()];
            for (i = 0; i < array.length(); ++i) {
                byFields[i] = this.loadGroupBy(array.getJSONObject(i));
            }
        }
        if (json.has("predicate")) {
            predicate = this.loadSearchPredicate(json.getJSONObject("predicate"));
        }
        return new MStatsCommand(aggregates, byFields, predicate);
    }

    private CommandNode loadMcatalogCommand(JSONObject json) {
        int i;
        JsonParser.assertEquals("mcatalog", json.getString("command"));
        IGroupBy[] byFields = null;
        IWherePredicate predicate = null;
        JSONArray array = json.getJSONArray("aggregates");
        AggregateNode[] aggregates = new AggregateNode[array.length()];
        for (i = 0; i < aggregates.length; ++i) {
            aggregates[i] = this.loadAggregateNode(array.getJSONObject(i));
        }
        if (json.has("by")) {
            array = json.getJSONArray("by");
            byFields = new IGroupBy[array.length()];
            for (i = 0; i < byFields.length; ++i) {
                byFields[i] = this.loadGroupBy(array.getJSONObject(i));
            }
        }
        if (json.has("predicate")) {
            predicate = this.loadPredicate(json.getJSONObject("predicate"));
        }
        boolean prestats = json.has("prestats") ? json.getBoolean("prestats") : false;
        boolean append = json.has("append") ? json.getBoolean("append") : false;
        return new McatalogCommand(aggregates, predicate, byFields, prestats, append);
    }

    private CommandNode loadMvexpandCommand(JSONObject json) {
        JsonParser.assertEquals("mvexpand", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        String fieldName = json.optString("field", "_raw");
        if (json.has("limit")) {
            int limit = json.getInt("limit");
            return new MvexpandCommand(source, new FieldNode(fieldName), limit);
        }
        return new MvexpandCommand(source, new FieldNode(fieldName));
    }

    private CommandNode loadRegexCommand(JSONObject regexCommand) {
        JsonParser.assertEquals("regex", regexCommand.getString("command"));
        String regex = regexCommand.optString("regex_expresion", null);
        if (regex == null) {
            regex = regexCommand.getString("regex_expression");
        }
        String field = regexCommand.getString("field");
        Operator op = Operator.EQUAL.equals(regexCommand.getString("op")) ? Operator.EQUAL : Operator.NOT_EQUAL;
        return new RegexCommand(this.getRequiredSource(regexCommand), field, op, regex);
    }

    private CommandNode loadRenameCommand(JSONObject renameCommand) {
        JsonParser.assertEquals("rename", renameCommand.getString("command"));
        JSONArray jsonRenames = renameCommand.getJSONArray("renames");
        RenameNode[] renames = new RenameNode[jsonRenames.length()];
        for (int i = 0; i < renames.length; ++i) {
            renames[i] = JsonParser.loadRenameNode(jsonRenames.getJSONObject(i));
        }
        return new RenameCommand(this.getRequiredSource(renameCommand), renames);
    }

    private CommandNode loadReverseCommand(JSONObject json) {
        JsonParser.assertEquals("reverse", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        return source.reverse();
    }

    private CommandNode loadRexCommand(JSONObject rexCommand) {
        String offsetFieldStr;
        JsonParser.assertEquals("rex", rexCommand.getString("command"));
        FieldNode field = new FieldNode(rexCommand.optString("field", "_raw"));
        boolean sedMode = rexCommand.getBoolean("sed_mode");
        if (sedMode) {
            String sedExpression = rexCommand.getString("sed_expression");
            return RexCommand.sed(this.getRequiredSource(rexCommand), sedExpression, field);
        }
        String regexExpression = rexCommand.getString("regex_expression");
        int maxMatch = rexCommand.optInt("max_match", 1);
        FieldNode offsetField = null;
        if (rexCommand.has("offset_field") && !(offsetFieldStr = rexCommand.getString("offset_field")).equals("")) {
            offsetField = new FieldNode(offsetFieldStr);
        }
        return RexCommand.rex(this.getRequiredSource(rexCommand), regexExpression, field, offsetField, maxMatch);
    }

    private static CommandNode loadSavedsearchCommand(JSONObject json) {
        JsonParser.assertEquals("savedsearch", json.getString("command"));
        JSONObject object = json.getJSONObject("object");
        JsonParser.assertEquals("savedsearch", object.getString("datasettype"));
        String savedSearchName = object.getString("dataset");
        JSONArray array = json.getJSONArray("replacements");
        ReplacementNode[] replacements = new ReplacementNode[array.length()];
        for (int i = 0; i < replacements.length; ++i) {
            replacements[i] = JsonParser.loadReplacementNode(array.getJSONObject(i));
        }
        return new SavedsearchCommand(savedSearchName, replacements);
    }

    private CommandNode loadSearchCommand(JSONObject command) {
        JsonParser.assertEquals("search", command.getString("command"));
        ISearchPredicate predicate = this.loadSearchPredicate(command.getJSONObject("predicate"));
        CommandNode source = this.getOptionalSource(command);
        if (source == null) {
            return new SearchCommand(predicate);
        }
        return source.searchAgain(predicate);
    }

    private CommandNode loadSelfJoinCommand(JSONObject json) {
        JsonParser.assertEquals("selfjoin", json.getString("command"));
        CommandNode[] sources = this.getSources(json);
        if (sources.length != 1) {
            throw new IllegalArgumentException("Incorrect usage of the 'selfjoin' command.");
        }
        CommandNode lhs = sources[0];
        boolean keepSingle = json.getBoolean("keepsingle");
        boolean overwrite = json.getBoolean("overwrite");
        int max = json.getInt("max");
        JSONArray joinClauses = json.getJSONArray("joinClauses");
        JoinNode[] clauses = new JoinNode[joinClauses.length()];
        for (int i = 0; i < clauses.length; ++i) {
            clauses[i] = JsonParser.loadJoinNode(joinClauses.getJSONObject(i));
        }
        return new SelfJoinCommand(lhs, clauses, overwrite, max, keepSingle);
    }

    private CommandNode loadSendalertCommand(JSONObject json) {
        JsonParser.assertEquals("sendalert", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        StringNode name = (StringNode)this.loadTypeNode(json.getJSONObject("alert_action_name"));
        StringNode link = (StringNode)this.loadTypeNode(json.getJSONObject("results_link"));
        StringNode path = (StringNode)this.loadTypeNode(json.getJSONObject("results_path"));
        JSONArray array = json.getJSONArray("params");
        ParamNode[] params = new ParamNode[array.length()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = JsonParser.loadParamNode(array.getJSONObject(i));
        }
        return source.sendalert(name, link, path, params);
    }

    private CommandNode loadApplyCommand(JSONObject json) {
        JsonParser.assertEquals("apply", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        String raw = json.getString("raw");
        this.parser.setTokenValidation(true);
        CommandNode mcm = (CommandNode)this.parser.parse("apply " + raw, 126);
        mcm.setSource(source);
        return mcm;
    }

    private CommandNode loadFitCommand(JSONObject json) {
        JsonParser.assertEquals("fit", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        String raw = json.getString("raw");
        this.parser.setTokenValidation(true);
        CommandNode mcm = (CommandNode)this.parser.parse("fit " + raw, 127);
        mcm.setSource(source);
        return mcm;
    }

    private CommandNode loadSortCommand(JSONObject command) {
        JsonParser.assertEquals("sort", command.getString("command"));
        CommandNode source = this.getRequiredSource(command);
        int count = command.getInt("count");
        JSONArray byClauses = command.getJSONArray("by");
        IOrdering[] by = new IOrdering[byClauses.length()];
        for (int i = 0; i < by.length; ++i) {
            by[i] = JsonParser.loadSortBy(byClauses.getJSONObject(i));
        }
        return new SortCommand(source, by, count);
    }

    private BinOptionsNode loadBinOptionsNode(JSONObject json) {
        BooleanNode useother;
        TimeSpanNode span = json.has("span") ? new TimeSpanNode(json.getString("span")) : null;
        TimeSpanNode minspan = json.has("minspan") ? new TimeSpanNode(json.getString("minspan")) : null;
        NumberNode bins = json.has("bins") ? new NumberNode(json.getInt("bins")) : null;
        NumberNode start = json.has("start") ? new NumberNode(json.getNumber("start")) : null;
        NumberNode end = json.has("end") ? new NumberNode(json.getNumber("end")) : null;
        BinOptionsNode binOptions = new BinOptionsNode(span, minspan, bins, start, end);
        StringNode nullstr = json.has("nullstr") ? new StringNode(json.getString("nullstr")) : null;
        StringNode otherstr = json.has("otherstr") ? new StringNode(json.getString("otherstr")) : null;
        BooleanNode usenull = json.has("usenull") ? BooleanNode.load(new Boolean(json.getBoolean("usenull"))) : null;
        BooleanNode booleanNode = useother = json.has("useother") ? BooleanNode.load(new Boolean(json.getBoolean("useother"))) : null;
        if (VisitorUtil.allNull(nullstr, otherstr, usenull, useother)) {
            return binOptions;
        }
        return new TableColumnOptionsNode(binOptions, usenull, useother, nullstr, otherstr);
    }

    private CommandNode loadTimechartComand(JSONObject json) {
        JsonParser.assertEquals("timechart", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        StringNode sep = json.has("sep") ? new StringNode(json.getString("sep")) : null;
        StringNode format = json.has("format") ? new StringNode(json.getString("format")) : null;
        StringNode agg = json.has("agg") ? new StringNode(json.getString("agg")) : null;
        NumberNode limit = json.has("limit") ? new NumberNode(json.getInt("limit")) : null;
        BooleanNode cont = json.has("cont") ? BooleanNode.load(new Boolean(json.getBoolean("cont"))) : null;
        BooleanNode fixedRange = json.has("fixedrange") ? BooleanNode.load(new Boolean(json.getBoolean("fixedrange"))) : null;
        BooleanNode partial = json.has("partial") ? BooleanNode.load(new Boolean(json.getBoolean("partial"))) : null;
        JSONArray array = json.getJSONArray("aggregates");
        AggregateNode[] aggregates = new AggregateNode[array.length()];
        for (int i = 0; i < aggregates.length; ++i) {
            aggregates[i] = this.loadAggregateNode(array.getJSONObject(i));
        }
        array = json.getJSONArray("by");
        IGroupBy[] byFields = new IGroupBy[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            byFields[i] = this.loadGroupBy(array.getJSONObject(i));
        }
        return new TimechartCommand(source, sep, format, partial, cont, fixedRange, limit, agg, byFields, aggregates);
    }

    private CommandNode loadStatsCommand(JSONObject json) {
        int i;
        JsonParser.assertEquals("stats", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        IGroupBy[] byFields = null;
        String jsonKey = "allnum";
        BooleanNode allnum = null;
        if (json.has(jsonKey)) {
            allnum = BooleanNode.load(json.getBoolean(jsonKey));
        }
        StringNode delim = null;
        jsonKey = "delim";
        if (json.has(jsonKey)) {
            delim = new StringNode(json.getString(jsonKey));
        }
        NumberNode partitions = null;
        jsonKey = "partitions";
        if (json.has(jsonKey)) {
            partitions = new NumberNode(json.getInt(jsonKey));
        }
        JSONArray array = json.getJSONArray("aggregates");
        AggregateNode[] aggregates = new AggregateNode[array.length()];
        for (i = 0; i < aggregates.length; ++i) {
            aggregates[i] = this.loadAggregateNode(array.getJSONObject(i));
        }
        if (json.has("by")) {
            array = json.getJSONArray("by");
            byFields = new IGroupBy[array.length()];
            for (i = 0; i < array.length(); ++i) {
                byFields[i] = this.loadGroupBy(array.getJSONObject(i));
            }
        }
        FieldsAndProperties fieldsAndProperties = new FieldsAndProperties();
        if (json.has("fields_and_properties")) {
            array = json.getJSONArray("fields_and_properties");
            fieldsAndProperties = new FieldsAndProperties();
            for (int i2 = 0; i2 < array.length(); ++i2) {
                JSONObject field = array.getJSONObject(i2);
                boolean modified = field.optBoolean("modified", false);
                boolean removed = field.optBoolean("removed", false);
                boolean referenced = field.optBoolean("referenced", false);
                boolean filterable = field.optBoolean("filterable", false);
                fieldsAndProperties.field(field.getString("name"), modified, referenced, removed, filterable);
            }
        }
        if (fieldsAndProperties.size() > 0) {
            return new StatsCommand(source, Arrays.asList(aggregates), byFields != null ? Arrays.asList(byFields) : null, partitions, allnum, delim, false, fieldsAndProperties.array(), false);
        }
        return new StatsCommand(source, Arrays.asList(aggregates), Arrays.asList(byFields), partitions, allnum, delim, false);
    }

    private CommandNode loadTableCommand(JSONObject command) {
        JsonParser.assertEquals("table", command.getString("command"));
        JSONArray fieldList = command.getJSONArray("field_list");
        FieldNode[] fields = new FieldNode[fieldList.length()];
        for (int i = 0; i < fieldList.length(); ++i) {
            fields[i] = new FieldNode(fieldList.getString(i));
        }
        return new TableCommand(this.getRequiredSource(command), fields);
    }

    private CommandNode loadTailCommand(JSONObject json) {
        JsonParser.assertEquals("tail", json.getString("command"));
        CommandNode source = this.getRequiredSource(json);
        int limit = json.getInt("limit");
        return source.tail(limit);
    }

    private CommandNode loadTstatsCommand(JSONObject json) {
        int i;
        JsonParser.assertEquals("tstats", json.getString("command"));
        CommandNode source = this.getOptionalSource(json);
        IGroupBy[] byFields = null;
        ISearchPredicate predicate = null;
        String namespace = null;
        TStatsOptions options = JsonParser.loadTStatsOptions(json);
        if (json.has("predicate")) {
            predicate = this.loadSearchPredicate(json.getJSONObject("predicate"));
        }
        JSONArray array = json.getJSONArray("aggregates");
        AggregateNode[] aggregates = new AggregateNode[array.length()];
        for (i = 0; i < aggregates.length; ++i) {
            aggregates[i] = this.loadAggregateNode(array.getJSONObject(i));
        }
        if (json.has("by")) {
            array = json.getJSONArray("by");
            byFields = new IGroupBy[array.length()];
            for (i = 0; i < array.length(); ++i) {
                byFields[i] = this.loadGroupBy(array.getJSONObject(i));
            }
        }
        if (json.has("from")) {
            JSONObject from = json.getJSONObject("from");
            if (from.has("namespace")) {
                namespace = from.getString("namespace");
            } else if (from.has("object")) {
                namespace = "datamodel=" + from.getJSONObject("object").getString("dataset");
            } else if (from.has("sid")) {
                namespace = "sid=" + from.getString("sid");
            } else {
                throw new RuntimeException("Unexpected namespace type detected.");
            }
        }
        if (source == null) {
            return new TStatsCommand(aggregates, byFields, predicate, namespace, options);
        }
        return new TStatsCommand(source, aggregates, byFields, predicate, namespace, options);
    }

    private CommandNode loadUnionCommand(JSONObject command) {
        JsonParser.assertEquals("union", command.getString("command"));
        CommandNode[] sources = this.getSources(command);
        if (sources.length >= 2) {
            return new UnionCommand(sources);
        }
        return sources[0];
    }

    private CommandNode loadWhereCommand(JSONObject command) {
        JsonParser.assertEquals("where", command.getString("command"));
        IWherePredicate predicate = !command.has("predicate") ? null : this.loadPredicate(command.getJSONObject("predicate"));
        return new WhereCommand(this.getRequiredSource(command), predicate);
    }

    private CommandNode loadDedupCommand(JSONObject command) {
        JsonParser.assertEquals("dedup", command.getString("command"));
        int limit = command.getInt("N");
        boolean keepEvents = command.getBoolean("keepevents");
        boolean keepEmpty = command.getBoolean("keepempty");
        boolean consecutive = command.getBoolean("consecutive");
        JSONArray fieldList = command.getJSONArray("field_list");
        FieldNode[] fields = new FieldNode[fieldList.length()];
        for (int i = 0; i < fieldList.length(); ++i) {
            fields[i] = new FieldNode(fieldList.getString(i));
        }
        IOrdering[] by = null;
        if (command.has("by")) {
            JSONArray byClauses = command.getJSONArray("by");
            by = new IOrdering[byClauses.length()];
            for (int i = 0; i < by.length; ++i) {
                by[i] = JsonParser.loadSortBy(byClauses.getJSONObject(i));
            }
        }
        return new DedupCommand(this.getRequiredSource(command), limit, fields, keepEvents, keepEmpty, consecutive, by, false);
    }

    private CommandNode loadUnknownCommand(JSONObject unknownCommand) {
        CommandInfo info = new CommandInfo(unknownCommand);
        return new UnknownCommand(this.getSources(unknownCommand), info.getCommand(), info.getRaw(), info.getType(), info.getMetadata().toArray(new FieldProperties[0]));
    }

    private ISelection loadSelection(JSONObject json) {
        if (json.has("type") && json.getString("type").equals("field")) {
            return Expression.field(json.getString("value"));
        }
        if (json.has("agg_function")) {
            return this.loadAggregateNode(json);
        }
        throw new UnsupportedOperationException();
    }

    private IGroupBy loadGroupBy(JSONObject json) {
        Objects.requireNonNull(json);
        if (this.enableByFieldsTypeNodeSerializationFormat || json.has("type") && json.has("value") && "function".equals(json.getString("type")) && "bin".equals(json.getString("value"))) {
            switch (json.getString("type")) {
                case "field": {
                    return Expression.field(json.getString("value"));
                }
                case "function": {
                    IGroupBy groupBy;
                    TypeNode node = this.loadFunctionNode(json, false);
                    try {
                        groupBy = (IGroupBy)((Object)node);
                    }
                    catch (ClassCastException ex) {
                        throw new UnsupportedOperationException("Invalid group-by node specified: " + node);
                    }
                    return groupBy;
                }
            }
            throw new UnsupportedOperationException();
        }
        return Expression.field(json.getString("name"));
    }

    private AggregateNode loadAggregateNode(JSONObject json) {
        assert (json.has("agg_function"));
        String aggFunction = json.getString("agg_function");
        TypeNode typeNode = null;
        String as = json.getString("as");
        if (json.has("field")) {
            typeNode = this.loadTypeNode(json.getJSONObject("field"), false);
        }
        if (aggFunction.equals("sparkline")) {
            AggregateFunction sparklineAggFunction = null;
            if (json.has("sparkline_agg_function")) {
                sparklineAggFunction = AggregateFunction.fromString(json.getString("sparkline_agg_function"));
            }
            String timespan = null;
            if (json.has("timespan")) {
                timespan = json.getString("timespan");
            }
            if (timespan != null) {
                return new SparklineAggregateNode(sparklineAggFunction, (FieldNode)typeNode, timespan, as);
            }
            return new SparklineAggregateNode(sparklineAggFunction, (FieldNode)typeNode, as);
        }
        if (aggFunction.equals("eval")) {
            typeNode = this.loadTypeNode(json.getJSONObject("field"), true);
            return new EvalAggregateNode(new FieldNode(as), FunctionNode.create(FunctionNode.FunctionName.eval, typeNode));
        }
        if (typeNode instanceof FieldNode) {
            FieldNode field = (FieldNode)typeNode;
            String regex = "([a-z]+)(\\d+)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(aggFunction);
            if (matcher.find()) {
                String aggFunctionString = matcher.group(1);
                int percentage = Integer.parseInt(matcher.group(2));
                AggregateFunction aggFunc = AggregateFunction.fromString(aggFunctionString);
                if (aggFunc == AggregateFunction.EXACTPERC_X || aggFunc == AggregateFunction.UPPERPERC_X || aggFunc == AggregateFunction.PERC_X) {
                    return new PercentageAggregateNode(AggregateFunction.fromString(aggFunctionString), field, as, percentage);
                }
                return new AggregateNode(AggregateFunction.fromString(aggFunction), field, as);
            }
            return new AggregateNode(AggregateFunction.fromString(aggFunction), field, as);
        }
        if (typeNode instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)typeNode;
            return new AggregateNode(AggregateFunction.fromString(aggFunction), functionNode, as);
        }
        throw new UnsupportedOperationException();
    }

    private static JoinNode loadJoinNode(JSONObject json) {
        return new JoinNode(json.getString("joinField"), json.getString("sourceField"));
    }

    private static JoinNode loadSelectionNodeIntoJoinNode(JSONObject json) {
        return new JoinNode(json.getString("field"), json.getString("newField"));
    }

    private static RenameNode loadRenameNode(JSONObject jsonObject) {
        return new RenameNode(jsonObject.getString("field"), jsonObject.getString("newField"));
    }

    private static TStatsOptions loadTStatsOptions(JSONObject json) {
        Objects.requireNonNull(json);
        boolean isPrestats = json.getBoolean("prestats");
        int chunkSize = json.getInt("chunk_size");
        boolean allowOldSummaries = json.getBoolean("allow_old_summaries");
        boolean local = json.getBoolean("local");
        boolean summariesonly = json.getBoolean("summariesonly");
        return new TStatsOptions(isPrestats, local, summariesonly, allowOldSummaries, chunkSize);
    }

    private static MultiValueNode loadMultiValue(JSONObject json) {
        Objects.requireNonNull(json);
        JsonParser.assertEquals("multivalue", json.getString("type"));
        StringNode[] mv = null;
        if (json.has("value")) {
            JSONArray array = json.getJSONArray("value");
            mv = new StringNode[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                Object obj = array.get(i);
                if (obj instanceof String) {
                    mv[i] = new StringNode((String)obj);
                    continue;
                }
                if (obj instanceof StringNode) {
                    mv[i] = (StringNode)obj;
                    continue;
                }
                throw new JSONException("JSONArray[" + i + "] not a string.");
            }
        }
        return new MultiValueNode(mv);
    }

    private CommandNode[] getSources(JSONObject command) {
        if (!command.has("sources")) {
            return new CommandNode[0];
        }
        JSONArray array = command.getJSONArray("sources");
        CommandNode[] sources = new CommandNode[array.length()];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = this.loadCommandNode(array.getJSONObject(i));
        }
        return sources;
    }

    private CommandNode getRequiredSource(JSONObject command) {
        CommandNode source = this.getOptionalSource(command);
        if (source == null) {
            throw new RuntimeException("Expected a source, none found.");
        }
        return source;
    }

    private CommandNode getOptionalSource(JSONObject command) {
        if (!command.has("sources")) {
            return null;
        }
        JSONArray array = command.getJSONArray("sources");
        if (array.length() == 0) {
            return null;
        }
        if (array.length() == 1) {
            return this.loadCommandNode(array.getJSONObject(0));
        }
        throw new RuntimeException("Expected one source, but encounter 2 or more.");
    }

    private static int extractPercentageFromAggregate(String aggregateFunction) {
        String regex = "[a-z]+(\\d+)";
        int percentage = 0;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(aggregateFunction);
        if (matcher.find()) {
            percentage = Integer.parseInt(matcher.group(1));
        }
        return percentage;
    }
}

