/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.datamodel.DataModelCreator;
import com.splunk.io.FastByteArrayOutputStream;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.FileBasedHeartBeat;
import com.splunk.mr.JobSubmitterInputFormat;
import com.splunk.mr.SearchController;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.StreamStats;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.SplunkRecordReaderWrapper;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SplunkBaseMapper
extends Mapper<Text, Text, Text, Text> {
    private static Logger gLogger = Logger.getLogger(SplunkBaseMapper.class);
    protected Mapper.Context _context = null;
    protected SearchOutputStream _out = null;
    protected StreamStats _stats = new StreamStats();
    protected StreamExceptionHandler _streamExceptionHandler;
    protected DataModelCreator.PipedStreamFlags _flags = new DataModelCreator.PipedStreamFlags();
    protected static final int BUFFER_SIZE = 65536;
    private static final Pattern SPACE_COMMA = Pattern.compile("[, ]+");
    private static final String FIELD_INDEX = "field.index";

    public static Set<String> getNormalizedRRClasses(Configuration conf, VixInputSplit split) {
        List<VirtualIndex> indexes = VirtualIndex.parseIndexes(conf);
        StringBuilder rawClasses = new StringBuilder();
        String index = split == null ? null : split.getIndex();
        String inputId = split == null ? null : split.getInputId();
        for (VirtualIndex vix : indexes) {
            if (index != null && !vix.getName().equals(index)) continue;
            if (split == null) {
                for (String rr : vix.getRecordReaderList()) {
                    rawClasses.append(rr).append(",");
                }
                continue;
            }
            String rr = vix.getRecordReaderList(inputId);
            if (rr == null) continue;
            rawClasses.append(rr).append(",");
        }
        String preProcClasses = conf.get(SplunkMR.CONF_SEARCH_PREPROC);
        if (preProcClasses != null) {
            rawClasses.append(preProcClasses);
        }
        gLogger.debug((Object)String.format("RecordReader list, index=%s, inputId=%s, list=%s", index, inputId, rawClasses));
        String[] classes = SPACE_COMMA.split(rawClasses);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String klass : classes) {
            if ((klass = klass.trim()).isEmpty()) continue;
            result.add(VirtualIndex.normalizeInputClassName(klass));
        }
        return result;
    }

    public static void validateRecordReaderClasses(Configuration conf) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String currentKlass = null;
        try {
            Iterator<String> iterator = SplunkBaseMapper.getNormalizedRRClasses(conf, null).iterator();
            while (iterator.hasNext()) {
                String klass;
                currentKlass = klass = iterator.next();
                RecordReader recordReader = (RecordReader)cl.loadClass(klass).newInstance();
            }
        }
        catch (Exception ex) {
            String msg = String.format("Failed to create a valid RecordReader from class=%s, exception=%s", currentKlass, ex);
            throw new Exception(msg, ex);
        }
    }

    public static BaseSplunkRecordReader initPreprocessor(Configuration conf, InputSplit split, TaskAttemptID taskAttemptId) {
        BaseSplunkRecordReader result = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (String klass : SplunkBaseMapper.getNormalizedRRClasses(conf, (VixInputSplit)split)) {
            try {
                TaskAttemptContext taskContext = SplunkMR.getNewTaskAttemptContext(conf, taskAttemptId);
                RecordReader reader = (RecordReader)cl.loadClass(klass).newInstance();
                result = reader instanceof BaseSplunkRecordReader ? (BaseSplunkRecordReader)reader : new SplunkRecordReaderWrapper(reader);
                result.initialize(split, taskContext);
                break;
            }
            catch (Exception e) {
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("Could not create preprocessor object, will try the next one ... class=" + klass + ", message=" + e.getMessage()), (Throwable)e);
                } else {
                    gLogger.warn((Object)("Could not create preprocessor object, will try the next one ... class=" + klass + ", message=" + e.getMessage()));
                }
                IOUtils.closeQuietly((Closeable)((Object)result));
                result = null;
            }
        }
        return result;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        gLogger.setLevel(Level.INFO);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        long mapStartTime = System.currentTimeMillis();
        Configuration conf = context.getConfiguration();
        FileBasedHeartBeat heartBeat = null;
        if (StrUtil.parseBoolean(conf.get("splunk.heartbeat"), true)) {
            heartBeat = new FileBasedHeartBeat(conf, false);
        }
        this._context = context;
        this.setup(this._context);
        try {
            this.runImpl(this._context);
        }
        finally {
            long mapRuntime;
            this.cleanup(this._context);
            if (heartBeat != null && !heartBeat.alive(mapRuntime = System.currentTimeMillis() - mapStartTime)) {
                JobID jid = JobID.forName((String)context.getJobID().toString());
                JobClient jc = SplunkMR.getJobClient(conf);
                RunningJob rj = jc.getJob(jid);
                rj.killJob();
                gLogger.info((Object)("No heart beat received from Splunk, killing the MR job id=" + jid));
            }
        }
    }

    public void setOutputStream(SearchOutputStream out) {
        this._out = out;
    }

    public void setPipedStreamFlags(DataModelCreator.PipedStreamFlags flags) {
        this._flags = flags;
    }

    public void setStreamExceptionHandler(StreamExceptionHandler handler) {
        this._streamExceptionHandler = handler;
    }

    public static Map<String, Object> getOutputStreamHeader(VixInputSplit inputsplit, Configuration conf) throws IOException {
        HashMap<String, Object> header = new HashMap<String, Object>();
        SplunkMR.appendChunkFields(conf, header);
        Object index = header.get(FIELD_INDEX);
        Path p = inputsplit.getPath();
        FileStatus fstat = null;
        if (p != null) {
            FileSystem fs = p.getFileSystem(conf);
            fstat = fs.getFileStatus(p);
        }
        SplunkMR.addSplitFieldsToHeader(inputsplit, header, fstat, conf);
        if (index != null) {
            header.put(FIELD_INDEX, index);
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(Mapper.Context context) throws IOException, InterruptedException {
        VixInputSplit inputsplit = (VixInputSplit)context.getInputSplit();
        Configuration conf = context.getConfiguration();
        Map<String, Object> header = SplunkBaseMapper.getOutputStreamHeader(inputsplit, conf);
        RecReader in = new RecReader(inputsplit.getRecordReader(), context);
        try {
            StreamStatsWrapper ssw = SplunkBaseMapper.stream(in, this._out, header, this._flags);
            this._stats = ssw.stats;
            if (ssw.hasException()) {
                this.handleException(ssw.exception);
            }
        }
        finally {
            ((BaseSplunkRecordReader)in).close();
        }
        gLogger.info((Object)String.format("Pushed records=%d, bytes=%d to search process ...", this._stats.records, this._stats.bytes));
    }

    private void handleException(IOException e) throws IOException, InterruptedException {
        if (this._streamExceptionHandler == null) {
            throw e;
        }
        this._streamExceptionHandler.handle(e);
    }

    public static StreamStats stream(SearchOutputStream out, VixInputSplit split, Configuration conf, TaskAttemptID taskAttemptId) throws IOException, InterruptedException {
        JobSubmitterInputFormat jsif = new JobSubmitterInputFormat();
        BaseSplunkRecordReader in = jsif.createRecordReader(split, SplunkMR.getNewTaskAttemptContext(conf, taskAttemptId));
        gLogger.info((Object)String.format("using class=%s to process split=%s", ((Object)((Object)in)).getClass().getName(), split.toString()));
        Map<String, Object> header = SplunkBaseMapper.getOutputStreamHeader(split, conf);
        try {
            long start = System.currentTimeMillis();
            StreamStatsWrapper ssw = SplunkBaseMapper.stream(in, out, header, new DataModelCreator.PipedStreamFlags());
            if (ssw.hasException()) {
                throw ssw.exception;
            }
            StreamStats ss = ssw.stats;
            if (SplunkMR.IS_SEARCH_HEAD) {
                out.addMetric("stream.bytes", System.currentTimeMillis() - start, 1L);
                out.addCountMetric("stream.bytes", split.getLength(), ss.bytes);
            }
            StreamStats streamStats = ss;
            return streamStats;
        }
        catch (IOException e) {
            if (SplunkMR.IS_SEARCH_HEAD) {
                out.addMessage("WARN", e);
                try {
                    out.writeHeader();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            throw e;
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)in));
            out.flush();
        }
    }

    private static void flush(ByteArrayOutputStream baos, SearchOutputStream out, StreamStats ss) throws IOException {
        ss.bytes += (long)baos.size();
        out.write(baos);
        baos.reset();
        out.flush();
    }

    public static StreamStatsWrapper stream(BaseSplunkRecordReader in, SearchOutputStream out, Map<String, Object> header, DataModelCreator.PipedStreamFlags flags) throws InterruptedException {
        StreamStats ss = new StreamStats();
        StreamStatsWrapper ssw = new StreamStatsWrapper(ss);
        try {
            SplunkBaseMapper.doStream(in, out, header, ss, flags);
        }
        catch (IOException e) {
            ssw.exception = e;
        }
        catch (RuntimeException re) {
            gLogger.error((Object)"Failed to stream data", (Throwable)re);
            throw re;
        }
        return ssw;
    }

    private static void doStream(BaseSplunkRecordReader in, SearchOutputStream out, Map<String, Object> header, StreamStats ss, DataModelCreator.PipedStreamFlags flags) throws IOException, InterruptedException {
        SearchController sc;
        int bufFlushSize = Math.min(58982, 1024);
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(65536);
        Object streamType = header.get("stream_type");
        if (streamType == null) {
            String format = in.getOutputDataFormat();
            if ("json_events".equals(format)) {
                streamType = "events";
                header = new HashMap<String, Object>(header);
                header.put("json_events", "1");
            } else if ("journal".equals(format)) {
                streamType = "journal";
                gLogger.info((Object)"changing stream_type to journal");
            }
        }
        out.setStreamType(streamType == null ? "raw" : String.valueOf(streamType));
        out.addHeader(header);
        long flushTime = System.currentTimeMillis();
        long forceFlushMs = 2000L;
        SearchController searchController = sc = SplunkMR.IS_SEARCH_HEAD ? SearchController.instance() : null;
        while (in.nextKeyValue() && !flags.stopWriter) {
            if (in.needsNewHeader(header)) {
                SplunkBaseMapper.flush(baos, out, ss);
                out.addHeader(header);
            }
            in.serializeCurrentValueTo(baos);
            if (in.appendNewLine()) {
                baos.write(10);
            }
            if (baos.size() > bufFlushSize || System.currentTimeMillis() - flushTime > forceFlushMs) {
                SplunkBaseMapper.flush(baos, out, ss);
                flushTime = System.currentTimeMillis();
                bufFlushSize = Math.min(58982, bufFlushSize * 2);
            }
            if (sc != null && sc.shouldStop()) {
                throw new RuntimeException(sc.getStopReason());
            }
            ++ss.records;
        }
        ss.bytes += (long)baos.size();
        out.write(baos);
        out.flush();
    }

    static interface StreamExceptionHandler {
        public void handle(IOException var1) throws InterruptedException, IOException;
    }

    public static class StreamStatsWrapper {
        public final StreamStats stats;
        public IOException exception;

        public StreamStatsWrapper(StreamStats ss) {
            this.stats = ss;
            this.exception = null;
        }

        public boolean hasException() {
            return this.exception != null;
        }
    }

    public static class RecReader
    extends BaseSplunkRecordReader {
        BaseSplunkRecordReader _splitReader;
        Mapper.Context _context;

        public RecReader(BaseSplunkRecordReader sr, Mapper.Context context) {
            this._splitReader = sr;
            this._context = context;
        }

        public Text getCurrentKey() throws IOException, InterruptedException {
            return new Text(String.valueOf(this._context.getCurrentKey()));
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return (Text)this._context.getCurrentValue();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this._context.nextKeyValue();
        }

        @Override
        public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this._splitReader.vixInitialize(split, context);
        }

        @Override
        public void close() throws IOException {
            this._splitReader.close();
        }

        @Override
        public String getConfVar(String name, String defaultVal) {
            return this._splitReader.getConfVar(name, defaultVal);
        }

        @Override
        public Pattern getFilePattern() {
            return this._splitReader.getFilePattern();
        }

        @Override
        public String getName() {
            return this._splitReader.getName();
        }

        @Override
        public String getOutputDataFormat() {
            return this._splitReader.getOutputDataFormat();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this._splitReader.getProgress();
        }

        public int hashCode() {
            return ((Object)((Object)this._splitReader)).hashCode();
        }

        @Override
        public boolean needsNewHeader(Map<String, Object> header) {
            return this._splitReader.needsNewHeader(header);
        }

        @Override
        public boolean appendNewLine() {
            return this._splitReader.appendNewLine();
        }

        public String toString() {
            return ((Object)((Object)this._splitReader)).toString();
        }

        @Override
        public void serializeCurrentValueTo(OutputStream out) throws IOException, InterruptedException {
            this._splitReader.serializeCurrentValueTo(out);
        }
    }
}

