/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.filter.schema;

import com.splunk.filter.schema.BaseSchemaFilter;
import com.splunk.util.WildcardList;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;

public class AvroSchemaFilter
extends BaseSchemaFilter<Schema, Schema.Field> {
    @Override
    public Schema filter(Schema schema, WildcardList requiredFields) {
        if (schema.getType() != Schema.Type.RECORD) {
            throw new AvroRuntimeException("Not a RECORD type schema: type " + schema.getType() + ", schema=" + schema);
        }
        return super.filter(schema, requiredFields);
    }

    @Override
    public boolean isLeaf(Schema.Field field) {
        switch (field.schema().getType()) {
            case RECORD: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isRepeatable(Schema.Field field) {
        switch (field.schema().getType()) {
            case ARRAY: 
            case FIXED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Schema createSchema(List<Schema.Field> fields) {
        Schema schema = Schema.createRecord((String)"filtered_schema", null, null, (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    @Override
    public List<Schema.Field> getFields(Schema schema) {
        if (schema.getType() != Schema.Type.RECORD) {
            throw new AvroRuntimeException("Not a RECORD type schema: type=" + schema.getType() + ", schema=" + schema);
        }
        return schema.getFields();
    }

    @Override
    public void processLeafField(List<Schema.Field> result, Schema.Field field, int fieldIndex, String candidate, WildcardList requiredFields) {
        if (requiredFields.matches(candidate) || (field.schema().getType() == Schema.Type.MAP || field.schema().getType() == Schema.Type.ARRAY || field.schema().getType() == Schema.Type.UNION) && requiredFields.isPrefixMatch(candidate)) {
            result.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue()));
        }
    }

    @Override
    public void processNonLeafField(List<Schema.Field> result, Schema.Field field, int fieldIndex, String candidate, WildcardList requiredFields) {
        List finalMatches;
        if (requiredFields.isPrefixMatch(candidate) && !(finalMatches = this.filter(candidate, field.schema(), requiredFields)).isEmpty()) {
            Schema recordSchema = Schema.createRecord((String)field.schema().getName(), (String)field.schema().getDoc(), (String)field.schema().getNamespace(), (boolean)field.schema().isError());
            recordSchema.setFields(finalMatches);
            result.add(new Schema.Field(field.name(), recordSchema, field.doc(), field.defaultValue()));
        }
    }

    @Override
    protected String getFieldName(Schema.Field field) {
        return field.name();
    }
}

