slim-validate - verify an app and its dependencies
==================================================

## SYNOPSIS

`slim` `validate` \[(`-h`|`--help`)] \[(`-r`|`--repository=`)&lt;repository>] \[(`-u`|`--unreferenced-input-groups=)`&lt;level>] &lt;app-source>

## DESCRIPTION

Validates an app manifest and its dependencies. Validating app dependencies requires the manifest to be validated first. The command 
assumes the `app.manifest` file is located at the root of the app source directory.

## OPTIONS

&lt;app-source>
Location of an app source package or directory.

`-h`, `--help`  
Print help message and exit.

`-r` &lt;repository>, `--repository` &lt;repository>  
Look for dependent source packages in the directory at this location. (default: `${SLIM_REPOSITORY:=~/.slim/repository}`)

`-u` &lt;level>, `--unreferenced-input-groups=`&lt;level>  
Report unreferenced input groups at `level`: `note`|`warn`|`error` (default: `note`)

## EXAMPLES

The following example demonstrates using the validate command to validate an app called "fictional."

```
$ slim --debug validate --repository ~/.slim/repository com.splunk.addons-fictional-1.0.0.tar.gz
validate: Validating app at "com.splunk.addons-fictional-1.0.0.tar.gz"...
validate: [ERROR] fictional: unreferenced forwarder groups: dependency com.splunk.addon:microsoft_windows:4.7.5:
    Active Directory Domain Services
    DHCP Server
    Windows Event Log
    Windows Host Monitor
    Windows Network Monitor
    Windows Performance Monitor
    Windows Print Monitor
    Windows Registry
    Windows Update Monitor
```
