/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.search;

import com.splunk.search.ParseNode;
import com.splunk.search.SearchContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParseNodeGroup
extends ParseNode {
    boolean _isConj = false;
    List<ParseNode> _children = null;

    public ParseNodeGroup() {
    }

    public ParseNodeGroup(boolean isConj, List<ParseNode> children) {
        this._isConj = isConj;
        this._children = children;
    }

    public List<ParseNode> getChildren() {
        return this._children;
    }

    public boolean isConjunctive() {
        return this._isConj;
    }

    @Override
    public boolean matches(SearchContext sc, boolean defaultLeafResult) {
        if (this._children == null || this._children.isEmpty()) {
            return this._isConj;
        }
        for (ParseNode pn : this._children) {
            boolean val = pn.matches(sc, defaultLeafResult);
            if (val == this._isConj) continue;
            return !this._isConj;
        }
        return this._isConj;
    }

    @Override
    public void initFrom(Map<String, Object> data) {
        ParseNodeGroup.checkNodeType(data, ParseNode.Type.group);
        String op = String.valueOf(data.get("op"));
        if (op.compareToIgnoreCase("OR") == 0) {
            this._isConj = false;
        } else if (op.compareToIgnoreCase("AND") == 0) {
            this._isConj = true;
        } else {
            throw new IllegalArgumentException("Invalid operator. Use one of the following [AND, OR], got op=" + op + ".");
        }
        List kids = (List)data.get("children");
        if (kids != null) {
            this._children = new ArrayList<ParseNode>(kids.size());
            for (Map kid : kids) {
                ParseNode pn = ParseNode.getByType(ParseNode.Type.valueOf(String.valueOf(kid.get("type")).toLowerCase()));
                pn.initFrom(kid);
                this._children.add(pn);
            }
        }
    }

    @Override
    public ParseNode.Type getType() {
        return ParseNode.Type.group;
    }
}

