/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.nscache;

import com.splunk.nscache.INode;
import com.splunk.nscache.INodeFile;
import com.splunk.nscache.INodeSymlink;
import com.splunk.nscache.UnresolvedPathException;
import com.splunk.util.HdfsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class INodeDirectory
extends INode {
    private static Logger gLogger = Logger.getLogger(INodeDirectory.class);
    private List<INode> children;
    private long itemCount = 1L;

    public INodeDirectory(FileStatus stat) {
        this(null, stat);
    }

    public INodeDirectory(INodeDirectory parent, FileStatus stat) {
        super(parent, stat);
    }

    public INodeDirectory(String parentPath, String name, long mtime, long atime, String group, String owner, long length, short permission) {
        super(parentPath, name, mtime, atime, group, owner, length, permission);
    }

    @Override
    public INode.INodeType getType() {
        return INode.INodeType.DIR;
    }

    private INode addChild(FileStatus stat) throws IOException {
        INode node = stat.isDir() ? new INodeDirectory(this, stat) : (INodeSymlink.isSymlink(stat) ? new INodeSymlink(this, stat) : new INodeFile(this, stat));
        return this.addChild(node);
    }

    public INode addChild(INode node) {
        int low;
        node.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<INode>();
        }
        if ((low = Collections.binarySearch(this.children, node.getName())) >= 0) {
            return null;
        }
        this.children.add(-low - 1, node);
        return node;
    }

    public List<INode> getChildren() {
        return this.children;
    }

    public INode getChild(String childName) {
        if (this.children == null) {
            return null;
        }
        int low = Collections.binarySearch(this.children, childName);
        if (low >= 0) {
            return this.children.get(low);
        }
        return null;
    }

    INode addNode(FileStatus stat) throws IOException {
        INode node;
        INodeDirectory parent = this.getParent(stat.getPath());
        if (parent == null) {
            parent = this;
        }
        if ((node = parent.addChild(stat)) != null) {
            ++this.itemCount;
        }
        return node;
    }

    INodeDirectory getParent(Path nodePath) throws UnresolvedPathException {
        if (!nodePath.isAbsolute()) {
            throw new UnresolvedPathException("Must be an absolute path. nodePath=" + nodePath);
        }
        Path curPath = this.getPath();
        if (!HdfsUtil.containsPath(nodePath, curPath, true)) {
            throw new UnresolvedPathException("Provided nodePath is not in the tree. nodePath=" + nodePath + ", root=" + curPath);
        }
        if (HdfsUtil.equalPath(this.getPath(), nodePath, true)) {
            return null;
        }
        INodeDirectory curNode = this;
        String[] curPathComponents = curPath.toUri().getPath().split("/");
        String[] pathComponents = nodePath.toUri().getPath().split("/");
        for (int i = curPathComponents.length; i < pathComponents.length - 1; ++i) {
            String childName = pathComponents[i];
            INode child = curNode.getChild(childName);
            if (child == null) {
                String msg = "Accestor node is not found. nodePath=" + nodePath + ", accestorPath=" + INodeDirectory.constructPath(0, i + 1, pathComponents);
                throw new UnresolvedPathException(msg);
            }
            if (!child.isDir()) {
                String msg = "Accestor node is not a directory. nodePath=" + nodePath + ", accestorPath=" + INodeDirectory.constructPath(0, i + 1, pathComponents);
                throw new UnresolvedPathException(msg);
            }
            curNode = (INodeDirectory)child;
        }
        return curNode;
    }

    List<INode> addNodes(FileStatus[] stats) throws IOException {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (FileStatus stat : stats) {
            nodes.add(this.addNode(stat));
        }
        return nodes;
    }

    public long totalItems() {
        return this.itemCount;
    }

    public INode getNode(Path nodePath) throws UnresolvedPathException {
        if (!nodePath.isAbsolute()) {
            throw new UnresolvedPathException("Must be an absolute path. nodePath=" + nodePath);
        }
        INodeDirectory parent = this.getParent(nodePath);
        if (parent == null) {
            return this;
        }
        INode node = parent.getChild(nodePath.getName());
        return node;
    }
}

