/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.util.RDPartition;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.DFSExecutionState;
import com.splunk.df.search.DFSSidGenerator;
import com.splunk.df.util.DFSVisitorUtil;
import com.splunk.df.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PartitionExtractionVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(PartitionExtractionVisitor.class);
    private CommandNode splunkSHJob;
    private CommandNode dfsJob;
    private ArrayList<CommandNode> rdinJobs;
    private ArrayList<CommandNode> internalJobs;
    private ArrayList<CommandNode> fshJobs;
    private HashMap<String, List<String>> dataSetToRemoteSid;
    private DFSSidGenerator dfsSidGenerator;
    private boolean inFSHState;
    private boolean inLocalState;
    private DFSExecutionState currentExecutionState;

    public PartitionExtractionVisitor(DFSSidGenerator dfsSidGenerator) {
        this.dfsSidGenerator = dfsSidGenerator;
        this.rdinJobs = new ArrayList();
        this.internalJobs = new ArrayList();
        this.fshJobs = new ArrayList();
        this.dataSetToRemoteSid = new HashMap();
        this.inFSHState = false;
        this.inLocalState = false;
        this.currentExecutionState = DFSExecutionState.UNKNOWN;
    }

    public ArrayList<CommandNode> getSplunkRemoteJobs() {
        return this.internalJobs;
    }

    public ArrayList<CommandNode> getFSHJobs() {
        return this.fshJobs;
    }

    public ArrayList<CommandNode> getRdinJobs() {
        return this.rdinJobs;
    }

    public CommandNode getDFSJob() {
        return this.dfsJob;
    }

    public CommandNode getSplunkSHJob() {
        return this.splunkSHJob;
    }

    public boolean isLocalExecution() {
        return this.inLocalState;
    }

    public HashMap<String, List<String>> getDataSetToRemoteSid() {
        return this.dataSetToRemoteSid;
    }

    public boolean isFSHExecution() {
        return this.inFSHState;
    }

    public DFSExecutionState getCurrentDFSExecutionState() {
        if (this.inLocalState && this.inFSHState) {
            this.currentExecutionState = DFSExecutionState.MIXED_MODE;
        }
        if (!this.inLocalState && this.inFSHState) {
            this.currentExecutionState = DFSExecutionState.FEDERATED_ONLY;
        }
        if (this.inLocalState && !this.inFSHState) {
            this.currentExecutionState = DFSExecutionState.LOCAL_ONLY;
        }
        return this.currentExecutionState;
    }

    public CommandNode visit(CommandNode node) {
        SplFormatter splFormatter = new SplFormatter();
        logger.debug((Object)("Input string to JobPartitionVisitor :" + (String)node.accept((NodeVisitor)splFormatter)));
        CommandNode[] currentNode = node.getSources();
        if (node.getSources().length != 0) {
            for (int i = 0; i < currentNode.length; ++i) {
                this.visit(currentNode[i]);
            }
        }
        CommandNode processedNode = this.processNode(node);
        return processedNode;
    }

    private CommandNode processNode(CommandNode node) {
        if (node.getCommandName().equalsIgnoreCase("jobpartition")) {
            DFSVisitorUtil.JobStatus jobState = DFSVisitorUtil.JobStatus.valueOf(((JobPartitionerCommand)node).getJobPartitionName());
            if (jobState.equals((Object)DFSVisitorUtil.JobStatus.GENERATING_STATE)) {
                HostPort hp = new HostPort("127.0.0.1", 8080);
                HostPort[] hostPorts = new HostPort[]{hp};
                FieldNode[] byFields = ((JobPartitionerCommand)node).getByFields();
                if (byFields == null) {
                    RdOutCommand rdout = new RdOutCommand(node.getSource(), hostPorts, RDPartition.VirtualPartitioning);
                    this.internalJobs.add((CommandNode)rdout);
                } else {
                    RdOutCommand rdout = new RdOutCommand(node.getSource(), hostPorts, byFields, RDPartition.Hash);
                    this.internalJobs.add((CommandNode)rdout);
                }
                this.inLocalState = true;
            } else if (jobState.equals((Object)DFSVisitorUtil.JobStatus.FSH_STATE)) {
                logger.debug((Object)("Caught the FSH State also node ->" + node.getSource().getCommandName()));
                this.inFSHState = true;
            } else if (jobState.equals((Object)DFSVisitorUtil.JobStatus.DFS_STATE)) {
                JobPartitionerCommand myjpc = (JobPartitionerCommand)node;
                this.dfsJob = this.extractJob(node, node.getSource(), DFSVisitorUtil.JobStatus.DFS_STATE).getSource();
                if (this.rdinJobs.isEmpty() && !this.inFSHState) {
                    this.rdinJobs.add(this.dfsJob);
                }
            } else if (jobState.equals((Object)DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE)) {
                this.splunkSHJob = this.extractJob(node, node.getSource(), DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE).getSource();
            }
        }
        logger.debug((Object)"Returning from processNode");
        return node;
    }

    private CommandNode extractJob(CommandNode parent, CommandNode child, DFSVisitorUtil.JobStatus hint) {
        if (child.getCommandName().equalsIgnoreCase("jobpartition")) {
            logger.debug((Object)("Found jobpartition command with type" + ((JobPartitionerCommand)child).getJobPartitionName()));
            String sid = "";
            switch (hint) {
                case SPLUNK_SH_STATE: {
                    sid = this.dfsSidGenerator.getBaseSid();
                    break;
                }
                case DFS_STATE: {
                    sid = this.dfsSidGenerator.getNextSid();
                    if (!this.inFSHState) break;
                    sid = "fsh_" + sid;
                    this.dfsSidGenerator.AddUpdateFSHSid(sid);
                    break;
                }
                case GENERATING_STATE: 
                case FSH_STATE: 
                case UNDEFINED_STATE: {
                    sid = "shouldneverhappen";
                    assert (false);
                    break;
                }
            }
            assert (!sid.equalsIgnoreCase(""));
            RdInCommand rd = new RdInCommand(sid, true);
            if (hint == DFSVisitorUtil.JobStatus.DFS_STATE && this.inFSHState) {
                this.fshJobs.add(child.getSource());
                FromCommand tempFrom = (FromCommand)child.getSource();
                String dataSet = tempFrom.getDataset().getKind() + ":" + tempFrom.getDataset().getName();
                if (this.dataSetToRemoteSid.containsKey(dataSet)) {
                    List<String> sidList = this.dataSetToRemoteSid.get(dataSet);
                    sidList.add(sid);
                } else {
                    ArrayList<String> sidList = new ArrayList<String>();
                    sidList.add(sid);
                    this.dataSetToRemoteSid.put(dataSet, sidList);
                }
            }
            return parent.setSource(DFSVisitorUtil.rebuild((CommandNode)rd));
        }
        CommandNode passThroughNode = child;
        CommandNode[] currentNode = child.getSources();
        int numSources = child.getSources().length;
        if (numSources >= 2) {
            CommandNode updatedChild = this.dispatchMultiSourcedCommand(child);
            return parent.setSource(DFSVisitorUtil.rebuild(updatedChild));
        }
        passThroughNode = this.extractJob(child, currentNode[0], hint);
        return parent.setSource(DFSVisitorUtil.rebuild(passThroughNode));
    }

    private CommandNode dispatchMultiSourcedCommand(CommandNode child) {
        CommandNode updatedNode = null;
        switch (child.getCommandName()) {
            case "join": {
                updatedNode = this.extractJoin((JoinCommand)child);
                break;
            }
            case "union": {
                updatedNode = this.extractUnion((UnionCommand)child);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command" + child.getCommandName());
            }
        }
        return updatedNode;
    }

    private CommandNode extractJoin(JoinCommand child) {
        CommandNode lhs = child.getSources()[0];
        CommandNode rhs = child.getSources()[1];
        JobPartitionerCommand jpc_lhs = new JobPartitionerCommand(lhs, "DFS_STATE");
        JobPartitionerCommand jpc_rhs = new JobPartitionerCommand(rhs, "DFS_STATE");
        PartitionExtractionVisitor leftVisitor = new PartitionExtractionVisitor(this.dfsSidGenerator);
        jpc_lhs.accept((NodeVisitor)leftVisitor);
        PartitionExtractionVisitor rightVisitor = new PartitionExtractionVisitor(this.dfsSidGenerator);
        jpc_rhs.accept((NodeVisitor)rightVisitor);
        if (leftVisitor.isFSHExecution()) {
            this.inFSHState = true;
            this.fshJobs.addAll(leftVisitor.getFSHJobs());
            Utils.mergeMultiMap(this.dataSetToRemoteSid, leftVisitor.getDataSetToRemoteSid());
        }
        if (leftVisitor.isLocalExecution()) {
            this.inLocalState = true;
            this.rdinJobs.addAll(leftVisitor.getRdinJobs());
        }
        if (rightVisitor.isFSHExecution()) {
            this.inFSHState = true;
            this.fshJobs.addAll(rightVisitor.getFSHJobs());
            Utils.mergeMultiMap(this.dataSetToRemoteSid, rightVisitor.getDataSetToRemoteSid());
        }
        if (rightVisitor.isLocalExecution()) {
            this.inLocalState = true;
            this.rdinJobs.addAll(rightVisitor.getRdinJobs());
        }
        return child.setSources(new CommandNode[]{leftVisitor.getDFSJob(), rightVisitor.getDFSJob()});
    }

    private CommandNode extractUnion(UnionCommand child) {
        logger.debug((Object)"Inside the extractUnion for Partitioning");
        CommandNode[] children = new CommandNode[child.getSources().length];
        JobPartitionerCommand[] jpcs = new JobPartitionerCommand[children.length];
        PartitionExtractionVisitor[] partitionVisitors = new PartitionExtractionVisitor[children.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = child.getSources()[i];
            jpcs[i] = new JobPartitionerCommand(children[i], "DFS_STATE");
            logger.debug((Object)("Union subtree " + i + " ==>" + (String)jpcs[i].accept((NodeVisitor)new SplFormatter())));
            partitionVisitors[i] = new PartitionExtractionVisitor(this.dfsSidGenerator);
            jpcs[i].accept((NodeVisitor)partitionVisitors[i]);
        }
        CommandNode[] updatedChildren = new CommandNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            updatedChildren[i] = partitionVisitors[i].getDFSJob();
            this.rdinJobs.addAll(partitionVisitors[i].getRdinJobs());
            if (partitionVisitors[i].isLocalExecution()) {
                this.inLocalState = true;
            }
            if (!partitionVisitors[i].isFSHExecution()) continue;
            this.inFSHState = true;
            this.fshJobs.addAll(partitionVisitors[i].getFSHJobs());
            Utils.mergeMultiMap(this.dataSetToRemoteSid, partitionVisitors[i].getDataSetToRemoteSid());
            ArrayList<CommandNode> arrayList = partitionVisitors[i].getFSHJobs();
        }
        return child.setSources(updatedChildren);
    }
}

