/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class SSLUtil {
    static final String[] DESIRED_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private static Logger gLogger = Logger.getLogger(SSLUtil.class);
    private static boolean TRUST_ALL_DONE = false;

    public static synchronized void trustEveryone() {
        if (TRUST_ALL_DONE) {
            return;
        }
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x, String s) throws CertificateException {
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(new SSLv3SocketFactory(context.getSocketFactory()));
            TRUST_ALL_DONE = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class SSLv3SocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;

        private SSLv3SocketFactory(SSLSocketFactory delegate) {
            this.delegate = delegate;
        }

        private Socket configure(Socket socket) {
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                String[] enabled = sslSocket.getEnabledProtocols();
                String[] supported = sslSocket.getSupportedProtocols();
                ArrayList<String> newEnabled = new ArrayList<String>();
                for (String protocol : DESIRED_PROTOCOLS) {
                    if (!this.arrayContains(supported, protocol) || this.arrayContains(enabled, protocol)) continue;
                    newEnabled.add(protocol);
                }
                if (!newEnabled.isEmpty()) {
                    int i;
                    for (String protocol : enabled) {
                        newEnabled.add(protocol);
                    }
                    String[] newEnabledArr = newEnabled.toArray(new String[newEnabled.size()]);
                    StringBuilder logMsg = new StringBuilder();
                    logMsg.append("Changing enabled SSL protocols from ['");
                    for (i = 0; i < enabled.length; ++i) {
                        if (i > 0) {
                            logMsg.append("', '");
                        }
                        logMsg.append(enabled[i]);
                    }
                    logMsg.append("'] to ['");
                    for (i = 0; i < newEnabledArr.length; ++i) {
                        if (i > 0) {
                            logMsg.append("', '");
                        }
                        logMsg.append(newEnabledArr[i]);
                    }
                    logMsg.append("']");
                    gLogger.debug((Object)logMsg);
                    sslSocket.setEnabledProtocols(newEnabledArr);
                } else {
                    StringBuilder logMsg = new StringBuilder();
                    logMsg.append("Keeping without change enabled SSL protocols: ['");
                    for (int i = 0; i < enabled.length; ++i) {
                        if (i > 0) {
                            logMsg.append("', '");
                        }
                        logMsg.append(enabled[i]);
                    }
                    logMsg.append("']");
                    gLogger.debug((Object)logMsg);
                }
            }
            return socket;
        }

        private boolean arrayContains(String[] array, String val) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null || !array[i].equals(val)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.configure(this.delegate.createSocket(socket, s, i, b));
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.configure(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.configure(this.delegate.createSocket(s, i));
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.configure(this.delegate.createSocket(s, i, inetAddress, i1));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.configure(this.delegate.createSocket(inetAddress, i));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.configure(this.delegate.createSocket(inetAddress, i, inetAddress1, i1));
        }
    }
}

