/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;

public class CountAndSumAggregateValue
implements AggregateValue {
    private Long count = 0L;
    private Double sum = 0.0;

    @Override
    public AggregateValue accumulate(Object item) {
        assert (item instanceof Pair);
        Pair ctSumPair = (Pair)item;
        this.count = this.count + (Long)ctSumPair.first();
        this.sum = this.sum + (Double)ctSumPair.second();
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof CountAndSumAggregateValue);
        Pair ctSumPair = (Pair)aggregateValue.getValue();
        this.count = this.count + (Long)ctSumPair.first();
        this.sum = this.sum + (Double)ctSumPair.second();
        return this;
    }

    @Override
    public Object getValue() {
        return new Pair<Long, Double>(this.count, this.sum);
    }
}

