/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import org.apache.log4j.Logger;

public class TailTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(TailTransformer.class);
    private ComputeEngineContext ctx;

    public ComputeEngineContext getContext() {
        return this.ctx;
    }

    @Override
    public String name() {
        return "TailTransformer";
    }

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode source = cmd.getSource();
        if (source == null) {
            logger.debug((Object)"source for tail command not present!");
            throw new RuntimeException("source not found for tail command");
        }
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, source);
        if (executeExternal) {
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, cmd, ctx);
            outputdd = outputdd.cacheDisk();
            logger.debug((Object)"Will execute base transformer to input create dataset");
        } else {
            String cmdName = source.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(source);
            if (t == null) {
                logger.debug((Object)("transformer not found for command: " + cmdName));
                throw new RuntimeException("transformer not found for command: " + cmdName);
            }
            logger.debug((Object)String.format("using source transformer - %s", cmdName));
            outputdd = t.transform(outputdd, source, streaming, ctx);
        }
        TailCommand tailCommand = (TailCommand)cmd;
        long limit = tailCommand.getLimit();
        outputdd = outputdd.last(limit);
        logger.debug((Object)String.format("Limit set on dataset: %d", limit));
        return outputdd;
    }
}

