/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.Utils;
import org.apache.log4j.Logger;

public class RenameTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(RenameTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        return RenameTransformer._transform(ctx, dd, cmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, CommandNode cmd, boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = cmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, srcCmd);
        if (executeExternal) {
            logger.debug((Object)"Will execute base transformer to input create dataset");
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, cmd, ctx);
        } else {
            String cmdName = srcCmd.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
            logger.debug((Object)("Will apply rename processing on output of transformer " + cmdName));
        }
        RenameCommand rcmd = (RenameCommand)cmd;
        final RenameNode[] renames = rcmd.getRenames();
        if (renames == null || renames.length == 0) {
            return outputdd;
        }
        outputdd = outputdd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                int len = renames.length;
                for (int i = 0; i < len; ++i) {
                    SearchResult.FieldMeta[] originalFields;
                    if (renames[i] == null) {
                        logger.warn((Object)"Nothing to rename, skipping.");
                        continue;
                    }
                    TermMatcher fromName = new TermMatcher(renames[i].getField().getFieldName());
                    for (SearchResult.FieldMeta field : originalFields = sr.getFieldNames()) {
                        String[] toParts;
                        boolean matchFound;
                        if (field == null || field.fieldName() == null || !sr.containsField(field) || !(matchFound = field.fieldName().startsWith("__mv_") ? fromName.match(field.fieldName().substring("__mv_".length())) : fromName.match(field.fieldName()))) continue;
                        TermMatcher toName = new TermMatcher(renames[i].getNewField().getFieldName());
                        String[] fromParts = fromName.parts();
                        if (fromParts.length != (toParts = toName.parts()).length) {
                            throw new IllegalArgumentException("Wildcard mismatch '" + renames[i].getField() + "' as '" + renames[i].getNewField() + "'.");
                        }
                        String toField = Utils.replaceEach(field.fieldName(), fromParts, toParts);
                        if (fromParts.length > 0 && toParts.length > 0) {
                            if (fromParts[0].isEmpty() && !toParts[0].isEmpty()) {
                                toField = toParts[0] + toField;
                            }
                            if (fromParts[fromParts.length - 1].isEmpty() && !toParts[fromParts.length - 1].isEmpty()) {
                                toField = toField + toParts[fromParts.length - 1];
                            }
                        }
                        sr.renameField(field, SearchResult.FieldMeta.newFieldMeta(toField));
                    }
                }
                return sr;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }
        });
        return outputdd;
    }

    @Override
    public String name() {
        return "RenameTransformer";
    }
}

