/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.objects.SearchObject;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.sdk.Tuple3;
import com.splunk.df.search.compute.transformers.Aggregator;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.CountAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.CountAndSumAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.CountSumAndSumSqAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.EdcErrorAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.EdcErrorInfo;
import com.splunk.df.search.compute.transformers.aggregatevalues.EstimateQuantileValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.HyperLogLogAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.ListAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.OrderAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.RangeAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.SetAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.SparklineAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.ThresholdAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.TimeAndValAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.ValuesAndCountsAggregateValue;
import com.splunk.df.util.TimeInterval;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class AggregatorFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(AggregatorFactory.class);
    private static AggregatorFactory singleton = new AggregatorFactory();
    private AggregateFunction[] CONTEXT_SPECIFIC_AGGREGATORS = new AggregateFunction[]{AggregateFunction.SPARKLINE, AggregateFunction.EXACTPERC_X, AggregateFunction.PERC_X, AggregateFunction.UPPERPERC_X};
    private HashMap<AggregateFunction, Aggregator> aggrTable = new HashMap();

    private AggregatorFactory() {
        this.aggrTable.put(AggregateFunction.AVG, new CountAndSumAggregator(AggregateFunction.AVG));
        this.aggrTable.put(AggregateFunction.C, new CountAggregator(AggregateFunction.C));
        this.aggrTable.put(AggregateFunction.COUNT, new CountAggregator(AggregateFunction.COUNT));
        this.aggrTable.put(AggregateFunction.DC, new DistinctValuesAggregator(AggregateFunction.DC));
        this.aggrTable.put(AggregateFunction.DISTINCT_COUNT, new DistinctValuesAggregator(AggregateFunction.DISTINCT_COUNT));
        this.aggrTable.put(AggregateFunction.EARLIEST, new EarliestAggregator(AggregateFunction.EARLIEST));
        this.aggrTable.put(AggregateFunction.ESTDC, new EstimatedDistinctCountAggregator(AggregateFunction.ESTDC));
        this.aggrTable.put(AggregateFunction.ESTDC_ERROR, new EstimatedDistinctCountErrorAggregator(AggregateFunction.ESTDC_ERROR));
        this.aggrTable.put(AggregateFunction.FIRST, new OrderedValuesAggregator(AggregateFunction.FIRST));
        this.aggrTable.put(AggregateFunction.LAST, new OrderedValuesAggregator(AggregateFunction.LAST));
        this.aggrTable.put(AggregateFunction.LATEST, new LatestAggregator(AggregateFunction.LATEST));
        this.aggrTable.put(AggregateFunction.LIST, new ValuesListAggregator(AggregateFunction.LIST));
        this.aggrTable.put(AggregateFunction.MAX, new MaxAggregator(AggregateFunction.MAX));
        this.aggrTable.put(AggregateFunction.MEAN, new CountAndSumAggregator(AggregateFunction.MEAN));
        this.aggrTable.put(AggregateFunction.MEDIAN, new EstimatedQuantileAggregator(AggregateFunction.MEDIAN));
        this.aggrTable.put(AggregateFunction.MIN, new MinAggregator(AggregateFunction.MIN));
        this.aggrTable.put(AggregateFunction.MODE, new ValuesAndCountsAggregator(AggregateFunction.MODE));
        this.aggrTable.put(AggregateFunction.RANGE, new RangeAggregator(AggregateFunction.RANGE));
        this.aggrTable.put(AggregateFunction.SUM, new CountAndSumAggregator(AggregateFunction.SUM));
        this.aggrTable.put(AggregateFunction.STDEV, new CountSumAndSumSqAggregator(AggregateFunction.STDEV));
        this.aggrTable.put(AggregateFunction.STDEVP, new CountSumAndSumSqAggregator(AggregateFunction.STDEVP));
        this.aggrTable.put(AggregateFunction.SUMSQ, new CountAndSumAggregator(AggregateFunction.SUMSQ));
        this.aggrTable.put(AggregateFunction.VALUES, new DistinctValuesAggregator(AggregateFunction.VALUES));
        this.aggrTable.put(AggregateFunction.VAR, new CountSumAndSumSqAggregator(AggregateFunction.VAR));
        this.aggrTable.put(AggregateFunction.VARP, new CountSumAndSumSqAggregator(AggregateFunction.VARP));
    }

    public static AggregatorFactory getInstance() {
        return singleton;
    }

    private static String cleanse(String s) {
        return s.trim().replaceAll("^\"|\"$", "").trim();
    }

    public Aggregator getAggregator(AggregateFunction func) {
        Aggregator aggregator = this.aggrTable.get(func);
        if (aggregator == null && ArrayUtils.contains((Object[])this.CONTEXT_SPECIFIC_AGGREGATORS, (Object)func)) {
            switch (func) {
                case SPARKLINE: {
                    aggregator = new SparklineValuesAggregator(func);
                    break;
                }
                case PERC_X: 
                case UPPERPERC_X: {
                    aggregator = new EstimatedQuantileAggregator(func);
                    break;
                }
                case EXACTPERC_X: {
                    aggregator = new ValuesAndCountsAggregator(func);
                }
            }
        }
        if (aggregator == null) {
            logger.error((Object)("aggregation function: " + func + " not supported"));
            throw new RuntimeException("aggregation function: " + func + " not supported");
        }
        return aggregator;
    }

    public static class RangeAggregator
    extends BaseAggregator {
        RangeAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            Pair minMaxPair = (Pair)aggregateValue.getValue();
            if (null == minMaxPair.first() || null == minMaxPair.second()) {
                return null;
            }
            return (Double)minMaxPair.second() - (Double)minMaxPair.first();
        }

        @Override
        public AggregateValue getSeed() {
            return new RangeAggregateValue();
        }
    }

    public static class MinAggregator
    extends ThresholdValueAggregator {
        MinAggregator(AggregateFunction func) {
            super(func, ThresholdValueAggregator.THRESHOLD_FUNCTION.MIN);
        }

        @Override
        public AggregateValue getSeed() {
            return ThresholdAggregateValue.getInstance(ThresholdAggregateValue.THRESHOLD_FUNCTION.MIN);
        }
    }

    public static class MaxAggregator
    extends ThresholdValueAggregator {
        MaxAggregator(AggregateFunction func) {
            super(func, ThresholdValueAggregator.THRESHOLD_FUNCTION.MAX);
        }

        @Override
        public AggregateValue getSeed() {
            return ThresholdAggregateValue.getInstance(ThresholdAggregateValue.THRESHOLD_FUNCTION.MAX);
        }
    }

    public static abstract class ThresholdValueAggregator
    extends BaseAggregator {
        private THRESHOLD_FUNCTION compareFunction;

        ThresholdValueAggregator(AggregateFunction func, THRESHOLD_FUNCTION compareFunction) {
            super(func);
            this.compareFunction = compareFunction;
        }

        public static enum THRESHOLD_FUNCTION {
            MIN,
            MAX;

        }
    }

    public static class OrderedValuesAggregator
    extends BaseAggregator {
        OrderAggregateValue.COMPARE_FUNCTION compareFunction;

        OrderedValuesAggregator(AggregateFunction func) {
            super(func);
            if (func == AggregateFunction.FIRST) {
                this.compareFunction = OrderAggregateValue.COMPARE_FUNCTION.FIRST;
            } else if (func == AggregateFunction.LAST) {
                this.compareFunction = OrderAggregateValue.COMPARE_FUNCTION.LAST;
            } else {
                throw new IllegalArgumentException(String.format("Unsupported Aggregate Function specified %s", func.toString()));
            }
        }

        @Override
        public AggregateValue getSeed() {
            return OrderAggregateValue.getInstance(this.compareFunction);
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof OrderAggregateValue);
            return aggregateValue.getValue();
        }
    }

    public static abstract class TimeValueAggregator
    extends BaseAggregator {
        private COMPARE_FUNCTION compareFunction;

        TimeValueAggregator(AggregateFunction func, COMPARE_FUNCTION compareFunction) {
            super(func);
            this.compareFunction = compareFunction;
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof TimeAndValAggregateValue);
            Pair timeValPair = (Pair)aggregateValue.getValue();
            return timeValPair.second();
        }

        public static enum COMPARE_FUNCTION {
            EARLIEST,
            LATEST;

        }
    }

    public static class LatestAggregator
    extends TimeValueAggregator {
        LatestAggregator(AggregateFunction func) {
            super(func, TimeValueAggregator.COMPARE_FUNCTION.LATEST);
        }

        @Override
        public AggregateValue getSeed() {
            return TimeAndValAggregateValue.getInstance(TimeAndValAggregateValue.COMPARE_FUNCTION.LATEST);
        }
    }

    public static class EarliestAggregator
    extends TimeValueAggregator {
        EarliestAggregator(AggregateFunction func) {
            super(func, TimeValueAggregator.COMPARE_FUNCTION.EARLIEST);
        }

        @Override
        public AggregateValue getSeed() {
            return TimeAndValAggregateValue.getInstance(TimeAndValAggregateValue.COMPARE_FUNCTION.EARLIEST);
        }
    }

    public static class ValuesAndCountsAggregator
    extends BaseAggregator {
        ValuesAndCountsAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new ValuesAndCountsAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            Double result;
            assert (aggregateValue instanceof ValuesAndCountsAggregateValue);
            Map valsCountsMap = (Map)aggregateValue.getValue();
            if (this.function().equals((Object)AggregateFunction.MODE)) {
                Double currMaxItem = null;
                Long currMaxCount = 0L;
                for (Map.Entry pair : valsCountsMap.entrySet()) {
                    if ((Long)pair.getValue() <= currMaxCount) continue;
                    currMaxItem = pair.getKey();
                    currMaxCount = (Long)pair.getValue();
                }
                result = currMaxItem;
            } else if (this.function().equals((Object)AggregateFunction.EXACTPERC_X)) {
                Long percentage = (long)((Long)((SearchObject)this.aggrContext.get(PERC_VALUE)).getValue());
                result = this.calculatePercentileValue(valsCountsMap, percentage);
            } else {
                throw new RuntimeException("Invalid Aggregate Function specified for ValuesAndCountsAggregator");
            }
            return result;
        }

        private Double calculatePercentileValue(Map<Object, Long> counts, Long percentile) {
            TreeSet<Object> sortedSet = new TreeSet<Object>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    double result = Double.parseDouble(o1.toString()) - Double.parseDouble(o2.toString());
                    if (result == 0.0) {
                        if (o1.equals(o2)) {
                            return 0;
                        }
                        return o1.toString().compareTo(o2.toString());
                    }
                    if (result > 0.0) {
                        return 1;
                    }
                    return -1;
                }
            });
            Iterator<Object> it = counts.keySet().iterator();
            while (it.hasNext()) {
                Object val = null;
                try {
                    val = it.next();
                    Double.parseDouble(val.toString());
                }
                catch (Exception e) {
                    it.remove();
                    counts.remove(val);
                }
            }
            sortedSet.addAll(counts.keySet());
            long total = 0L;
            for (long count : counts.values()) {
                total += count;
            }
            long targetPercentileCount = total * percentile / 100L;
            Iterator sortedKeysIt = sortedSet.iterator();
            long sum = 0L;
            Object value = null;
            Double result = null;
            while (sortedKeysIt.hasNext()) {
                value = sortedKeysIt.next();
                if (total % 2L == 0L && (sum += counts.get(value).longValue()) == targetPercentileCount && sortedKeysIt.hasNext()) {
                    return (Double.parseDouble(value.toString()) + Double.parseDouble(sortedKeysIt.next().toString())) / 2.0;
                }
                if (sum <= targetPercentileCount) continue;
                result = Double.parseDouble(value.toString());
                break;
            }
            return result;
        }
    }

    public static class EstimatedQuantileAggregator
    extends BaseAggregator {
        protected EstimatedQuantileAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new EstimateQuantileValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof EstimateQuantileValue);
            EstimateQuantileValue quantileValue = (EstimateQuantileValue)aggregateValue;
            if (this.function().equals((Object)AggregateFunction.PERC_X) || this.function().equals((Object)AggregateFunction.UPPERPERC_X)) {
                Long percentage = (long)((Long)((SearchObject)this.aggrContext.get(PERC_VALUE)).getValue());
                if (percentage == null) {
                    throw new RuntimeException("Invalid AggregateNode specified for EstimatedQuantileAggregator");
                }
                double percentAsFraction = (double)percentage.longValue() / 100.0;
                return quantileValue.getQuantile(percentAsFraction);
            }
            if (this.function().equals((Object)AggregateFunction.MEDIAN)) {
                Double quantile = quantileValue.getQuantile(0.5);
                return quantile.isNaN() ? null : quantile;
            }
            throw new RuntimeException("Invalid Aggregate Function specified for EstimatedQuantileAggregator");
        }
    }

    public static class EstimatedDistinctCountErrorAggregator
    extends BaseAggregator {
        EstimatedDistinctCountErrorAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new EdcErrorAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof EdcErrorAggregateValue);
            EdcErrorInfo info = (EdcErrorInfo)((EdcErrorAggregateValue)aggregateValue).getValue();
            int dc = info.objectSet.size();
            Long edc = 0L;
            try {
                edc = HyperLogLog.Builder.build((byte[])info.hllBytes).cardinality();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (dc == 0 || (long)dc == edc) {
                return 0.0;
            }
            return Math.abs((double)dc - (double)edc.longValue()) / (double)dc;
        }
    }

    public static class EstimatedDistinctCountAggregator
    extends BaseAggregator {
        EstimatedDistinctCountAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new HyperLogLogAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof HyperLogLogAggregateValue);
            try {
                return HyperLogLog.Builder.build((byte[])((byte[])aggregateValue.getValue())).cardinality();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ValuesListAggregator
    extends BaseAggregator {
        ValuesListAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            int limit = this.aggrContext.get(ComputeEngineConstants.LIST_MAX_SIZE) != null ? Integer.parseInt(((SearchObject)this.aggrContext.get(ComputeEngineConstants.LIST_MAX_SIZE)).getValue().toString()) : 100;
            return new ListAggregateValue(limit);
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof ListAggregateValue);
            List valsList = (List)aggregateValue.getValue();
            return valsList.toArray(new String[0]);
        }
    }

    public static class DistinctValuesAggregator
    extends BaseAggregator {
        DistinctValuesAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new SetAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof SetAggregateValue);
            Set distinctValues = (Set)aggregateValue.getValue();
            if (this.function() == AggregateFunction.DC || this.function() == AggregateFunction.DISTINCT_COUNT) {
                return distinctValues.size();
            }
            Object[] strArr = new String[distinctValues.size()];
            String[] strObjArr = distinctValues.toArray(strArr);
            Arrays.sort(strArr);
            return strArr;
        }
    }

    public static class SparklineValuesAggregator
    extends BaseAggregator {
        SparklineValuesAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new SparklineAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            int numIntervals;
            TimeInterval advancingStep;
            long nextTime;
            long currTime;
            long latestTimeSeen;
            Iterator it;
            AggregateFunction aggregateFunction;
            SparklineAggregateValue sparklineAggregateValue;
            block26: {
                TimeInterval timeInterval;
                assert (aggregateValue instanceof SparklineAggregateValue);
                sparklineAggregateValue = (SparklineAggregateValue)aggregateValue;
                TreeMap sparklineMap = (TreeMap)aggregateValue.getValue();
                aggregateFunction = AggregateFunction.fromString((String)((String)((SearchObject)this.aggrContext.get(AGGREGATOR_FUNCTION)).getValue()));
                String timeIntervalStr = (String)((SearchObject)this.aggrContext.get(SPARKLINE_INTERVAL)).getValue();
                try {
                    timeInterval = TimeInterval.parse(timeIntervalStr);
                }
                catch (Exception e) {
                    timeInterval = new TimeInterval(1, TimeInterval.TIMEUNIT.SECOND);
                }
                it = sparklineMap.entrySet().iterator();
                long earliestTimeSeen = Long.MAX_VALUE;
                latestTimeSeen = Long.MIN_VALUE;
                currTime = Long.MIN_VALUE;
                nextTime = Long.MAX_VALUE;
                long timeIntervalSecs = timeInterval.getSeconds();
                advancingStep = timeInterval;
                numIntervals = 100;
                try {
                    earliestTimeSeen = (Long)((SearchObject)this.aggrContext.get(EARLIEST_TIME_SEEN)).getValue();
                    latestTimeSeen = (Long)((SearchObject)this.aggrContext.get(LATEST_TIME_SEEN)).getValue();
                    if (timeIntervalSecs == 1L) {
                        long timeRange = latestTimeSeen - earliestTimeSeen;
                        advancingStep = this.determineAdvancingStep(timeRange, numIntervals);
                    }
                    currTime = this.snapToTimeWindow(earliestTimeSeen * 1000L, advancingStep) / 1000L;
                    nextTime = this.advanceTimeSlot(currTime * 1000L, latestTimeSeen * 1000L, advancingStep) / 1000L;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block26;
                    logger.error((Object)e);
                }
            }
            String[] slValues = new String[numIntervals + 2];
            for (int i = 1; i < numIntervals + 2; ++i) {
                slValues[i] = "0";
            }
            slValues[0] = "##__SPARKLINE__##";
            int currentInterval = 1;
            Object currVal = null;
            Map.Entry entry = null;
            while (entry != null || currentInterval < slValues.length && it.hasNext()) {
                if (entry == null) {
                    entry = it.next();
                }
                if ((Long)entry.getKey() >= currTime && (Long)entry.getKey() < nextTime) {
                    Map<String, String> tsValues = sparklineAggregateValue.convertValueStringToMap((String)entry.getValue());
                    BigDecimal result = BigDecimal.ZERO;
                    switch (aggregateFunction) {
                        case COUNT: {
                            currVal = SparklineValuesAggregator.accumulateValueFromTsMap(tsValues, currVal, "c");
                            break;
                        }
                        case AVG: {
                            if (currVal == null) {
                                currVal = new Pair<BigDecimal, BigDecimal>(new BigDecimal(tsValues.get("s")), new BigDecimal(tsValues.get("nc")));
                                break;
                            }
                            Pair tmpPair = (Pair)currVal;
                            currVal = new Pair<BigDecimal, BigDecimal>(((BigDecimal)tmpPair.first()).add(new BigDecimal(tsValues.get("s"))), ((BigDecimal)tmpPair.second()).add(new BigDecimal(tsValues.get("nc"))));
                            break;
                        }
                        case MAX: {
                            if (currVal == null) {
                                currVal = new BigDecimal(tsValues.get("max"));
                                break;
                            }
                            Serializable tmpVal = (BigDecimal)currVal;
                            if (((BigDecimal)tmpVal).compareTo(new BigDecimal(tsValues.get("max"))) >= 0) break;
                            currVal = new BigDecimal(tsValues.get("max"));
                            break;
                        }
                        case MIN: {
                            if (currVal == null) {
                                currVal = new BigDecimal(tsValues.get("min"));
                                break;
                            }
                            Serializable tmpVal = (BigDecimal)currVal;
                            if (((BigDecimal)tmpVal).compareTo(new BigDecimal(tsValues.get("min"))) <= 0) break;
                            currVal = new BigDecimal(tsValues.get("min"));
                            break;
                        }
                        case SUM: {
                            currVal = SparklineValuesAggregator.accumulateValueFromTsMap(tsValues, currVal, "s");
                            break;
                        }
                        case SUMSQ: {
                            currVal = SparklineValuesAggregator.accumulateValueFromTsMap(tsValues, currVal, "ss");
                            break;
                        }
                        case RANGE: {
                            if (currVal == null) {
                                currVal = new Pair<BigDecimal, BigDecimal>(new BigDecimal(tsValues.get("min")), new BigDecimal(tsValues.get("max")));
                                break;
                            }
                            Serializable tmpVal = (Pair)currVal;
                            BigDecimal minVal = ((BigDecimal)((Pair)tmpVal).first()).compareTo(new BigDecimal(tsValues.get("min"))) > 0 ? new BigDecimal(tsValues.get("min")) : (BigDecimal)((Pair)tmpVal).first();
                            BigDecimal maxVal = ((BigDecimal)((Pair)tmpVal).second()).compareTo(new BigDecimal(tsValues.get("min"))) < 0 ? new BigDecimal(tsValues.get("max")) : (BigDecimal)((Pair)tmpVal).second();
                            currVal = new Pair<BigDecimal, BigDecimal>(minVal, maxVal);
                            break;
                        }
                        case VAR: 
                        case STDEV: 
                        case VARP: 
                        case STDEVP: {
                            if (currVal == null) {
                                currVal = new Tuple3<BigDecimal, BigDecimal, BigDecimal>(new BigDecimal(tsValues.get("nc")), new BigDecimal(tsValues.get("s")), new BigDecimal(tsValues.get("ss")));
                                break;
                            }
                            Serializable tmpVal = (Tuple3)currVal;
                            BigDecimal count = ((BigDecimal)((Tuple3)tmpVal).first()).add(new BigDecimal(tsValues.get("nc")));
                            BigDecimal sum = ((BigDecimal)((Tuple3)tmpVal).second()).add(new BigDecimal(tsValues.get("s")));
                            BigDecimal sumSq = ((BigDecimal)((Tuple3)tmpVal).third()).add(new BigDecimal(tsValues.get("ss")));
                            currVal = new Tuple3<BigDecimal, BigDecimal, BigDecimal>(count, sum, sumSq);
                            break;
                        }
                        case DC: 
                        case ESTDC: {
                            currVal = currVal == null ? tsValues.get("v") : String.format("%s,%s", currVal.toString(), tsValues.get("v"));
                        }
                    }
                    entry = null;
                    continue;
                }
                currTime = nextTime;
                nextTime = this.advanceTimeSlot(currTime * 1000L, latestTimeSeen * 1000L, advancingStep) / 1000L;
                slValues[currentInterval] = SparklineValuesAggregator.calculateSlValue(currVal, aggregateFunction);
                currVal = null;
                ++currentInterval;
            }
            slValues[currentInterval] = SparklineValuesAggregator.calculateSlValue(currVal, aggregateFunction);
            return Arrays.copyOfRange(slValues, 0, currentInterval + 1);
        }

        private Long snapToTimeWindow(long timestamp, TimeInterval advancingStep) {
            Date date = new Date(timestamp);
            Long result = 0L;
            switch (advancingStep.getTimeUnit()) {
                case SECOND: {
                    result = timestamp;
                    break;
                }
                case MINUTE: {
                    if (advancingStep.getQuantity() == 5) {
                        result = TimeInterval.snapToFiveMinutes(timestamp);
                        break;
                    }
                    result = TimeInterval.snapToMinute(timestamp);
                    break;
                }
                case HOUR: {
                    result = TimeInterval.snapToHour(timestamp);
                    break;
                }
                case DAY: {
                    result = TimeInterval.snapToDay(timestamp);
                    break;
                }
                case MONTH: {
                    result = TimeInterval.snapToMonth(timestamp);
                    break;
                }
                case YEAR: {
                    result = TimeInterval.snapToYear(timestamp);
                }
            }
            return result;
        }

        private TimeInterval determineAdvancingStep(long timeRange, int numIntervals) {
            TimeInterval advancingStep = timeRange > TimeInterval.ONE_YEAR ? new TimeInterval(1, TimeInterval.TIMEUNIT.MONTH) : (timeRange > (long)numIntervals * TimeInterval.ONE_DAY ? new TimeInterval(1, TimeInterval.TIMEUNIT.MONTH) : (timeRange > (long)numIntervals * TimeInterval.ONE_HOUR ? new TimeInterval(1, TimeInterval.TIMEUNIT.DAY) : (timeRange > TimeInterval.ONE_DAY ? new TimeInterval(1, TimeInterval.TIMEUNIT.HOUR) : (timeRange > 12L * TimeInterval.ONE_HOUR ? new TimeInterval(1, TimeInterval.TIMEUNIT.HOUR) : (timeRange > TimeInterval.ONE_HOUR ? new TimeInterval(5, TimeInterval.TIMEUNIT.MINUTE) : (timeRange > 2L * TimeInterval.ONE_MINUTE ? new TimeInterval(1, TimeInterval.TIMEUNIT.MINUTE) : new TimeInterval(1, TimeInterval.TIMEUNIT.SECOND)))))));
            return advancingStep;
        }

        private static Object accumulateValueFromTsMap(Map<String, String> tsValues, Object currVal, String fieldName) {
            currVal = currVal != null ? ((BigDecimal)currVal).add(new BigDecimal(tsValues.get(fieldName))) : new BigDecimal(tsValues.get(fieldName));
            return currVal;
        }

        private long advanceTimeSlot(long currTime, long latestTime, TimeInterval timeInterval) {
            long result;
            Date date = new Date(currTime);
            switch (timeInterval.getTimeUnit()) {
                case SECOND: {
                    result = DateUtils.addSeconds((Date)date, (int)timeInterval.getQuantity()).getTime();
                    break;
                }
                case MINUTE: {
                    result = DateUtils.addMinutes((Date)date, (int)timeInterval.getQuantity()).getTime();
                    break;
                }
                case HOUR: {
                    result = DateUtils.addHours((Date)date, (int)timeInterval.getQuantity()).getTime();
                    break;
                }
                case DAY: {
                    result = DateUtils.addDays((Date)date, (int)timeInterval.getQuantity()).getTime();
                    break;
                }
                case MONTH: {
                    result = DateUtils.addMonths((Date)date, (int)timeInterval.getQuantity()).getTime();
                    break;
                }
                case YEAR: {
                    result = DateUtils.addYears((Date)date, (int)timeInterval.getQuantity()).getTime();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported TimeInterval Unit::" + (Object)((Object)timeInterval.getTimeUnit()));
                }
            }
            if (result > latestTime) {
                result = latestTime + 1000L;
            }
            return result;
        }

        private static String calculateSlValue(Object slObject, AggregateFunction aggregateFunction) {
            String result = "0";
            if (slObject != null) {
                switch (aggregateFunction) {
                    case COUNT: 
                    case MAX: 
                    case MIN: 
                    case SUM: 
                    case SUMSQ: 
                    case C: {
                        result = ((BigDecimal)slObject).toString();
                        break;
                    }
                    case AVG: 
                    case MEAN: {
                        Pair tmpVal = (Pair)slObject;
                        result = ((BigDecimal)tmpVal.first()).divide((BigDecimal)tmpVal.second(), 5, RoundingMode.CEILING).toString();
                        break;
                    }
                    case RANGE: {
                        Pair tmpVal1 = (Pair)slObject;
                        result = ((BigDecimal)tmpVal1.second()).subtract((BigDecimal)tmpVal1.first()).toString();
                        break;
                    }
                    case VAR: 
                    case STDEV: 
                    case VARP: 
                    case STDEVP: {
                        BigDecimal variance;
                        Tuple3 tmpVal2 = (Tuple3)slObject;
                        BigDecimal count = (BigDecimal)tmpVal2.first();
                        BigDecimal sum = (BigDecimal)tmpVal2.second();
                        BigDecimal sumsSquared = (BigDecimal)tmpVal2.third();
                        BigDecimal divisor = count;
                        if ((aggregateFunction == AggregateFunction.STDEV || aggregateFunction == AggregateFunction.VAR) && count.compareTo(BigDecimal.ONE) > 0) {
                            divisor = count.subtract(BigDecimal.ONE);
                        }
                        BigDecimal bigDecimal = variance = (variance = sumsSquared.subtract(sum.multiply(sum.divide(count, 5, 2))).divide(divisor, 5, 2)).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : variance;
                        if (aggregateFunction == AggregateFunction.STDEV || aggregateFunction == AggregateFunction.STDEVP) {
                            result = new Double(Math.sqrt(variance.doubleValue())).toString();
                            break;
                        }
                        result = variance.toString();
                        break;
                    }
                    case DC: 
                    case ESTDC: 
                    case DISTINCT_COUNT: {
                        String[] vals = slObject.toString().split(",");
                        HashSet<String> distinctVals = new HashSet<String>();
                        for (String v : vals) {
                            distinctVals.add(v);
                        }
                        result = Integer.valueOf(distinctVals.size()).toString();
                    }
                }
            }
            return result;
        }
    }

    public static class CountSumAndSumSqAggregator
    extends BaseAggregator {
        CountSumAndSumSqAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new CountSumAndSumSqAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            Double variance;
            assert (aggregateValue instanceof CountSumAndSumSqAggregateValue);
            Pair countSumAndSumSq = (Pair)aggregateValue.getValue();
            Long count = (Long)countSumAndSumSq.first();
            if (count <= 1L) {
                return 0;
            }
            Pair sumAndSumSq = (Pair)countSumAndSumSq.second();
            Long divisor = count;
            if (this.function() == AggregateFunction.STDEV || this.function() == AggregateFunction.VAR) {
                divisor = count - 1L;
            }
            variance = (variance = Double.valueOf(((Double)sumAndSumSq.second() - (Double)sumAndSumSq.first() * ((Double)sumAndSumSq.first() / (double)count.longValue())) / (double)divisor.longValue())) < 0.0 ? 0.0 : variance;
            if (this.function() == AggregateFunction.STDEV || this.function() == AggregateFunction.STDEVP) {
                return Math.sqrt(variance);
            }
            return variance;
        }
    }

    public static class CountAndSumAggregator
    extends BaseAggregator {
        CountAndSumAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new CountAndSumAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            assert (aggregateValue instanceof CountAndSumAggregateValue);
            Pair countSum = (Pair)aggregateValue.getValue();
            if (this.function() == AggregateFunction.SUM || this.function() == AggregateFunction.SUMSQ) {
                return countSum.second();
            }
            if (this.function() == AggregateFunction.AVG || this.function() == AggregateFunction.MEAN) {
                long count = (Long)countSum.first();
                double sum = (Double)countSum.second();
                Double result = sum / (double)count;
                if (Double.isNaN(result)) {
                    throw new RuntimeException();
                }
                return result;
            }
            throw new RuntimeException("Invalid Aggregate Function ::" + this.function() + " specified for the Aggregator");
        }
    }

    public static class CountAggregator
    extends BaseAggregator {
        CountAggregator(AggregateFunction func) {
            super(func);
        }

        @Override
        public AggregateValue getSeed() {
            return new CountAggregateValue();
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            return aggregateValue.getValue();
        }
    }

    public static abstract class BaseAggregator
    implements Aggregator,
    Serializable {
        protected Map<SearchResult.FieldMeta, SearchObject> aggrContext = new HashMap<SearchResult.FieldMeta, SearchObject>();
        private AggregateFunction func;

        protected BaseAggregator(AggregateFunction func) {
            this.func = func;
        }

        protected AggregateFunction function() {
            return this.func;
        }

        @Override
        public void addToComputeContext(SearchResult.FieldMeta key, SearchObject value) {
            this.aggrContext.put(key, value);
        }

        @Override
        public AggregateValue aggregate(AggregateValue value, Object item) {
            return value.accumulate(item);
        }

        @Override
        public AggregateValue aggregate(AggregateValue lhs, AggregateValue rhs) {
            return lhs.accumulate(rhs);
        }

        @Override
        public Object finalize(AggregateValue aggregateValue) {
            return aggregateValue.getValue();
        }
    }
}

