/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultImpl;
import com.splunk.df.util.Utils;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.log4j.Logger;

public class SearchResultFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SearchResultFactory.class);
    private static SearchResultFactory singleton = new SearchResultFactory();

    public static SearchResultFactory getInstance() {
        return singleton;
    }

    public static SearchResult.SRHashMap<String, Object> convert(Map<SearchResult.FieldMeta, Object> data) {
        Iterator<Map.Entry<SearchResult.FieldMeta, Object>> entries = data.entrySet().iterator();
        SearchResult.SRHashMap<String, Object> ret = new SearchResult.SRHashMap<String, Object>(data.size());
        while (entries.hasNext()) {
            Map.Entry<SearchResult.FieldMeta, Object> entry = entries.next();
            ret.put(entry.getKey().fieldName(), entry.getValue());
        }
        return ret;
    }

    public static SearchResult.SRHashMap<SearchResult.FieldMeta, Object> convert(Map<String, Object> data, SearchResult.FieldMeta[] fields) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> ret = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(data.size());
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            SearchResult.FieldMeta field = fields[i];
            Object val = data.get(fields[i].fieldName());
            ret.put(field, val);
        }
        return ret;
    }

    private SearchResultFactory() {
    }

    public SearchResult createSearchResult(SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data, SearchResult.FieldMeta[] fields, Object[] values) {
        return new SearchResultImpl(data, fields, values);
    }

    public SearchResult createSearchResult(SearchResult.FieldMeta[] fields, Object[] values) {
        return new SearchResultImpl(fields, values);
    }

    public SearchResult createSearchResult(SearchResult.FieldMeta[] fieldNames, CSVRecord csvData) {
        return new SearchResultImpl(fieldNames, csvData);
    }

    public SearchResult cloneSearchResult(SearchResult src) {
        return new SearchResultImpl(src);
    }

    public SearchResult createSearchResult(SearchResult.FieldMeta key, Object value) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(2);
        data.put(key, value);
        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[1];
        Object[] fieldValues = new Object[1];
        fieldNames[0] = key;
        fieldValues[0] = value;
        return new SearchResultImpl(data, fieldNames, fieldValues);
    }

    public SearchResult emptyResult() {
        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[]{};
        Object[] fieldValues = new Object[]{};
        return new SearchResultImpl(fieldNames, fieldValues);
    }

    public SearchResult merge(SearchResult lhs, SearchResult rhs) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = lhs.getDataMap();
        data.putAll(rhs.getDataMap());
        int size = lhs.getSize() + rhs.getSize();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
        Object[] vals = new Object[size];
        SearchResult.FieldMeta[] lhsFields = lhs.getFieldNames();
        Object[] lhsVals = lhs.getFieldValues();
        System.arraycopy(lhsFields, 0, fields, 0, lhsFields.length);
        System.arraycopy(lhsVals, 0, vals, 0, lhsVals.length);
        SearchResult.FieldMeta[] rhsFields = rhs.getFieldNames();
        Object[] rhsVals = rhs.getFieldValues();
        System.arraycopy(rhsFields, 0, fields, lhsFields.length, rhsFields.length);
        System.arraycopy(rhsVals, 0, vals, lhsVals.length, rhsVals.length);
        return new SearchResultImpl(data, fields, vals);
    }

    public int compareTo(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return 0;
        }
        if (lhs == rhs) {
            return 0;
        }
        if (!lhs.getClass().equals(rhs.getClass())) {
            if (lhs instanceof Number && rhs instanceof Number) {
                Double lhsDbl = ((Number)lhs).doubleValue();
                Double rhsDbl = ((Number)rhs).doubleValue();
                return lhsDbl.compareTo(rhsDbl);
            }
            return lhs.toString().compareTo(rhs.toString());
        }
        if (lhs instanceof Long) {
            return ((Long)lhs).compareTo((Long)rhs);
        }
        if (lhs instanceof Integer) {
            return ((Integer)lhs).compareTo((Integer)rhs);
        }
        if (lhs instanceof Boolean) {
            return ((Boolean)lhs).compareTo((Boolean)rhs);
        }
        if (lhs instanceof String) {
            return ((String)lhs).compareTo((String)rhs);
        }
        if (lhs instanceof Float) {
            return ((Float)lhs).compareTo((Float)rhs);
        }
        if (lhs instanceof Double) {
            return ((Double)lhs).compareTo((Double)rhs);
        }
        if (lhs instanceof NullField) {
            return ((NullField)lhs).compareTo((NullField)rhs);
        }
        if (lhs instanceof TimeField) {
            return ((TimeField)lhs).compareTo((TimeField)rhs);
        }
        if (lhs instanceof StringField) {
            return ((StringField)lhs).compareTo((StringField)rhs);
        }
        if (lhs instanceof IPAddress) {
            return ((IPAddress)lhs).compareTo((IPAddress)rhs);
        }
        if (lhs instanceof NullField) {
            return ((NullField)lhs).compareTo((NullField)rhs);
        }
        logger.error((Object)("unsupported number type: " + lhs.getClass().getName()));
        throw new RuntimeException("unsupported object: " + lhs.getClass() + ", value: " + lhs);
    }

    private static Number convertToNumber(Object val) {
        if (val instanceof Number) {
            return (Number)val;
        }
        try {
            return Utils.convertToDouble(val.toString());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Object convertToIP(Object val) {
        if (val instanceof IPAddress) {
            return (IPAddress)val;
        }
        String strVal = val.toString();
        try {
            if (InetAddressUtils.isIPv4Address((String)strVal) || InetAddressUtils.isIPv6Address((String)strVal)) {
                IPAddress addr = new IPAddress(InetAddress.getByName(strVal));
                return addr;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return val;
    }

    private static Object autoConvert(Object val) {
        if (val instanceof String || val instanceof StringField) {
            String valStr = val.toString();
            if (InetAddressUtils.isIPv4Address((String)valStr) || InetAddressUtils.isIPv6Address((String)valStr)) {
                try {
                    IPAddress addr = new IPAddress(InetAddress.getByName(valStr));
                    return addr;
                }
                catch (Throwable addr) {
                    return val;
                }
            }
            Number num = SearchResultFactory.convertToNumber(valStr);
            if (num != null) {
                return num;
            }
        }
        return val;
    }

    public Object convertValue(Object val, FieldType fieldType) {
        if (val == null) {
            return null;
        }
        if (fieldType.equals((Object)FieldType.STR)) {
            return val.toString();
        }
        if (fieldType.equals((Object)FieldType.NUM)) {
            Number res = SearchResultFactory.convertToNumber(val);
            return res == null ? val : res;
        }
        if (fieldType.equals((Object)FieldType.IP)) {
            return SearchResultFactory.convertToIP(val);
        }
        return SearchResultFactory.autoConvert(val);
    }

    public static SearchResult.FieldType getType(SearchResult.FieldMeta fieldName) {
        if (fieldName.equals(SPLUNK_TIME_FIELD) || fieldName.equals(SPLUNK_INDEX_TIME_FIELD)) {
            return SearchResult.FieldType.TIME_FIELD;
        }
        return SearchResult.FieldType.STR_FIELD;
    }

    public static StringField createStringField(String str) {
        return new StringField(str);
    }

    public static class IPAddress
    implements Comparable<IPAddress>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int[] bytes;
        private int hashCode;

        IPAddress(InetAddress addr) {
            byte[] bytes = addr.getAddress();
            int len = bytes.length;
            this.bytes = new int[len];
            this.hashCode = 1;
            for (int i = 0; i < len; ++i) {
                this.bytes[i] = 0xFF & bytes[i];
                this.hashCode = this.hashCode * 32 + this.bytes[i];
            }
        }

        @Override
        public int compareTo(IPAddress rhs) {
            int len = this.bytes.length;
            for (int i = 0; i < len; ++i) {
                int lhsByte = this.bytes[i];
                int rhsByte = rhs.bytes[i];
                if (lhsByte > rhsByte) {
                    return 1;
                }
                if (lhsByte >= rhsByte) continue;
                return -1;
            }
            return 0;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof IPAddress)) {
                return false;
            }
            IPAddress rhsAddr = (IPAddress)rhs;
            int len = this.bytes.length;
            for (int i = 0; i < len; ++i) {
                int lhsByte = this.bytes[i];
                int rhsByte = rhsAddr.bytes[i];
                if (lhsByte == rhsByte) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            int len = this.bytes.length;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                int b = this.bytes[i];
                sb.append(b);
                if (i >= len - 1) continue;
                sb.append(".");
            }
            return sb.toString();
        }
    }

    public static class TimeField
    implements Comparable<TimeField>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Double time;
        private String timeStr;
        private final int hashCode;
        private static final String[] datePatterns = new String[]{"yyyy.MM.dd G 'at' HH:mm:ss z", "EEE, MMM d, ''yy", "h:mm a", "hh 'o''clock' a, zzzz", "K:mm a, z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "EEE, d MMM yyyy HH:mm:ss Z", "yyMMddHHmmssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "YYYY-'W'ww-u", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm zzzz", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSzzzz", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd", "yyyyMMdd", "dd/MM/yy", "dd/MM/yyyy", "dd/MM/yyyy:HH:mm:ss", "dd/MM/yyyy HH:mm:ss"};

        public TimeField(String timeStr) {
            this.timeStr = timeStr;
            if (timeStr != null) {
                timeStr = timeStr.trim();
            }
            if (timeStr == null || timeStr.isEmpty()) {
                this.time = -1.0;
                this.hashCode = this.time.hashCode();
                return;
            }
            try {
                this.time = Double.valueOf(timeStr);
            }
            catch (NumberFormatException nex) {
                for (String format : datePatterns) {
                    try {
                        Date date = DateUtils.parseDate((String)timeStr, (String[])datePatterns);
                        this.time = date.getTime();
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
            if (this.time == null) {
                throw new IllegalArgumentException("Unable to parse " + timeStr);
            }
            this.hashCode = this.time.hashCode();
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof TimeField)) {
                return false;
            }
            TimeField rhsTime = (TimeField)rhs;
            return this.time.equals(rhsTime.time);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public Double getTime() {
            return this.time;
        }

        @Override
        public int compareTo(TimeField rhs) {
            return this.time.compareTo(rhs.time);
        }

        public String toString() {
            return this.timeStr;
        }
    }

    public static class NullField
    implements Comparable<NullField>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean unequal;

        public NullField(boolean unequal) {
            this.unequal = unequal;
        }

        @Override
        public int compareTo(NullField o) {
            return 0;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            return !this.unequal;
        }

        public String toString() {
            return "__null__";
        }

        public int hashCode() {
            if (this.unequal) {
                return super.hashCode();
            }
            return this.toString().hashCode();
        }
    }

    public static class StringField
    implements Comparable<StringField>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String str;

        StringField(String str) {
            this.str = str;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof StringField)) {
                return false;
            }
            StringField rhsStr = (StringField)rhs;
            return this.str.equals(rhsStr.str);
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        @Override
        public int compareTo(StringField rhs) {
            String rhsStr = rhs.str;
            return this.str.compareTo(rhsStr);
        }

        public String toString() {
            return this.str;
        }
    }
}

