/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import org.apache.log4j.Logger;

public class ComputeEngineFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(ComputeEngineFactory.class);
    private static ComputeEngineFactory singleton = new ComputeEngineFactory();

    public static ComputeEngineFactory getInstance() {
        return singleton;
    }

    public ComputeEngine newInstance(ComputeEngineConstants.EngineType type, ComputeEngineContext ctx) {
        ComputeEngine engine = null;
        if (type == ComputeEngineConstants.EngineType.SPARK) {
            try {
                engine = (ComputeEngine)Class.forName("com.splunk.df.search.compute.spark.SparkComputeEngine").newInstance();
                engine.setContext(ctx);
            }
            catch (Throwable t) {
                logger.error((Object)"Could not construct compute engine of type: com.splunk.df.search.compute.spark.SparkComputeEngine", t);
                throw new RuntimeException("Error constructing distributed compute engine");
            }
        } else {
            logger.error((Object)"Compute engine type not supported");
            throw new RuntimeException("Compute engine type not supported");
        }
        return engine;
    }
}

