/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.ast.JsonParser;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.FSHSplunkConnectionHandler;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.DFSException;
import com.splunk.df.visitors.ColumnOrderVisitor;
import com.splunk.df.visitors.CursoredSearchVisitor;
import com.splunk.df.visitors.GeneratingSearchVisitor;
import com.splunk.df.visitors.RemoteSearchSupportVisitor;
import com.splunk.df.visitors.RequiredFieldsOrderVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FSHMetaPhaseExecutor
implements Serializable,
DFSSearchConstants {
    static final Logger logger = Logger.getLogger(FSHMetaPhaseExecutor.class);

    public DistributedDataset executeDistributedMetaPhase(DistributedDataset root, final HashMap<Integer, FederatedDataSetInfo> datasetInfoMap, HashMap<String, FederatedDeploymentInfo> deploymentInfoMap) throws Exception {
        List<SearchResult> metaPlaceHolders = this.getMetaPlaceHolders(deploymentInfoMap);
        DistributedDataset metaPhaseExecutorDD = root.resetSearchResults(metaPlaceHolders, metaPlaceHolders.size());
        metaPhaseExecutorDD = metaPhaseExecutorDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                SplunkSearchEndpoint sse = new SplunkSearchEndpoint(dInfo.getIP(), dInfo.getPort(), dInfo.getServiceAccount(), dInfo.getPassword());
                String connectionId = FSHSplunkConnectionHandler.getNewConnection(sse);
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT, ComputeEngineConstants.SPLUNK_SEARCH_HEAD, ComputeEngineConstants.FSH_CONNECTION_ID};
                Object[] vals = new Object[]{dInfo, sse, connectionId};
                SearchResult updatedSR = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return updatedSR;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }
        });
        metaPhaseExecutorDD = metaPhaseExecutorDD.cacheMem();
        DistributedDataset metaPhaseVersionASTExecutorDD = metaPhaseExecutorDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                String connectionId = (String)sr.getFieldValue(ComputeEngineConstants.FSH_CONNECTION_ID);
                ArrayList<FederatedDataSetInfo> updatedDatasetInfo = new ArrayList<FederatedDataSetInfo>();
                try {
                    SplunkReleaseVersion currentSplunkVersion = new SplunkReleaseVersion(FSHSplunkConnectionHandler.getVersion(connectionId));
                    logger.info((Object)String.format("Deployment %s has Splunk Version: %s", dInfo.getDeploymentName(), currentSplunkVersion.toString()));
                    if (currentSplunkVersion.compareTo(SplunkReleaseVersion.IVORY) < 0) {
                        throw new IllegalArgumentException(String.format("DFS FSH does not support Splunk version=%s for the remote deployment", currentSplunkVersion.toString()));
                    }
                    dInfo.setDeploymentVersion(currentSplunkVersion);
                    for (FederatedDataSetInfo dataSetInfo : datasetInfoMap.values()) {
                        if (!dataSetInfo.getDeploymentName().equalsIgnoreCase(dInfo.getDeploymentName())) continue;
                        String searchAstString = FSHSplunkConnectionHandler.getAST(connectionId, dataSetInfo.getSearch());
                        logger.info((Object)("The expanded search ==>" + searchAstString));
                        dataSetInfo.setSearchExpanedToAST(searchAstString);
                        updatedDatasetInfo.add(dataSetInfo);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH metaphase execution (AST expansion stage), details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT, ComputeEngineConstants.FSH_DATASET_LIST, ComputeEngineConstants.FSH_CONNECTION_ID};
                Object[] vals = new Object[]{dInfo, updatedDatasetInfo, connectionId};
                SearchResult updatedSR = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return updatedSR;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }
        });
        Iterator<SearchResult> versionASTResultsItr = metaPhaseVersionASTExecutorDD.retrieve();
        ArrayList<Thread> metaPhaseExecutorThreadList = new ArrayList<Thread>();
        final HashMap deploymentTodataSet = new HashMap();
        while (versionASTResultsItr.hasNext()) {
            SearchResult sr = versionASTResultsItr.next();
            final FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
            deploymentInfoMap.get(dInfo.getDeploymentName()).setDeploymentVersion(dInfo.getDeploymentVersion());
            final ArrayList dataSetInfoArrayList = (ArrayList)sr.getDataMap().get(ComputeEngineConstants.FSH_DATASET_LIST);
            final String[] error = new String[]{""};
            Thread metaPhaseParallelizer = new Thread(new DFCRunnable(){

                @Override
                protected void runInternal() throws Exception {
                    for (int i = 0; i < dataSetInfoArrayList.size(); ++i) {
                        CommandNode fshCommandNode;
                        JSONObject jsonObject = new JSONObject(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearchExpandToAST());
                        logger.info((Object)String.format("The expanded search in AST is %s.", jsonObject.toString()));
                        JsonParser jsonParser = new JsonParser(true, false);
                        try {
                            fshCommandNode = (CommandNode)jsonParser.parse(jsonObject);
                        }
                        catch (Exception e) {
                            error[0] = String.format("FSH remote dataset='%s' with search=%s is not supported in federated execution of DFS.", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearch());
                            return;
                        }
                        RemoteSearchSupportVisitor remoteSearchSupportVisitor = new RemoteSearchSupportVisitor();
                        fshCommandNode.accept((NodeVisitor)remoteSearchSupportVisitor);
                        if (!remoteSearchSupportVisitor.isFSHSupported()) {
                            error[0] = String.format("FSH remote dataset='%s' with search=%s is not supported in federated execution of DFS.", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearch());
                            return;
                        }
                        SplFormatter splFormatter = new SplFormatter();
                        ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setExpandedSearch((String)fshCommandNode.accept((NodeVisitor)splFormatter));
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setExpandedSearch((String)fshCommandNode.accept((NodeVisitor)splFormatter));
                        CursoredSearchVisitor cursoredSearchVisitor = new CursoredSearchVisitor();
                        fshCommandNode.accept((NodeVisitor)cursoredSearchVisitor);
                        if (cursoredSearchVisitor.isCursored()) {
                            error[0] = String.format("FSH remote search='%s' is not a transforming search. DFS only supports transforming searches currently for remote deployments.", fshCommandNode.accept((NodeVisitor)splFormatter));
                            return;
                        }
                        GeneratingSearchVisitor detectIndexForEstimation = new GeneratingSearchVisitor();
                        fshCommandNode.accept((NodeVisitor)detectIndexForEstimation);
                        StringBuilder estimatedSearch = new StringBuilder();
                        int numberOfPredicates = detectIndexForEstimation.getPredicates().size();
                        if (numberOfPredicates == 0) {
                            error[0] = String.format("FSH dataset =%s failed to generate the estimation query", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName());
                            return;
                        }
                        SplunkReleaseVersion deploymentVersion = dInfo.getDeploymentVersion();
                        if (deploymentVersion.compareTo(SplunkReleaseVersion.IVORY) >= 0 && deploymentVersion.compareTo(SplunkReleaseVersion.KIMONO) < 0) {
                            if (numberOfPredicates > 1) {
                                error[0] = String.format("FSH dataset =%s is not supported for Splunk version=%s.", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), dInfo.getDeploymentVersion().toString());
                                return;
                            }
                            estimatedSearch.append(String.format("| tstats count where %s", detectIndexForEstimation.getPredicates().get(0)));
                        } else {
                            estimatedSearch.append("| union ");
                            for (int j = 0; j < detectIndexForEstimation.getPredicates().size(); ++j) {
                                estimatedSearch.append(String.format("[| tstats count where %s]", detectIndexForEstimation.getPredicates().get(j)));
                            }
                        }
                        ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setSearchForEstimation(estimatedSearch.toString());
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setSearchForEstimation(estimatedSearch.toString());
                        logger.info((Object)String.format("For Dataset %s the estimation search %s", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearchForEstimation()));
                        RequiredFieldsOrderVisitor requiredFieldsOrderVisitor = new RequiredFieldsOrderVisitor();
                        fshCommandNode.accept((NodeVisitor)requiredFieldsOrderVisitor);
                        ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setNumFields(requiredFieldsOrderVisitor.getNumberOfRequiredFields());
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setNumFields(requiredFieldsOrderVisitor.getNumberOfRequiredFields());
                        ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor();
                        fshCommandNode.accept((NodeVisitor)columnOrderVisitor);
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setColumnOrder(columnOrderVisitor.getColumnOrder());
                    }
                    deploymentTodataSet.put(dInfo.getDeploymentName(), dataSetInfoArrayList);
                }
            });
            metaPhaseExecutorThreadList.add(metaPhaseParallelizer);
            metaPhaseParallelizer.start();
            for (Thread metaPhaseThread : metaPhaseExecutorThreadList) {
                metaPhaseThread.join();
            }
            if (error[0].isEmpty()) continue;
            throw new DFSException(error[0]);
        }
        DistributedDataset metaPhaseEstimationExecutor = metaPhaseExecutorDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                String connectionId = (String)sr.getFieldValue(ComputeEngineConstants.FSH_CONNECTION_ID);
                ArrayList updatedDaatasetInfo = new ArrayList();
                try {
                    for (Map.Entry entry : deploymentTodataSet.entrySet()) {
                        if (!((String)entry.getKey()).equalsIgnoreCase(dInfo.getDeploymentName())) continue;
                        for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                            long estimatedCount = FSHSplunkConnectionHandler.getEstimatedEventCount(connectionId, ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getSearchForEstimation());
                            ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).setEstimatedEventCount(estimatedCount);
                            logger.info((Object)String.format("For Dataset %s the estimation Count is %d", ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getDatasetName(), ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getEstimatedEventCount()));
                            updatedDaatasetInfo.add(((ArrayList)entry.getValue()).get(i));
                        }
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH metaphase execution (event count estimation stage), details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT, ComputeEngineConstants.FSH_DATASET_LIST};
                Object[] vals = new Object[]{dInfo, updatedDaatasetInfo};
                SearchResult updatedSR = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return updatedSR;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }
        });
        Iterator<SearchResult> srItr = metaPhaseEstimationExecutor.retrieve();
        long eventCount = 0L;
        while (srItr.hasNext()) {
            SearchResult sr = srItr.next();
            if (sr.isEmpty()) continue;
            FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getDataMap().get(ComputeEngineConstants.FSH_DEPLOYMENT);
            ArrayList dataSetInfos = (ArrayList)sr.getDataMap().get(ComputeEngineConstants.FSH_DATASET_LIST);
            for (int i = 0; i < dataSetInfos.size(); ++i) {
                eventCount += ((FederatedDataSetInfo)dataSetInfos.get(i)).getEstimatedEventCount().longValue();
                datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfos.get(i)).getId()).setEstimatedEventCount(((FederatedDataSetInfo)dataSetInfos.get(i)).getEstimatedEventCount());
            }
        }
        if (eventCount == 0L) {
            for (Map.Entry<Integer, FederatedDataSetInfo> entry : datasetInfoMap.entrySet()) {
                entry.getValue().setEstimatedEventCount(1000L);
                entry.getValue().setNumFields(1);
            }
        }
        return metaPhaseExecutorDD;
    }

    private List<SearchResult> getMetaPlaceHolders(HashMap<String, FederatedDeploymentInfo> deploymentInfoMap) {
        ArrayList<SearchResult> metaPlaceHolder = new ArrayList<SearchResult>();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT};
        for (FederatedDeploymentInfo deplyInfo : deploymentInfoMap.values()) {
            Object[] vals = new Object[]{deplyInfo};
            metaPlaceHolder.add(SearchResultFactory.getInstance().createSearchResult(fields, vals));
        }
        return metaPlaceHolder;
    }
}

