/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFExecutionType;
import com.splunk.df.search.DFSMonitoringDFSearchExecutors;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSResourceManager;
import com.splunk.df.search.DFSSearchCoordinatorState;
import com.splunk.df.search.DFSeachCanceler;
import com.splunk.df.search.DFSearchDispatcher;
import com.splunk.df.search.ShutdownType;
import com.splunk.df.security.DFSSecurityUtils;
import com.splunk.df.security.SSLConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class DFSearchRequestListerner
extends DFCRunnable {
    static final Logger logger = Logger.getLogger(DFSearchRequestListerner.class);
    private Boolean errorState = false;
    private final int dfsMasterPort;
    private DFSResourceManager dfsResourceManager = new DFSResourceManager();
    private final ScheduledExecutorService scheduledExecutorService;

    public DFSearchRequestListerner(ScheduledExecutorService scheduledExecutorService, int port) {
        this.dfsMasterPort = port;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduledExecutorService.scheduleAtFixedRate(new DFSMonitoringDFSearchExecutors(), 0L, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal() throws Exception {
        logger.info((Object)("DFS master service port:" + this.dfsMasterPort));
        ServerSocket listener = null;
        Socket socket = null;
        final boolean[] notifyBack = new boolean[1];
        try {
            listener = new ServerSocket(this.dfsMasterPort, 0, InetAddress.getByName(null));
            logger.info((Object)String.format("Started DFS master on: %s", listener.getLocalSocketAddress().toString()));
            while ((socket = listener.accept()) != null) {
                final Socket temps = socket;
                new Thread(new DFCRunnable(){

                    @Override
                    protected void runInternal() {
                        block14: {
                            StringBuilder input = new StringBuilder();
                            BufferedReader br = null;
                            BufferedWriter bw = null;
                            try {
                                logger.info((Object)"Listening for new Request");
                                br = new BufferedReader(new InputStreamReader(temps.getInputStream()));
                                bw = new BufferedWriter(new OutputStreamWriter(temps.getOutputStream()));
                                switch (DFSearchRequestListerner.this.checkRequest(br, input)) {
                                    case PROTO_DFS_NEWREQUEST: {
                                        DFSearchRequestListerner.this.handleNewRequest(input, notifyBack, br, bw);
                                        break;
                                    }
                                    case PROTO_DFS_SECURITY_BOOTSTRAP_REQ: {
                                        DFSearchRequestListerner.this.handleSecurityBootStrap(input, bw);
                                        br.close();
                                        bw.close();
                                        break;
                                    }
                                    case PROTO_DFS_SSL_CONFIG_REQ: {
                                        DFSearchRequestListerner.this.handleSSLConfigRequest(bw);
                                        br.close();
                                        bw.close();
                                        break;
                                    }
                                    case PROTO_DFS_SHUTDOWN: {
                                        DFSearchRequestListerner.this.handleShutdown(input);
                                        br.close();
                                        bw.close();
                                        break;
                                    }
                                    case PROTO_DFS_SEARCH_UPDATE: {
                                        br.close();
                                        bw.close();
                                        break;
                                    }
                                    case PROTO_DFS_SEARCH_COORDINATOR_UPDATE: {
                                        DFSearchRequestListerner.this.handleUpdateDfc(input, notifyBack);
                                        break;
                                    }
                                    case PROTO_DFS_REPORT_SYSTEM_STATUS: {
                                        break;
                                    }
                                    case PROTO_DFS_CANCEL_SEARCH: {
                                        DFSearchRequestListerner.this.handleCancelRequest(input, br, bw, DFSearchRequestListerner.this.dfsResourceManager);
                                        break;
                                    }
                                    default: {
                                        logger.warn((Object)"Search sent incorrect message to DFS master");
                                        br.close();
                                        bw.close();
                                        break;
                                    }
                                }
                            }
                            catch (Throwable t) {
                                logger.error((Object)String.format("Error processing request: %s", t.getMessage()), t);
                                if (!notifyBack[0]) break block14;
                                try {
                                    bw.write(DFSProtocolConstants.PROTO_DFS_FAILED.toString() + "," + t.toString() + "\n");
                                    bw.flush();
                                    temps.close();
                                }
                                catch (IOException ex) {
                                    logger.error((Object)ex.toString());
                                }
                            }
                        }
                    }
                }).start();
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error processing request: %s", t.getMessage()), t);
            t.printStackTrace();
        }
        finally {
            try {
                if (listener != null) {
                    listener.close();
                }
                if (this.errorState.booleanValue()) {
                    this.shutdown(ShutdownType.FORCED);
                }
            }
            catch (Throwable temps) {}
            this.performCheckPoint();
        }
    }

    private void handleNewRequest(StringBuilder input, boolean[] notifyback, BufferedReader br, BufferedWriter bw) {
        logger.info((Object)String.format("DFS master port:%d new search request: %s", this.dfsMasterPort, input));
        this.scheduledExecutorService.schedule(new DFSearchDispatcher(input, this.dfsMasterPort, br, bw, this.dfsResourceManager), 0L, TimeUnit.SECONDS);
    }

    private void handleCancelRequest(StringBuilder input, BufferedReader br, BufferedWriter bw, DFSResourceManager dfsResourceManager) {
        logger.info((Object)String.format("DFS master cancel search request: %s", input));
        this.scheduledExecutorService.schedule(new DFSeachCanceler(input, br, bw, dfsResourceManager), 0L, TimeUnit.SECONDS);
    }

    private void handleSecurityBootStrap(StringBuilder input, BufferedWriter bw) {
        logger.info((Object)"DFS master security bootstrap request");
        try {
            SSLConfig sslConfig = SSLConfig.getInstance(input.toString());
            if (!(sslConfig.isOverrideDefaultCertificate() || sslConfig.isUseSparkSecurityConfigs() || sslConfig.isUseNodeSpecificCertificates())) {
                DFSSecurityUtils.generateDefaultCertificates();
            }
            String payload = String.format("%s\n", DFSProtocolConstants.PROTO_DFS_ACK.toString());
            bw.write(payload);
            bw.flush();
        }
        catch (Exception e) {
            logger.error((Object)"Security bootstrap fail", (Throwable)e);
            String payload = String.format("%s\n", DFSProtocolConstants.PROTO_DFS_FAILED.toString());
            try {
                bw.write(payload);
                bw.flush();
            }
            catch (IOException e1) {
                logger.error((Object)"Failed to send error message back to splunkd", (Throwable)e1);
            }
            return;
        }
    }

    private void handleSSLConfigRequest(BufferedWriter bw) {
        logger.info((Object)"Start send SSLConfig to DFC");
        try {
            bw.write(SSLConfig.getInstance().getServerConf());
            bw.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Unable to send SSLConfig to DFC", (Throwable)e);
        }
    }

    private void handleUpdateDfc(StringBuilder input, boolean[] notifyback) {
        class UpdateExecutor
        extends DFCRunnable {
            private StringBuilder input;

            UpdateExecutor(StringBuilder input, boolean[] notifyback) {
                this.input = input;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runInternal() {
                String[] tokens = this.input.toString().split(",");
                String dfcId = tokens[0];
                logger.info((Object)String.format("DFC id received in handle update to dfc callback: %s", dfcId));
                int state = Integer.valueOf(tokens[1]);
                int dfcPort = Integer.parseInt(tokens[3]);
                DFSSearchCoordinatorState stateobj = DFSSearchCoordinatorState.getSearchExecutorState(state);
                DFExecutionType executionType = DFExecutionType.BATCH;
                DFSResourceManager.DFSResourceInfo dri = DFSearchRequestListerner.this.dfsResourceManager.getResourceInfo(dfcId, executionType);
                if (dri != null) {
                    dri.setCoordinatorPort(dfcPort);
                    dri.setCoordinatorState(stateobj);
                    logger.info((Object)String.format("Received dfc state update: dfc id: %s, state: %s, dfc port: %d", dfcId, stateobj.toString(), dfcPort));
                    if (stateobj.equals(DFSSearchCoordinatorState.SHUTDOWN)) {
                        DFSResourceManager dFSResourceManager = DFSearchRequestListerner.this.dfsResourceManager;
                        synchronized (dFSResourceManager) {
                            DFSearchRequestListerner.this.dfsResourceManager.removeResourceInfo(dfcId, executionType);
                        }
                    }
                }
            }
        }
        this.scheduledExecutorService.schedule(new UpdateExecutor(input, notifyback), 0L, TimeUnit.SECONDS);
    }

    private void handleShutdown(StringBuilder input) throws InterruptedException {
        String[] tokens = input.toString().split(",");
        int shutdownState = Integer.valueOf(tokens[0]);
        this.shutdown(ShutdownType.getShutDownType(shutdownState));
    }

    private void shutdown(ShutdownType shutdownState) throws InterruptedException {
        if (shutdownState == ShutdownType.FORCED) {
            this.scheduledExecutorService.shutdownNow();
        } else if (shutdownState == ShutdownType.REGULAR) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService.awaitTermination(600L, TimeUnit.SECONDS);
        } else if (shutdownState == ShutdownType.ALL) {
            this.shutdownDFSSearchExecutors(shutdownState);
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService.awaitTermination(600L, TimeUnit.SECONDS);
        }
    }

    private void performCheckPoint() {
    }

    public void shutdownDFSSearchExecutors(ShutdownType shutdownState) {
        logger.info((Object)("Invoked with shutdown state: " + (Object)((Object)shutdownState)));
        HashMap<String, Integer> allCoordinator = new HashMap<String, Integer>();
        this.dfsResourceManager.ShutAndGetAllCoordinatorInfo(allCoordinator);
        Iterator<Map.Entry<String, Integer>> it = allCoordinator.entrySet().iterator();
        while (it.hasNext()) {
            try {
                int port = it.next().getValue();
                Socket socket = new Socket("127.0.0.1", port);
                OutputStream os = socket.getOutputStream();
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
                bw.write(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString() + "," + (Object)((Object)shutdownState) + "\n");
                bw.flush();
                bw.close();
                socket.close();
            }
            catch (IOException e) {
                logger.warn((Object)e.getMessage());
            }
        }
    }

    private DFSProtocolConstants checkRequest(BufferedReader br, StringBuilder arguments) throws IOException, TimeoutException {
        DFSProtocolConstants status = null;
        String input = br.readLine();
        if (!input.startsWith(DFSProtocolConstants.PROTO_DFS_SECURITY_BOOTSTRAP_REQ.toString())) {
            logger.info((Object)("Request:" + input + ";" + (Object)((Object)DFSProtocolConstants.PROTO_DFS_NEWREQUEST)));
        } else {
            logger.info((Object)("---->" + DFSProtocolConstants.PROTO_DFS_SECURITY_BOOTSTRAP_REQ.toString()));
        }
        if (input.startsWith(DFSProtocolConstants.PROTO_DFS_NEWREQUEST.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_NEWREQUEST;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_NEWREQUEST.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SECURITY_BOOTSTRAP_REQ.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SECURITY_BOOTSTRAP_REQ;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SECURITY_BOOTSTRAP_REQ.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SSL_CONFIG_REQ.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SSL_CONFIG_REQ;
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SEARCH_UPDATE.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SEARCH_UPDATE;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SEARCH_UPDATE.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_REPORT_SYSTEM_STATUS.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_REPORT_SYSTEM_STATUS;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_REPORT_SYSTEM_STATUS.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SHUTDOWN;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SEARCH_UPDATE.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SEARCH_UPDATE;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SEARCH_UPDATE.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_CANCEL_SEARCH.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_CANCEL_SEARCH;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_CANCEL_SEARCH.toString().length() + 1);
        }
        if (status == null) {
            status = DFSProtocolConstants.PROTO_DFS_INVALID_REQUEST;
        }
        arguments.append(input);
        return status;
    }
}

