/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSPhaseFacilitator;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class DFSSidGenerator {
    static final Logger logger = Logger.getLogger(DFSPhaseFacilitator.class);
    private ArrayList<String> toSendSidList;
    private HashSet<String> remoteSidList;
    private HashSet<String> fshSidList;
    private int index;
    private String sid;
    private String shSignature;

    public DFSSidGenerator(String shSig, String sid) {
        this.shSignature = shSig;
        this.sid = sid;
        this.toSendSidList = new ArrayList();
        this.remoteSidList = new HashSet();
        this.fshSidList = new HashSet();
        this.index = 1;
    }

    public String getBaseSid() {
        return this.sid;
    }

    public String getNextSid() {
        String remoteSearch = String.format("remote_%s_prd.ph%d_%s", this.shSignature, this.index, this.sid);
        this.remoteSidList.add(remoteSearch);
        String toSendSid = String.format("prd.ph%d_%s", this.index, this.sid);
        ++this.index;
        this.toSendSidList.add(toSendSid);
        return remoteSearch;
    }

    public boolean AddUpdateFSHSid(String fshSid) {
        int index;
        String actualSid = fshSid.substring(4);
        String toSend = actualSid.substring(index = actualSid.indexOf("prd"));
        if (!this.toSendSidList.contains(toSend)) {
            throw new IllegalStateException(String.format("sid=%s should have been present but is missing, inconsistent state", actualSid));
        }
        this.toSendSidList.remove(toSend);
        if (!this.remoteSidList.contains(actualSid)) {
            throw new IllegalStateException(String.format("sid=%s should have been present but is missing, inconsistent state", actualSid));
        }
        this.remoteSidList.remove(actualSid);
        this.fshSidList.add(fshSid);
        return true;
    }

    public ArrayList<String> getRemoteSidList() {
        return new ArrayList<String>(this.remoteSidList);
    }

    public ArrayList<String> getToSendSidList() {
        return this.toSendSidList;
    }

    public ArrayList<String> getFSHRemoteSidList() {
        return new ArrayList<String>(this.fshSidList);
    }

    public void reset() {
        this.index = 1;
        this.toSendSidList.clear();
        this.fshSidList.clear();
        this.remoteSidList.clear();
    }
}

