/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum DFSSearchCoordinatorState implements Serializable
{
    UNKNOWN(0),
    READYTOAUNCH(1),
    RUNNING(2),
    FAILED(3),
    PENDING_SHUTDOWN(4),
    SHUTDOWN(5);

    public final int finalId;
    private static Map<Integer, DFSSearchCoordinatorState> lookupCache;
    private static boolean isCacheFilled;

    private DFSSearchCoordinatorState(int id) {
        this.finalId = id;
    }

    public static boolean isValid(int value) {
        boolean status = false;
        if (value >= 0 || value <= 4) {
            status = true;
        }
        return status;
    }

    private static void lazyFillCache() {
        HashMap<Integer, DFSSearchCoordinatorState> localC = new HashMap<Integer, DFSSearchCoordinatorState>();
        for (DFSSearchCoordinatorState processStatus : DFSSearchCoordinatorState.values()) {
            localC.put(processStatus.finalId, processStatus);
        }
        lookupCache = localC;
        isCacheFilled = true;
    }

    public static DFSSearchCoordinatorState getSearchExecutorState(int lookupVal) {
        if (!isCacheFilled) {
            DFSSearchCoordinatorState.lazyFillCache();
        }
        return lookupCache.get(lookupVal);
    }

    static {
        lookupCache = null;
        isCacheFilled = false;
    }
}

