/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCLauncherEmbedded;
import com.splunk.df.search.DFExecutionType;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.DFSSearchCoordinatorState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DFSResourceManager
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFSResourceManager.class);
    private HashMap<String, DFSResourceInfo> batchInfoMap = new HashMap();
    private Object stateLock = new Object();

    public DFSResourceInfo getResourceInfo(String dfcId, DFExecutionType executionType) {
        if (executionType.equals((Object)DFExecutionType.BATCH)) {
            return this.batchInfoMap.get(dfcId);
        }
        throw new RuntimeException(String.format("execution mode: %s not supported", executionType.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ShutAndGetAllCoordinatorInfo(HashMap<String, Integer> allCoordinator) {
        Object object = this.stateLock;
        synchronized (object) {
            Iterator<Map.Entry<String, DFSResourceInfo>> it = this.batchInfoMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DFSResourceInfo> entry = it.next();
                DFSResourceInfo info = entry.getValue();
                allCoordinator.put(entry.getKey(), info.dfcPort);
                it.remove();
            }
        }
    }

    public void removeResourceInfo(String dfcId, DFExecutionType executionType) {
        if (executionType.equals((Object)DFExecutionType.BATCH)) {
            this.batchInfoMap.remove(dfcId);
            logger.info((Object)String.format("removed dfc registration since it has shutdown: dfc id: %s", dfcId));
        }
    }

    public void addDri(String dfcId, DFExecutionType executionType, DFSResourceInfo dri) {
        if (executionType.equals((Object)DFExecutionType.BATCH)) {
            this.batchInfoMap.put(dfcId, dri);
        }
    }

    public int numDfcs() {
        return this.batchInfoMap.size();
    }

    public static class DFSResourceInfo {
        private int dfcPort;
        private DFSSearchCoordinatorState coordinatorStateFromHandle;
        private DFSSearchCoordinatorState coordinatorState;

        public int getDfcPort() {
            return this.dfcPort;
        }

        public DFSResourceInfo(String sid, DFExecutionType executionType, int dfcExecutionPort) {
            this.dfcPort = dfcExecutionPort;
            this.coordinatorState = DFSSearchCoordinatorState.UNKNOWN;
        }

        public boolean isCoordinatorReadyToBeShutdown() {
            return this.coordinatorState == DFSSearchCoordinatorState.PENDING_SHUTDOWN;
        }

        public void setCoordinatorState(DFSSearchCoordinatorState state) {
            this.coordinatorState = state;
        }

        public void setCoordinatorPort(int dfcPort) {
            this.dfcPort = dfcPort;
        }

        public DFSSearchCoordinatorState getState() {
            return this.coordinatorState;
        }

        public void setLauncher(DFCLauncherEmbedded dfcLauncher) {
        }
    }
}

