/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.SplunkEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;

public class CsvSplunkEventIterable
implements Iterable<SplunkEvent> {
    static final Logger logger = Logger.getLogger(CsvSplunkEventIterable.class);
    public long totalTime = 0L;
    public long timeToParse = 0L;
    public long timeToCreate = 0L;
    private CSVRecord metadata = null;
    private CSVParser parser = null;
    private Iterator<CSVRecord> recs = null;

    public CsvSplunkEventIterable(BufferedReader br) throws IOException {
        this.parser = new CSVParser((Reader)br, CSVFormat.DEFAULT);
        this.recs = this.parser.iterator();
        if (this.recs.hasNext()) {
            this.metadata = this.recs.next();
        }
    }

    public static void main(String[] args) {
        String recordingFolder = System.getenv("DFS_HOME") + "/recording/";
        File recordings = new File(recordingFolder);
        File[] chunks = recordings.listFiles();
        for (int i = 0; i < chunks.length; ++i) {
            File chunk = chunks[i];
            String name = chunk.getName();
            StringTokenizer st = new StringTokenizer(name, "-");
            st.nextToken();
            st.nextToken();
            int numEvents = Integer.parseInt(st.nextToken());
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(chunk.getAbsolutePath())));
                CsvSplunkEventIterable iterable = new CsvSplunkEventIterable(br);
                Iterator<SplunkEvent> iter = iterable.iterator();
                int counter = 0;
                while (iter.hasNext()) {
                    ++counter;
                }
                logger.info((Object)("parsed chunk file: " + chunk.getName() + " with: " + counter + " events; time to parse: " + iterable.timeToParse + " millis; time to create: " + iterable.timeToCreate + " millis; total time: " + iterable.totalTime + " millis"));
                if (counter == numEvents) continue;
                logger.info((Object)("events read from the chunk does not match with the chunk header info: header num events: " + numEvents + ", parsed num events: " + counter));
                continue;
            }
            catch (Throwable t) {
                logger.debug((Object)("error parsing chunk: " + t.getMessage()));
                t.printStackTrace();
                break;
            }
        }
    }

    @Override
    public Iterator<SplunkEvent> iterator() {
        return new Iterator<SplunkEvent>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = CsvSplunkEventIterable.this.recs.hasNext();
                if (!hasNext) {
                    try {
                        CsvSplunkEventIterable.this.parser.close();
                    }
                    catch (Throwable t) {
                        logger.error((Object)("error while closing parser: " + t.getMessage()), t);
                    }
                }
                return hasNext;
            }

            @Override
            public SplunkEvent next() {
                CSVRecord rec = (CSVRecord)CsvSplunkEventIterable.this.recs.next();
                SplunkEvent event = new SplunkEvent(CsvSplunkEventIterable.this.metadata, rec);
                return event;
            }

            @Override
            public void remove() {
            }
        };
    }
}

