/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BucketName {
    public static final String LEGAL_NAME_REGEX = "([A-Za-z0-9]+?)_(\\d+?)_(\\d+?)_(.+)";
    public static final String GUID_ADDITION = "_(.+)";
    private static final int DB_GROUP = 1;
    private static final int LATEST_GROUP = 2;
    private static final int EARLIEST_GROUP = 3;
    private static final int INDEX_GROUP = 4;
    private static final int GUID_GROUP = 5;
    private final String name;
    private GroupRegex groupRegex;

    public BucketName(String name) {
        this.name = name;
        String regex = LEGAL_NAME_REGEX;
        if (this.hasGuid()) {
            regex = regex + GUID_ADDITION;
        }
        this.groupRegex = new GroupRegex(regex, name);
    }

    public boolean hasGuid() {
        return this.getUnderscoresInName() == 4;
    }

    private int getUnderscoresInName() {
        return this.name == null ? 0 : this.name.split("_").length - 1;
    }

    private void validateBucketName() {
        int underscoresInName = this.getUnderscoresInName();
        if (underscoresInName > 4 || underscoresInName < 3) {
            throw new IllegalBucketNameException("Underscores in the bucket name must be 3 or 4. Was: " + underscoresInName + ", name: " + this.name);
        }
    }

    public String getDB() {
        this.validateBucketName();
        return this.groupRegex.getValue(1);
    }

    public long getEarliest() {
        return Long.parseLong(this.groupRegex.getValue(3));
    }

    public long getLatest() {
        return Long.parseLong(this.groupRegex.getValue(2));
    }

    public long getBucketNumber() {
        this.validateBucketName();
        String value = this.groupRegex.getValue(4);
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new IllegalBucketNameException(e);
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidBucketName() {
        try {
            this.getDB();
            this.getLatest();
            this.getEarliest();
            this.getBucketNumber();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getGuid() {
        return this.groupRegex.getValue(5);
    }

    public static class IllegalRegexGroupException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IllegalRegexGroupException(String msg) {
            super(msg);
        }

        public IllegalRegexGroupException(Exception e) {
            super(e);
        }
    }

    public static class GroupRegex {
        private static final Logger logger = Logger.getLogger(GroupRegex.class);
        private final String regex;
        private final String value;

        public GroupRegex(String regex, String value) {
            this.regex = regex;
            this.value = value;
        }

        public String getValue(int groupIndex) {
            this.throwExceptionIfNotValidRegex();
            try {
                return this.getRegexGroup(groupIndex);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalRegexGroupException(e);
            }
        }

        private String getRegexGroup(int groupIndex) {
            Pattern legalPattern = Pattern.compile(this.regex);
            Matcher matcher = legalPattern.matcher(this.value);
            matcher.find();
            return matcher.group(groupIndex);
        }

        private void throwExceptionIfNotValidRegex() {
            if (!Pattern.matches(this.regex, this.value)) {
                logger.debug((Object)("Bucket name was not legal. bucket_name=" + this.value + ", legal_bucket_name_regex=" + this.regex));
                throw new IllegalRegexGroupException("regex: " + this.regex + ", value: " + this.value);
            }
        }
    }

    public static class IllegalBucketNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IllegalBucketNameException(String msg) {
            super(msg);
        }

        public IllegalBucketNameException(Exception e) {
            super(e);
        }
    }
}

