/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.collect.IndexProcessor;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class SequenceFileRecordReader
extends BaseSplunkRecordReader {
    private final Pattern FILE_PATTERN = Pattern.compile("\\.seq$");
    private Text key = new Text();
    private Text value = new Text();
    private RecordReader rr;
    protected boolean ignoreKey = true;
    protected String kvDelimiter = "\t";
    protected String dataFormat = "";

    @Override
    public String getName() {
        return "sequence";
    }

    @Override
    public Pattern getFilePattern() {
        return this.FILE_PATTERN;
    }

    @Override
    public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = new FileSplit(split.getPath(), split.getStart(), split.getLength(), split.getLocations());
        this.rr = new org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader();
        this.rr.initialize((InputSplit)fileSplit, context);
        if (IndexProcessor.isHunkEventFile(fileSplit.getPath())) {
            this.dataFormat = "json_events";
        }
        this.ignoreKey = StrUtil.parseBoolean(this.getConfVar("ignore.key", Boolean.toString(true)), true);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.rr.nextKeyValue();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        this.key.set(String.valueOf(this.rr.getCurrentKey()));
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        if (this.ignoreKey) {
            this.value.set(String.valueOf(this.rr.getCurrentValue()));
        } else {
            this.value.set(String.valueOf(this.rr.getCurrentKey()) + this.kvDelimiter + String.valueOf(this.rr.getCurrentValue()));
        }
        return this.value;
    }

    @Override
    public String getOutputDataFormat() {
        return this.dataFormat;
    }
}

