/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.filter.schema.AvroSchemaFilter;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.VixInputSplit;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class BaseAvroRecordReader
extends BaseSplunkRecordReader {
    protected long _start;
    protected long _end;
    protected FileReader<GenericRecord> _reader;
    protected SeekableInput _in;
    protected Text _key = new Text();
    protected Text _val = new Text();
    private final Pattern FILE_PATTERN = Pattern.compile("\\.avro$");
    private static Logger gLogger = Logger.getLogger(BaseAvroRecordReader.class);
    protected GenericRecord buffer;

    @Override
    public void vixInitialize(VixInputSplit filesplit, TaskAttemptContext context) throws IOException, InterruptedException {
        GenericDatumReader gdr = new GenericDatumReader();
        this._in = new FsInput(filesplit.getPath(), this._conf);
        this._reader = DataFileReader.openReader((SeekableInput)this._in, (DatumReader)gdr);
        Schema writerSchema = null;
        try {
            writerSchema = gdr.getSchema();
        }
        catch (NoSuchMethodError e) {
            try {
                Field f = gdr.getClass().getDeclaredField("actual");
                f.setAccessible(true);
                writerSchema = (Schema)f.get(gdr);
            }
            catch (Exception e1) {
                gLogger.error((Object)"Failed to get avro writer schema: ", (Throwable)e1);
                throw new RuntimeException("Failed to get avro writer schema: ", e1);
            }
        }
        AvroSchemaFilter filter = new AvroSchemaFilter();
        Schema readSchema = filter.filter(writerSchema, this._requiredFields);
        gLogger.debug((Object)("readSchema=" + readSchema));
        gdr.setExpected(readSchema);
        this._reader.sync(filesplit.getStart());
        this._start = this._reader.tell();
        this._end = filesplit.getStart() + filesplit.getLength();
    }

    @Override
    public String getOutputDataFormat() {
        return "json";
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this._in);
        IOUtils.closeQuietly(this._reader);
    }

    public Text getCurrentKey() throws IOException {
        return this._key;
    }

    public Text getCurrentValue() throws IOException {
        return this._val;
    }

    @Override
    public float getProgress() throws IOException {
        if (this._reader == null || this._end == this._start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this._reader.tell() - this._start) / (float)(this._end - this._start));
    }

    public Object processEvent(Object o) {
        return o;
    }

    public boolean nextKeyValue() throws IOException {
        if (this._reader == null) {
            return false;
        }
        if (!this._reader.hasNext() || this._reader.pastSync(this._end)) {
            return false;
        }
        this.buffer = (GenericRecord)this._reader.next((Object)this.buffer);
        return true;
    }

    @Override
    public Pattern getFilePattern() {
        return this.FILE_PATTERN;
    }

    @Override
    public String getName() {
        return "avro";
    }
}

