/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.CacheReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class Cache {
    public static final String DELETED_PATH_VALUE = "deleted";
    private final Map<CacheReference.CacheUpdate.PathType, Set<String>> paths;
    private final Set<String> allPaths;
    private final Map<String, String> transitions;
    private final int id;
    private final Map<String, Long> offsets;

    public Cache() {
        this(0, Cache.constructNewPathsMap(), new HashMap<String, String>(), new HashMap<String, Long>());
    }

    private Cache(int id, Map<CacheReference.CacheUpdate.PathType, Set<String>> paths, Map<String, String> transitions, Map<String, Long> offsets) {
        this.id = id;
        this.paths = paths;
        this.transitions = transitions;
        this.offsets = offsets;
        this.allPaths = new HashSet<String>();
        for (Map.Entry<CacheReference.CacheUpdate.PathType, Set<String>> e : paths.entrySet()) {
            if (e.getKey().equals((Object)CacheReference.CacheUpdate.PathType.DELETE)) continue;
            this.allPaths.addAll((Collection<String>)e.getValue());
        }
    }

    public Set<String> getCachePaths() {
        return this.allPaths;
    }

    public Set<String> getCachePaths(CacheReference.CacheUpdate.PathType type) {
        return this.paths.get((Object)type);
    }

    public Map<String, String> getTransitions() {
        return this.transitions;
    }

    public int getId() {
        return this.id;
    }

    public Map<String, Long> getOffsets() {
        return this.offsets;
    }

    public Cache merge(CacheReference.CacheUpdate cacheUpdate) {
        Map.Entry<CacheReference.CacheUpdate.PathType, String> added = cacheUpdate.getAddedPath();
        Map<String, Long> mergedPaths = cacheUpdate.getMergedPaths();
        this.verifyMergedPaths(mergedPaths);
        HashMap<String, String> newTransitions = new HashMap<String, String>(this.transitions);
        HashMap<String, Long> newOffsets = new HashMap<String, Long>(this.offsets);
        for (Map.Entry<String, Long> merged : mergedPaths.entrySet()) {
            newTransitions.put(merged.getKey(), added.getValue());
            newOffsets.put(merged.getKey(), merged.getValue());
        }
        return new Cache(this.getId() + 1, this.updatePaths(added, mergedPaths), newTransitions, newOffsets);
    }

    private Map<CacheReference.CacheUpdate.PathType, Set<String>> updatePaths(Map.Entry<CacheReference.CacheUpdate.PathType, String> added, Map<String, Long> mergedOffsets) {
        Map<CacheReference.CacheUpdate.PathType, Set<String>> newPaths = Cache.constructNewPathsMap();
        this.updateWithAddedPath(added, mergedOffsets, newPaths);
        this.updateWithMergedOffsets(mergedOffsets, newPaths);
        return newPaths;
    }

    private void updateWithAddedPath(Map.Entry<CacheReference.CacheUpdate.PathType, String> added, Map<String, Long> mergedOffsets, Map<CacheReference.CacheUpdate.PathType, Set<String>> newPaths) {
        CacheReference.CacheUpdate.PathType pathType = added.getKey();
        if (pathType.equals((Object)CacheReference.CacheUpdate.PathType.DELETE)) {
            for (String s : mergedOffsets.keySet()) {
                newPaths.get((Object)CacheReference.CacheUpdate.PathType.DELETE).add(s);
            }
        } else if (pathType.equals((Object)CacheReference.CacheUpdate.PathType.MUTABLE)) {
            newPaths.get((Object)CacheReference.CacheUpdate.PathType.MUTABLE).add(added.getValue());
        } else if (pathType.equals((Object)CacheReference.CacheUpdate.PathType.STABLE)) {
            newPaths.get((Object)CacheReference.CacheUpdate.PathType.STABLE).add(added.getValue());
        } else {
            throw new UnsupportedOperationException("Unknown PathType: " + (Object)((Object)pathType));
        }
    }

    private void updateWithMergedOffsets(Map<String, Long> mergedOffsets, Map<CacheReference.CacheUpdate.PathType, Set<String>> newPaths) {
        HashSet oldKeepers = new HashSet(this.paths.get((Object)CacheReference.CacheUpdate.PathType.MUTABLE));
        oldKeepers.removeAll(mergedOffsets.keySet());
        newPaths.get((Object)CacheReference.CacheUpdate.PathType.MUTABLE).addAll(oldKeepers);
        newPaths.get((Object)CacheReference.CacheUpdate.PathType.STABLE).addAll((Collection<String>)this.paths.get((Object)CacheReference.CacheUpdate.PathType.STABLE));
        newPaths.get((Object)CacheReference.CacheUpdate.PathType.DELETE).addAll((Collection<String>)this.paths.get((Object)CacheReference.CacheUpdate.PathType.DELETE));
    }

    private static Map<CacheReference.CacheUpdate.PathType, Set<String>> constructNewPathsMap() {
        HashMap<CacheReference.CacheUpdate.PathType, Set<String>> newPaths = new HashMap<CacheReference.CacheUpdate.PathType, Set<String>>();
        for (CacheReference.CacheUpdate.PathType p : CacheReference.CacheUpdate.PathType.values()) {
            newPaths.put(p, new HashSet());
        }
        return newPaths;
    }

    private void verifyMergedPaths(Map<String, Long> mergedOffsets) {
        if (!this.paths.get((Object)CacheReference.CacheUpdate.PathType.MUTABLE).containsAll(mergedOffsets.keySet())) {
            throw new RuntimeException("The removed path did not exist in the cache. Must mean some other merge has deleted the path before this update.");
        }
    }

    public String toJson() throws IOException {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        HashMap<String, Set<String>> pathTypes = new HashMap<String, Set<String>>();
        for (Map.Entry<CacheReference.CacheUpdate.PathType, Set<String>> ps : this.paths.entrySet()) {
            pathTypes.put(ps.getKey().name().toLowerCase(), ps.getValue());
        }
        objectMap.put("paths", pathTypes);
        objectMap.put("transitions", this.transitions);
        objectMap.put("id", this.id);
        objectMap.put("offsets", this.offsets);
        try {
            return new ObjectMapper().writeValueAsString(objectMap);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static Cache fromJson(InputStream in) throws IOException {
        String json = IOUtils.toString((InputStream)in);
        if (json.isEmpty()) {
            return new Cache();
        }
        Map map = (Map)new ObjectMapper().readValue(json, Map.class);
        HashMap<CacheReference.CacheUpdate.PathType, Set<String>> paths = Cache.getPaths(map);
        Map transitions = (Map)map.get("transitions");
        Integer id = (Integer)map.get("id");
        HashMap<String, Long> offsets = Cache.getOffsets(map);
        return new Cache(id, paths, new HashMap<String, String>(transitions), offsets);
    }

    private static HashMap<CacheReference.CacheUpdate.PathType, Set<String>> getPaths(Map map) {
        HashMap<CacheReference.CacheUpdate.PathType, List<String>> lists = new HashMap<CacheReference.CacheUpdate.PathType, List<String>>();
        for (CacheReference.CacheUpdate.PathType pt : CacheReference.CacheUpdate.PathType.values()) {
            lists.put(pt, Cache.getInPaths(map, pt.name().toLowerCase()));
        }
        return Cache.listsToSets(lists);
    }

    private static List<String> getInPaths(Map map, String key) {
        List paths = (List)((Map)map.get("paths")).get(key);
        return paths == null ? new ArrayList() : paths;
    }

    private static HashMap<CacheReference.CacheUpdate.PathType, Set<String>> listsToSets(Map<CacheReference.CacheUpdate.PathType, List<String>> lists) {
        HashMap<CacheReference.CacheUpdate.PathType, Set<String>> sets = new HashMap<CacheReference.CacheUpdate.PathType, Set<String>>();
        for (Map.Entry<CacheReference.CacheUpdate.PathType, List<String>> e : lists.entrySet()) {
            sets.put(e.getKey(), new HashSet(e.getValue()));
        }
        return sets;
    }

    private static HashMap<String, Long> getOffsets(Map map) {
        Map jsonOffsets = (Map)map.get("offsets");
        HashMap<String, Long> offsets = new HashMap<String, Long>();
        for (Map.Entry e : jsonOffsets.entrySet()) {
            offsets.put((String)e.getKey(), Long.parseLong(e.getValue().toString()));
        }
        return offsets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.offsets == null ? 0 : this.offsets.hashCode());
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        result = 31 * result + (this.transitions == null ? 0 : this.transitions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cache other = (Cache)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.offsets == null ? other.offsets != null : !this.offsets.equals(other.offsets)) {
            return false;
        }
        if (this.paths == null ? other.paths != null : !this.paths.equals(other.paths)) {
            return false;
        }
        return !(this.transitions == null ? other.transitions != null : !this.transitions.equals(other.transitions));
    }
}

