/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.filter.schema;

import com.splunk.filter.schema.SimpleListSchemaFilter;
import com.splunk.util.WildcardList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveSchemaFilter
extends SimpleListSchemaFilter<FieldSchema> {
    private Map<Integer, Map> readColumnIds;
    private String tableColumnNames;
    private String tableColumnTypes;

    public Map<Integer, Map> readColumnIds() {
        return this.readColumnIds;
    }

    public String tableColumnNames() {
        return this.tableColumnNames;
    }

    public String tableColumnTypes() {
        return this.tableColumnTypes;
    }

    private Map<Integer, Map> filter(String prefix, FieldSchema field, WildcardList requiredFields, boolean ignoreRepeatableFieldSuffix) {
        String candidate = this.getMatchingCandidate(prefix, field, ignoreRepeatableFieldSuffix);
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            if (requiredFields.matches(candidate)) {
                return Collections.EMPTY_MAP;
            }
        } else {
            if ((typeInfo.getCategory() == ObjectInspector.Category.MAP || typeInfo.getCategory() == ObjectInspector.Category.LIST) && requiredFields.isPrefixMatch(candidate)) {
                return Collections.EMPTY_MAP;
            }
            if (requiredFields.isPrefixMatch(candidate)) {
                ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
                HashMap<Integer, Map> fieldIds = new HashMap<Integer, Map>();
                int j = 0;
                if (typeInfo.getCategory() == ObjectInspector.Category.STRUCT) {
                    StructObjectInspector soi = (StructObjectInspector)oi;
                    for (StructField sf : soi.getAllStructFieldRefs()) {
                        field = new FieldSchema(sf.getFieldName(), sf.getFieldObjectInspector().getTypeName(), null);
                        Map<Integer, Map> map = this.filter(candidate, field, requiredFields, ignoreRepeatableFieldSuffix);
                        if (map != null) {
                            fieldIds.put(j, map);
                        }
                        ++j;
                    }
                } else if (typeInfo.getCategory() == ObjectInspector.Category.UNION) {
                    UnionObjectInspector uoi = (UnionObjectInspector)oi;
                    for (ObjectInspector ufoi : uoi.getObjectInspectors()) {
                        field = new FieldSchema("" + j, ufoi.getTypeName(), null);
                        Map<Integer, Map> map = this.filter(candidate, field, requiredFields, ignoreRepeatableFieldSuffix);
                        if (map != null) {
                            fieldIds.put(j, map);
                        }
                        ++j;
                    }
                }
                if (!fieldIds.isEmpty()) {
                    return fieldIds;
                }
            }
        }
        return null;
    }

    @Override
    public List<FieldSchema> filter(String prefix, List<FieldSchema> schema, WildcardList requiredFields, boolean ignoreRepeatableFieldSuffix) {
        ArrayList<FieldSchema> result = new ArrayList<FieldSchema>();
        StringBuilder names = new StringBuilder();
        StringBuilder types = new StringBuilder();
        Map<Integer, Map> readFieldIds = null;
        int i = 0;
        if (!requiredFields.matchesAll()) {
            this.readColumnIds = new HashMap<Integer, Map>();
        }
        for (FieldSchema field : schema) {
            if (!requiredFields.matchesAll()) {
                readFieldIds = this.filter(prefix, field, requiredFields, ignoreRepeatableFieldSuffix);
                if (readFieldIds != null) {
                    this.readColumnIds.put(i, readFieldIds);
                    result.add(field);
                }
            } else {
                result.add(field);
            }
            names.append(field.getName()).append(",");
            types.append(field.getType()).append(":");
            ++i;
        }
        if (names.length() > 0) {
            names.deleteCharAt(names.length() - 1);
            types.deleteCharAt(types.length() - 1);
        }
        this.tableColumnNames = names.toString();
        this.tableColumnTypes = types.toString();
        return result;
    }

    @Override
    public List<FieldSchema> filter(String prefix, List<FieldSchema> schema, WildcardList requiredFields) {
        return this.filter(prefix, schema, requiredFields, false);
    }

    @Override
    public boolean isRepeatable(FieldSchema field) {
        return field.getType().startsWith("array");
    }

    @Override
    protected String getFieldName(FieldSchema field) {
        return field.getName();
    }

    public void reset() {
        this.readColumnIds = null;
        this.tableColumnNames = null;
        this.tableColumnTypes = null;
    }
}

