/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.util;

import com.splunk.commons.util.CustomTrust;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONObject;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static void writeJsonBody(OutputStream stream, JSONObject object) throws IOException {
        try (OutputStreamWriter wr = new OutputStreamWriter(stream);){
            wr.write(object.toString());
            wr.flush();
        }
    }

    public static void basicAuthentication(HttpURLConnection connection, String username, String password) {
        String auth = username + ':' + password;
        String encodedAuth = DatatypeConverter.printBase64Binary((byte[])auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
    }

    public static String readAll(InputStream input) throws IOException {
        StringBuilder stringBuilder;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line + '\n');
            }
        }
        return stringBuilder.toString();
    }

    public static void relaxSSLSigningRequirement() {
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, new TrustManager[]{new CustomTrust()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            });
        }
        catch (NoSuchAlgorithmException nsae) {
            return;
        }
        catch (KeyManagementException kme) {
            return;
        }
    }
}

