/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.SplunkContext;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.handlers.IGroupByHandler;
import com.splunk.commons.providers.handlers.IOrderByHandler;
import com.splunk.commons.providers.handlers.ISelectHandler;
import com.splunk.commons.providers.handlers.IWhereHandler;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.commons.visitors.SqlFormatter;
import java.io.IOException;

public class SqlPlanProvider
implements IPlanProvider,
IWhereHandler,
ISelectHandler,
IGroupByHandler,
IOrderByHandler {
    private SplunkContext context;
    private Dataset dataset;
    private IWherePredicate where;
    private IGroupBy[] groupBy;
    private ISelection[] selections;
    private IOrdering[] orderBy;

    @Override
    public void initialize(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("sql")) {
            throw new IOException("SqlPlanProvider only supports sql datasets.");
        }
        this.dataset = dataset;
    }

    @Override
    public void where(IWherePredicate where) {
        this.where = where;
    }

    @Override
    public void groupBy(IGroupBy[] groupBy) {
        this.groupBy = groupBy;
    }

    @Override
    public void select(ISelection[] selections) {
        this.selections = selections;
    }

    @Override
    public void orderBy(IOrdering[] orderings) {
        this.orderBy = orderings;
    }

    @Override
    public CommandNode getCommand() {
        return new UnknownCommand("dbxquery", String.format(this.getSQL(), new Object[0]), CommandType.SP_STREAM, new FieldProperties[]{new FieldProperties("*", false, false, false, false)});
    }

    private String getSQL() {
        StringBuffer buffer = new StringBuffer();
        this.appendSelectionSQL(buffer, this.selections);
        SqlPlanProvider.appendWhere(buffer, this.where);
        SqlPlanProvider.appendGroupBy(buffer, this.groupBy);
        SqlPlanProvider.appendOrderBy(buffer, this.orderBy);
        return buffer.toString();
    }

    private void appendSelectionSQL(StringBuffer buffer, ISelection[] selections) {
        if (this.selections == null || this.selections.length == 0) {
            buffer.append("SELECT * FROM [").append(this.dataset.getName()).append(']');
        } else {
            buffer.append("SELECT ");
            Object[] array = new String[selections.length];
            SplFormatter formatter = new SplFormatter();
            for (int i = 0; i < array.length; ++i) {
                array[i] = selections[i].getTypeNode().accept(formatter);
            }
            buffer.append(StringUtils.commaSeparate(array));
            buffer.append(" [").append(this.dataset.getName()).append("]");
        }
    }

    private static void appendWhere(StringBuffer buffer, IWherePredicate predicate) {
        if (predicate == null) {
            return;
        }
        buffer.append(" WHERE ");
        buffer.append(predicate.getNode().accept(new SqlFormatter()));
    }

    private static void appendGroupBy(StringBuffer buffer, IGroupBy[] groupBy) {
        if (groupBy == null || groupBy.length == 0) {
            return;
        }
        buffer.append(" GROUP BY ");
        Object[] array = new String[groupBy.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((Node)((Object)groupBy[i])).accept(new SplFormatter());
        }
        buffer.append(StringUtils.commaSeparate(array));
    }

    private static void appendOrderBy(StringBuffer buffer, IOrdering[] orderBy) {
        if (orderBy == null || orderBy.length == 0) {
            return;
        }
        buffer.append(" ORDER BY ");
        Object[] array = new String[orderBy.length];
        for (int i = 0; i < array.length; ++i) {
            if (orderBy[i].getFieldType() != FieldType.AUTO) {
                throw new IllegalStateException("Need to use a different formatter if FieldType != AUTO.");
            }
            array[i] = orderBy[i].toString();
        }
        buffer.append(StringUtils.commaSeparate(array));
    }
}

