/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.RepresentativeRow;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.datasets.ConstantField;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.Fields;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IField;
import com.splunk.commons.datasets.IPartitionEliminator;
import com.splunk.commons.visitors.PredicateEvaluator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Partition
implements IPartitionEliminator {
    private final Fields constraints;
    private IDatasetInfo underlyingDataset;
    private final Dataset dataset;
    private boolean resolved;

    public Partition(Dataset dataset, Fields constraints) {
        this.dataset = dataset;
        this.constraints = Partition.verifyNoUndefinedFields(constraints);
    }

    public Partition(IDatasetInfo resolvedDataset, Fields constraints) {
        this.underlyingDataset = resolvedDataset;
        this.constraints = Partition.verifyNoUndefinedFields(constraints);
        this.dataset = new Dataset(resolvedDataset.getKind(), resolvedDataset.getName());
        this.resolved = true;
    }

    @Override
    public boolean canEliminate(IPredicate predicate) {
        PredicateEvaluator evaluator = new PredicateEvaluator();
        evaluator.setPredicate(predicate);
        return !evaluator.evaluate(new RepresentativeRow(this.constraints));
    }

    public Fields getConstraints() {
        return this.constraints;
    }

    public IDatasetInfo getUnderlyingDataset() {
        return this.underlyingDataset;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.dataset.getName());
        jsonObject.put("kind", (Object)this.dataset.getKind());
        if (this.constraints != null) {
            jsonObject.put("constraints", (Object)Fields.getJSON(this.constraints));
        }
        return jsonObject;
    }

    public static Partition load(JSONObject json) {
        String name = json.getString("name");
        String kind = json.optString("kind", null);
        String qualifiedName = kind == null ? name : kind + ':' + name;
        Dataset dataset = new Dataset(qualifiedName);
        JSONArray constraintsJSON = json.getJSONArray("constraints");
        Fields constraints = constraintsJSON != null ? Fields.load(constraintsJSON) : new Fields();
        return new Partition(dataset, constraints);
    }

    private static String buildName(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("A partition must have a underlying Dataset.");
        }
        return dataset.getQualifiedName();
    }

    private static List<IField> buildFields(IDatasetInfo underlyingDataset) {
        if (underlyingDataset == null) {
            throw new IllegalArgumentException("A partition must have a underlying Dataset.");
        }
        return underlyingDataset.getFields();
    }

    public void setResolvedDataset(IDatasetInfo resolvedDataset) {
        if (!this.resolved) {
            assert (resolvedDataset.getQualifiedName().equals(this.dataset.getQualifiedName()));
        } else {
            throw new IllegalArgumentException("A partition can be resolved only once!");
        }
        this.underlyingDataset = resolvedDataset;
        this.resolved = true;
    }

    private static Fields verifyNoUndefinedFields(Fields fields) {
        if (fields != null) {
            for (IField f : fields) {
                if (f instanceof ConstantField) continue;
                throw new IllegalArgumentException("Augmentations must be ConstantField(s) or, in the future, ExpressionColumn(s)");
            }
        }
        return fields;
    }

    public boolean isResolved() {
        return this.resolved;
    }
}

