/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.DatasetFactory;
import com.splunk.commons.datasets.DatasetsPredicateEvaluator;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.visitors.KindPredicateModifierVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDatasetResolver
implements IDatasetResolver {
    private final Map<String, IDatasetInfo> nameToDatasetMap = new HashMap<String, IDatasetInfo>();
    private final Map<String, IDatasetInfo> fqnToDatasetMap = new HashMap<String, IDatasetInfo>();
    private static final Logger logger = LoggerFactory.getLogger(InMemoryDatasetResolver.class);
    private final Map<String, Set<String>> kindToNameMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> moduleToNameMap = new HashMap<String, Set<String>>();
    private final Map<String, IDatasetInfo> idToDatasetMap = new HashMap<String, IDatasetInfo>();
    private String module = "";

    @Override
    public IDatasetInfo resolveDataset(String kind, String name) {
        String fqn = kind.equals("unknown") ? name : kind + ':' + name;
        return this.resolveDataset(fqn);
    }

    @Override
    public IDatasetInfo resolveDataset(Dataset dataset) {
        return this.resolveDataset(dataset.getKind(), dataset.getName());
    }

    @Override
    public IDatasetInfo resolveDataset(String name) {
        IDatasetInfo dataset;
        IDatasetInfo iDatasetInfo = dataset = name.indexOf(":") != -1 ? this.fqnToDatasetMap.get(name) : this.nameToDatasetMap.get(name);
        if (dataset == null) {
            logger.warn(String.format("Dataset not found for name=%s.", name));
        }
        return dataset;
    }

    @Override
    public List<IDatasetInfo> query(IWherePredicate predicate) {
        IWherePredicate extendedPredicate = (IWherePredicate)((Object)predicate.getNode().accept(new KindPredicateModifierVisitor()));
        Set<IDatasetInfo> datasetInfos = extendedPredicate.getNode().accept(new PredicateEvaluator());
        if (datasetInfos.isEmpty()) {
            logger.warn("Couldn't find any Dataset for query: " + extendedPredicate.getNode().accept(new SplFormatter()));
        }
        ArrayList<IDatasetInfo> result = new ArrayList<IDatasetInfo>(datasetInfos);
        for (IDatasetInfo datasetInfo : datasetInfos) {
            if (!datasetInfo.getKind().equals("import")) continue;
            result.add(this.idToDatasetMap.get(datasetInfo.getProperties().getProperty("originalDatasetId").getString().get()));
        }
        return result;
    }

    public int numDatasets() {
        return this.fqnToDatasetMap.size();
    }

    public void loadDatasets(String json) {
        JSONArray datasetsArray = new JSONArray(json);
        for (JSONObject datasetJson : datasetsArray) {
            IDatasetInfo datasetInfo = DatasetFactory.loadDatasetInfo(datasetJson);
            this.registerOrUpdateDataset(datasetInfo);
        }
    }

    public boolean registerOrUpdateDataset(IDatasetInfo datasetInfo) {
        boolean isUpdate = this.nameToDatasetMap.containsKey(datasetInfo.getName());
        this.nameToDatasetMap.put(datasetInfo.getName(), datasetInfo);
        this.fqnToDatasetMap.put(datasetInfo.getQualifiedName(), datasetInfo);
        if (!this.kindToNameMap.containsKey(datasetInfo.getKind())) {
            this.kindToNameMap.put(datasetInfo.getKind(), new HashSet());
        }
        this.kindToNameMap.get(datasetInfo.getKind()).add(datasetInfo.getName());
        if (!this.moduleToNameMap.containsKey(datasetInfo.getModule())) {
            this.moduleToNameMap.put(datasetInfo.getModule(), new HashSet());
        }
        this.moduleToNameMap.get(datasetInfo.getModule()).add(datasetInfo.getName());
        this.idToDatasetMap.put(datasetInfo.getId().toString(), datasetInfo);
        if (isUpdate) {
            logger.info(String.format("Dataset with name=%s updated!", datasetInfo.getName()));
        } else {
            logger.info(String.format("Registered new Dataset with name=%s.", datasetInfo.getName()));
        }
        return true;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public void setModule(String module) {
        this.module = module;
    }

    private class PredicateEvaluator
    extends DatasetsPredicateEvaluator {
        private PredicateEvaluator() {
        }

        @Override
        protected Set<IDatasetInfo> getDatasetsByName(String name) {
            HashSet<IDatasetInfo> datasetInfos = new HashSet<IDatasetInfo>();
            if (!InMemoryDatasetResolver.this.nameToDatasetMap.containsKey(name)) {
                if (name.contains("*")) {
                    TermMatcher matcher = new TermMatcher(name, true);
                    for (IDatasetInfo datasetInfo : InMemoryDatasetResolver.this.nameToDatasetMap.values()) {
                        if (!matcher.match(datasetInfo.getName())) continue;
                        datasetInfos.add(datasetInfo);
                    }
                }
                return datasetInfos;
            }
            datasetInfos.add((IDatasetInfo)InMemoryDatasetResolver.this.nameToDatasetMap.get(name));
            return datasetInfos;
        }

        @Override
        protected Set<IDatasetInfo> getDatasetsByKind(String kind) {
            HashSet<IDatasetInfo> datasetInfos = new HashSet<IDatasetInfo>();
            if (InMemoryDatasetResolver.this.kindToNameMap.containsKey(kind)) {
                for (String name : (Set)InMemoryDatasetResolver.this.kindToNameMap.get(kind)) {
                    datasetInfos.add((IDatasetInfo)InMemoryDatasetResolver.this.nameToDatasetMap.get(name));
                }
            }
            return datasetInfos;
        }

        @Override
        protected Set<IDatasetInfo> getDatasetsByModule(String module) {
            HashSet<IDatasetInfo> datasetInfos = new HashSet<IDatasetInfo>();
            if (InMemoryDatasetResolver.this.moduleToNameMap.containsKey(module)) {
                for (String name : (Set)InMemoryDatasetResolver.this.moduleToNameMap.get(module)) {
                    datasetInfos.add((IDatasetInfo)InMemoryDatasetResolver.this.nameToDatasetMap.get(name));
                }
            }
            return datasetInfos;
        }
    }
}

