/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

public enum FieldType {
    UNKNOWN('U'),
    DIMENSION('D'),
    MEASURE('M');

    private final char value;

    private FieldType(char value) {
        this.value = value;
    }

    private char value() {
        return this.value;
    }

    public String stringValue() {
        return new String(new char[]{this.value()});
    }

    public static FieldType fromString(String s) throws IllegalArgumentException {
        String str;
        switch (str = s.toUpperCase()) {
            case "U": {
                return UNKNOWN;
            }
            case "D": {
                return DIMENSION;
            }
            case "M": {
                return MEASURE;
            }
        }
        try {
            return FieldType.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("String \"" + s + "\" can't be converted to FieldType.");
        }
    }
}

