/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

public enum DataType {
    BOOLEAN('B'),
    DATE('D'),
    NUMBER('N'),
    OBJECT_ID('O'),
    STRING('S'),
    UNKNOWN('U'),
    JSON('J'),
    STRING_ARRAY('X'),
    PROPERTIES('P');

    private final char value;

    private DataType(char value) {
        this.value = value;
    }

    private char value() {
        return this.value;
    }

    public String stringValue() {
        return new String(new char[]{this.value()});
    }

    public static DataType fromString(String s) {
        String str;
        switch (str = s.toUpperCase()) {
            case "B": {
                return BOOLEAN;
            }
            case "D": {
                return DATE;
            }
            case "N": {
                return NUMBER;
            }
            case "O": {
                return OBJECT_ID;
            }
            case "S": {
                return STRING;
            }
            case "U": {
                return UNKNOWN;
            }
            case "J": {
                return JSON;
            }
            case "X": {
                return STRING_ARRAY;
            }
            case "P": {
                return PROPERTIES;
            }
        }
        try {
            return DataType.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("String \"" + s + "\" can't be converted to DataType.");
        }
    }
}

