/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;

public final class NullNode
extends TypeNode {
    public static final NullNode INSTANCE = new NullNode("null");
    private final String value;

    private NullNode(String value) {
        super("null");
        this.value = value;
    }

    public static NullNode load(String value) {
        if (NullNode.INSTANCE.value.equalsIgnoreCase(value)) {
            return INSTANCE;
        }
        throw new IllegalArgumentException("Invalid NULL value: " + value);
    }

    public static Object getValue() {
        return null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.value;
    }
}

