/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IFilteringCommand;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Predicate;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.visitors.NodeVisitor;

public class WhereCommand
extends CommandNode
implements IFilteringCommand {
    private final IWherePredicate where;

    public WhereCommand(CommandNode source, IPredicate where) {
        super(source, "where", CommandType.SP_STREAM, new FieldsAndProperties().where(Predicate.where(where)).array());
        this.where = WhereCommand.wrapIfNeeded(Predicate.where(where));
    }

    @Override
    public IPredicate getPredicate() {
        return this.where;
    }

    @Override
    public CommandNode getCommand() {
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new WhereCommand(source, this.where);
    }

    private static IWherePredicate wrapIfNeeded(IWherePredicate node) {
        if (node instanceof AndNode || node instanceof OrNode || node instanceof NotNode) {
            return node;
        }
        if (node != null) {
            return new AndNode(node);
        }
        return new AndNode(new IWherePredicate[0]);
    }
}

