/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IFilteringCommand;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.TStatsOptions;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.AssertingVisitor;
import com.splunk.commons.visitors.NodeVisitor;

public class TStatsCommand
extends CommandNode
implements IFilteringCommand {
    private final AggregateNode[] aggregates;
    private final IGroupBy[] byFields;
    private final ISearchPredicate where;
    private final String namespace;
    private final boolean append;
    private final TStatsOptions options;

    public TStatsCommand(AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where) {
        this(aggregates, byFields, where, null, null);
    }

    public TStatsCommand(CommandNode source, AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where) {
        this(source, aggregates, byFields, where, null, null);
    }

    public TStatsCommand(AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where, String namespace, TStatsOptions options) {
        super("tstats", CommandType.SP_STREAMREPORT, new FieldsAndProperties().tstats(aggregates, byFields, where).array());
        if (aggregates == null || aggregates.length == 0) {
            throw new IllegalArgumentException("Must specify at least one aggregate");
        }
        AssertingVisitor.assertOnlySearchComparisonsAndGroups(where, "TStats only supports comparisons, using TERMS and PHRASES outside comparisons is NOT supported.");
        this.aggregates = aggregates;
        this.byFields = byFields;
        this.where = where;
        this.namespace = namespace;
        this.append = false;
        this.options = options == null ? new TStatsOptions() : options;
    }

    public TStatsCommand(CommandNode source, AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where, String namespace, TStatsOptions options) {
        super(source, "tstats", CommandType.SP_STREAMREPORT, new FieldsAndProperties().tstats(aggregates, byFields, where).array());
        if (aggregates == null || aggregates.length == 0) {
            throw new IllegalArgumentException("Must specify at least one aggregate");
        }
        AssertingVisitor.assertOnlySearchComparisonsAndGroups(where, "TStats only supports comparisons, using TERMS and PHRASES outside comparisons is NOT supported.");
        this.aggregates = aggregates;
        this.byFields = byFields;
        this.where = where;
        this.namespace = namespace;
        this.append = true;
        this.options = options == null ? new TStatsOptions() : options;
    }

    public AggregateNode[] getAggregates() {
        return this.aggregates;
    }

    public IGroupBy[] getByFields() {
        return this.byFields;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isAppend() {
        return this.append;
    }

    public TStatsOptions getOptions() {
        return this.options;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IPredicate getPredicate() {
        return this.where;
    }

    @Override
    public CommandNode getCommand() {
        return this;
    }
}

