/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.JoinType;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class JoinCommand
extends CommandNode {
    public static final boolean DEFAULT_USETIME = true;
    public static final boolean DEFAULT_EARLIER = true;
    public static final boolean DEFAULT_OVERWRITE = true;
    public static final int DEFAULT_MAX_JOIN_CARDINALITY = 1;
    public static final String DEFAULT_ALIAS = "";
    public static final JoinType DEFAULT_JOIN_TYPE = JoinType.INNER;
    private final String lhsAlias;
    private final String rhsAlias;
    private final JoinType joinType;
    private final JoinNode[] joinClauses;
    private final boolean usetime;
    private final boolean earlier;
    private final boolean overwrite;
    private final int max;

    public JoinCommand(CommandNode lhs, CommandNode rhs, String[] joinFields) {
        this(lhs, rhs, joinFields, DEFAULT_JOIN_TYPE, true, true, true, 1);
    }

    public JoinCommand(CommandNode lhs, CommandNode rhs, String[] joinFields, JoinType joinType, String lhsAlias, String rhsAlias) {
        this(lhs, rhs, JoinCommand.convertToJoinNode(joinFields), joinType, true, true, true, 1, lhsAlias, rhsAlias);
    }

    public JoinCommand(CommandNode lhs, CommandNode rhs, String[] joinFields, JoinType joinType, boolean usetime, boolean earlier, boolean overwrite, int max) {
        this(lhs, rhs, JoinCommand.convertToJoinNode(joinFields), joinType, usetime, earlier, overwrite, max, DEFAULT_ALIAS, DEFAULT_ALIAS);
    }

    public JoinCommand(CommandNode lhs, CommandNode rhs, JoinNode[] joinClauses, String lhsAlias, String rhsAlias) {
        this(lhs, rhs, joinClauses, DEFAULT_JOIN_TYPE, true, true, true, 1, lhsAlias, rhsAlias);
    }

    public JoinCommand(CommandNode lhs, CommandNode rhs, JoinNode[] joinClauses, JoinType joinType, boolean usetime, boolean earlier, boolean overwrite, int max, String lhsAlias, String rhsAlias) {
        this("join", lhs, rhs, joinClauses, joinType, usetime, earlier, overwrite, max, lhsAlias, rhsAlias);
    }

    public JoinCommand(String commandName, CommandNode lhs, CommandNode rhs, JoinNode[] joinClauses, JoinType joinType, boolean usetime, boolean earlier, boolean overwrite, int max, String lhsAlias, String rhsAlias) {
        CommandNode[] commandNodeArray;
        if (rhs == null) {
            CommandNode[] commandNodeArray2 = new CommandNode[1];
            commandNodeArray = commandNodeArray2;
            commandNodeArray2[0] = lhs;
        } else {
            CommandNode[] commandNodeArray3 = new CommandNode[2];
            commandNodeArray3[0] = lhs;
            commandNodeArray = commandNodeArray3;
            commandNodeArray3[1] = rhs;
        }
        super(commandNodeArray, commandName, CommandType.SP_STATEFUL, new FieldsAndProperties().join(joinType, joinClauses, overwrite, lhsAlias, rhsAlias).array());
        JoinCommand.assertParamNotNull(lhs, "lhs");
        if ("join".equals(commandName)) {
            JoinCommand.assertParamNotNull(rhs, "rhs");
        }
        JoinCommand.assertParamMembersNotNull(joinClauses, "joinClauses");
        JoinCommand.assertParamNotNull(lhsAlias, "lhsAlias");
        JoinCommand.assertParamNotNull(rhsAlias, "rhsAlias");
        JoinCommand.assertTrue("Max must be non-negative.", max >= 0);
        JoinCommand.assertTrue("Aliases must either both be empty or both be non-empty.", JoinCommand.validAliasCombination(lhsAlias, rhsAlias));
        this.joinType = joinType;
        this.joinClauses = joinClauses;
        this.usetime = usetime;
        this.earlier = earlier;
        this.overwrite = overwrite;
        this.max = max;
        this.lhsAlias = lhsAlias;
        this.rhsAlias = rhsAlias;
    }

    public static boolean isV2(JoinCommand join) {
        JoinCommand.assertNotNull("Expected a non null JoinCommand.", join);
        return JoinCommand.isV2(join.getJoinClauses(), join.lhsAlias, join.rhsAlias);
    }

    public static boolean isV2(JoinNode[] clauses, String lhsAlias, String rhsAlias) {
        for (JoinNode j : clauses) {
            if (!j.requiresV2Join()) continue;
            return true;
        }
        return !lhsAlias.equals(rhsAlias);
    }

    public boolean isV2() {
        return JoinCommand.isV2(this);
    }

    private static CommandNode downgradeToV1(JoinCommand join) {
        JoinCommand.assertNotNull("Expected a non null JoinCommand.", join);
        if (JoinCommand.isV2(join)) {
            CommandNode lhs = join.getSources()[0];
            CommandNode rhs = join.getSources()[1];
            lhs = new RenameCommand(lhs, new RenameNode[]{new RenameNode("*", join.lhsAlias + ".*")});
            rhs = new RenameCommand(rhs, new RenameNode[]{new RenameNode("*", join.rhsAlias + ".*")});
            lhs = new RenameCommand(lhs, new RenameNode[]{new RenameNode(join.lhsAlias + "._*", "_*")});
            rhs = new RenameCommand(rhs, new RenameNode[]{new RenameNode(join.rhsAlias + "._*", "_*")});
            String[] joins = new String[join.getJoinClauses().length];
            FieldNode[] joinFields = new FieldNode[joins.length];
            AssignmentNode[] lhsAssignments = new AssignmentNode[joins.length];
            AssignmentNode[] rhsAssignments = new AssignmentNode[joins.length];
            for (int i = 0; i < joinFields.length; ++i) {
                joins[i] = "_jn" + i;
                joinFields[i] = new FieldNode(joins[i]);
                lhsAssignments[i] = new AssignmentNode(joins[i], (TypeNode)new FieldNode(join.lhsAlias + '.' + join.getJoinClauses()[i].getLeftSide().getFieldName()));
                rhsAssignments[i] = new AssignmentNode(joins[i], (TypeNode)new FieldNode(join.rhsAlias + '.' + join.getJoinClauses()[i].getRightSide().getFieldName()));
            }
            lhs = new EvalCommand(lhs, lhsAssignments);
            rhs = new EvalCommand(rhs, rhsAssignments);
            join = new JoinCommand(lhs, rhs, joins, join.joinType, join.usetime, join.earlier, join.overwrite, join.max);
            return new FieldsCommand(join, joinFields, true);
        }
        return join;
    }

    public CommandNode downgradeToV1() {
        return JoinCommand.downgradeToV1(this);
    }

    private static JoinNode[] convertToJoinNode(String[] fields) {
        JoinNode[] nodes = new JoinNode[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            nodes[i] = new JoinNode(fields[i]);
        }
        return nodes;
    }

    public static boolean validAliasCombination(String lhsAlias, String rhsAlias) {
        if (lhsAlias.equals(rhsAlias)) {
            return true;
        }
        return !rhsAlias.equals(DEFAULT_ALIAS) && !lhsAlias.equals(DEFAULT_ALIAS);
    }

    public CommandNode getLhs() {
        return this.getSources()[0];
    }

    public CommandNode getRhs() {
        return this.getSources()[1];
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinNode[] getJoinClauses() {
        return this.joinClauses;
    }

    public boolean isUsetime() {
        return this.usetime;
    }

    public boolean isEarlier() {
        return this.earlier;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public int getMax() {
        return this.max;
    }

    public String getLhsAlias() {
        return this.lhsAlias;
    }

    public String getRhsAlias() {
        return this.rhsAlias;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSources(CommandNode[] sources) {
        JoinCommand.assertTrue(sources.length == 2);
        return new JoinCommand(sources[0], sources[1], this.joinClauses, this.joinType, this.usetime, this.earlier, this.overwrite, this.max, this.lhsAlias, this.rhsAlias);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new JoinCommand(source, this.getSources()[1], this.joinClauses, this.joinType, this.usetime, this.earlier, this.overwrite, this.max, this.lhsAlias, this.rhsAlias);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }
}

